/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.align.VcfRefAltAlign;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpeff.vcf.VcfLof;
import org.snpeff.vcf.VcfNmd;

public class VcfEntry
extends Marker
implements Iterable<VcfGenotype> {
    public static final String FILTER_PASS = "PASS";
    public static final char WITHIN_FIELD_SEP = ',';
    public static final String SUB_FIELD_SEP = ";";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final double ALLELE_FEQUENCY_COMMON = 0.05;
    public static final double ALLELE_FEQUENCY_LOW = 0.01;
    public static final int MAX_PADN = 1000;
    public static final Pattern INFO_KEY_PATTERN = Pattern.compile("[\\p{Alpha}_][\\p{Alnum}._]*");
    public static final String VCF_ALT_NON_REF = "<*>";
    public static final String VCF_ALT_NON_REF_OLD = "<NON_REF>";
    public static final String VCF_ALT_MISSING_REF = "*";
    public static final String VCF_ALT_INV = "<INV>";
    public static final String[] VCF_ALT_A_ARRAY = new String[]{"A"};
    public static final String[] VCF_ALT_C_ARRAY = new String[]{"C"};
    public static final String[] VCF_ALT_G_ARRAY = new String[]{"G"};
    public static final String[] VCF_ALT_T_ARRAY = new String[]{"T"};
    public static final String[] VCF_ALT_N_ARRAY = new String[]{"A", "C", "G", "T"};
    public static final String[] VCF_ALT_B_ARRAY = new String[]{"C", "G", "T"};
    public static final String[] VCF_ALT_D_ARRAY = new String[]{"A", "G", "T"};
    public static final String[] VCF_ALT_H_ARRAY = new String[]{"A", "C", "T"};
    public static final String[] VCF_ALT_V_ARRAY = new String[]{"A", "C", "G"};
    public static final String[] VCF_ALT_M_ARRAY = new String[]{"A", "C"};
    public static final String[] VCF_ALT_R_ARRAY = new String[]{"A", "G"};
    public static final String[] VCF_ALT_W_ARRAY = new String[]{"A", "T"};
    public static final String[] VCF_ALT_S_ARRAY = new String[]{"C", "G"};
    public static final String[] VCF_ALT_Y_ARRAY = new String[]{"C", "T"};
    public static final String[] VCF_ALT_K_ARRAY = new String[]{"G", "T"};
    public static final String[] VCF_ALT_ASTERISK_ARRAY = new String[]{"*"};
    public static final String[] VCF_ALT_MISSING_ARRAY = new String[]{"."};
    public static final String[] VCF_ALT_NON_REF_OLD_ARRAY = new String[]{"<NON_REF>"};
    public static final String[] VCF_ALT_NON_REF_ARRAY = new String[]{"<*>"};
    public static final String[] VCF_ALT_INV_ARRAY = new String[]{"<INV>"};
    public static final String VCF_INFO_END = "END";
    public static final String VCF_INFO_SVLEN = "SVLEN";
    public static final String VCF_INFO_IMPRECISE = "IMPRECISE";
    public static final String VCF_INFO_HOMS = "HO";
    public static final String VCF_INFO_HETS = "HE";
    public static final String VCF_INFO_NAS = "NA";
    public static final String VCF_INFO_PRIVATE = "Private";
    private static final Map<String, String> INFO_VALUE_ENCODE = new HashMap<String, String>();
    private static final long serialVersionUID = 4226374412681243433L;
    protected String[] alts;
    protected String altStr;
    protected String chromosomeName;
    protected String filter;
    protected String format;
    protected String[] formatFields;
    protected String[] genotypeFields;
    protected String genotypeFieldsStr;
    protected byte[] genotypeScores;
    protected HashMap<String, String> info;
    protected String infoStr = "";
    protected String line;
    protected int lineNum;
    protected Double quality;
    protected String ref;
    protected LinkedList<Variant> variants;
    protected List<VcfEffect> vcfEffects;
    protected VcfFileIterator vcfFileIterator;
    protected ArrayList<VcfGenotype> vcfGenotypes = null;

    public static String cleanUnderscores(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        char[] schars = s.toCharArray();
        boolean first = true;
        boolean previusIsUnderscore = false;
        for (char c : schars) {
            if (c == '_') {
                if (first) continue;
                previusIsUnderscore = true;
                continue;
            }
            if (previusIsUnderscore) {
                previusIsUnderscore = false;
                sb.append('_');
            }
            sb.append(c);
            first = false;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String value) {
        if (value == null || value.isEmpty() || value.equals(".")) {
            return true;
        }
        if (value.indexOf(44) >= 0) {
            String[] values;
            for (String val : values = value.split(",")) {
                if (val.isEmpty() || val.equals(".")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidInfoKey(String key) {
        Matcher m = INFO_KEY_PATTERN.matcher(key);
        return m.matches();
    }

    public static boolean isValidInfoValue(String value) {
        boolean invalid = value != null && (value.indexOf(32) >= 0 || value.indexOf(59) >= 0 || value.indexOf(61) >= 0 || value.indexOf(9) >= 0 || value.indexOf(10) >= 0);
        return !invalid;
    }

    String padNs(String ref, int len) {
        if (len > 1000) {
            len = 1000;
        }
        if (ref == null || ref.isEmpty()) {
            char[] bases = new char[len];
            Arrays.fill(bases, 'N');
            return new String(bases);
        }
        if (ref.length() >= len) {
            return ref;
        }
        char[] bases = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            bases[i2] = i2 < ref.length() ? (int)ref.charAt(i2) : 78;
        }
        return new String(bases);
    }

    public static String vcfInfoDecode(String str) {
        if (str == null || str.isEmpty() || str.equals(".")) {
            return str;
        }
        for (String encoded : INFO_VALUE_ENCODE.keySet()) {
            str = str.replace(encoded, INFO_VALUE_ENCODE.get(encoded));
        }
        return str;
    }

    public static String vcfInfoEncode(String str) {
        if (str == null || str.isEmpty() || str.equals(".")) {
            return str;
        }
        for (String encoded : INFO_VALUE_ENCODE.keySet()) {
            str = str.replace(INFO_VALUE_ENCODE.get(encoded), encoded);
        }
        return str.replaceAll(" ", "_");
    }

    public static String vcfInfoKeySafe(String str) {
        if (str == null) {
            return str;
        }
        char c0 = ((String)(str = ((String)str).replaceAll("[^a-zA-Z0-9_.]", "_"))).charAt(0);
        if (c0 != '_' && !Character.isAlphabetic(c0)) {
            str = "_" + (String)str;
        }
        return str;
    }

    public static String vcfInfoValueSafe(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("[ ,;|=()\t]", "_");
    }

    public VcfEntry(VcfFileIterator vcfFileIterator, Marker parent, String chromosomeName, int start, String id, String ref, String altsStr, double quality, String filterPass, String infoStr, String format) {
        super(parent, start, start + ref.length() - 1, false, id);
        this.chromosomeName = chromosomeName;
        this.ref = ref;
        this.alts = this.parseAlts(altsStr);
        this.quality = quality;
        this.filter = filterPass;
        this.infoStr = infoStr;
        this.parseInfo();
        this.format = format;
        this.end = this.parseEnd();
    }

    public VcfEntry(VcfFileIterator vcfFileIterator, String line, int lineNum, boolean parseNow) {
        super(null, 0, 0, false, "");
        this.vcfFileIterator = vcfFileIterator;
        this.lineNum = lineNum;
        this.line = line;
        if (parseNow) {
            this.parse();
        }
    }

    public void addFilter(String filterStr) {
        if (this.filter.equals(".") || this.filter.equals(FILTER_PASS)) {
            this.filter = "";
        }
        this.filter = this.filter + (!this.filter.isEmpty() ? SUB_FIELD_SEP : "") + filterStr;
    }

    public void addFormat(String formatName) {
        if (this.format == null) {
            this.format = "";
        }
        if (this.format.indexOf(formatName) >= 0) {
            throw new RuntimeException("Format field '" + formatName + "' already exists!");
        }
        this.format = this.format + (this.format.endsWith(":") ? "" : ":") + formatName;
    }

    public void addGenotype(String vcfGenotypeStr) {
        if (this.vcfGenotypes == null) {
            this.vcfGenotypes = new ArrayList();
        }
        if (this.format == null) {
            this.format = "";
        }
        this.vcfGenotypes.add(new VcfGenotype(this, this.format, vcfGenotypeStr));
        this.genotypeScores = null;
    }

    public void addInfo(String key, String value) {
        if (!VcfEntry.isValidInfoKey(key)) {
            Log.warning(ErrorWarningType.WARNING_INVALID_INFO_KEY, "Illegal INFO key / name. Key: \"" + key + "\" does not match regular expression ^[A-Za-z_][0-9A-Za-z_.]*$");
        }
        if (!VcfEntry.isValidInfoValue(value)) {
            Log.warning(ErrorWarningType.WARNING_INVALID_INFO_VALUE, "No white-space, semi-colons, or equals-signs are permitted in INFO field values. Name:\"" + key + "\" Value:\"" + value + "\"");
        }
        this.removeInfo(key);
        boolean isFlag = false;
        VcfHeader vcfHeader = this.vcfFileIterator.getVcfHeader();
        if (vcfHeader != null) {
            VcfHeaderInfo vcfHeaderInfo = this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(key);
            boolean bl = isFlag = vcfHeaderInfo != null && vcfHeaderInfo.getVcfInfoType() == VcfInfoType.Flag;
        }
        if (this.info != null) {
            this.info.put(key, value);
        }
        String addInfoStr = key + (String)(value != null && !isFlag ? "=" + value : "");
        if (this.infoStr == null || this.infoStr.isEmpty()) {
            this.infoStr = addInfoStr;
        } else {
            if (!this.infoStr.endsWith(SUB_FIELD_SEP)) {
                this.infoStr = this.infoStr + SUB_FIELD_SEP;
            }
            this.infoStr = this.infoStr + addInfoStr;
        }
    }

    public AlleleFrequencyType alleleFrequencyType() {
        double maf = this.maf();
        if (maf <= 0.01) {
            return AlleleFrequencyType.Rare;
        }
        if (maf <= 0.05) {
            return AlleleFrequencyType.LowFrequency;
        }
        return AlleleFrequencyType.Common;
    }

    public Boolean calcHetero() {
        if (this.genotypeFieldsStr == null) {
            return this.isMultiallelic();
        }
        Boolean isHetero = null;
        if (this.genotypeFields == null) {
            int countFields = 0;
            for (int fromIndex = 0; fromIndex >= 0 && countFields < 1; ++countFields, ++fromIndex) {
                fromIndex = this.genotypeFieldsStr.indexOf(9, fromIndex);
            }
            if (countFields == 1) {
                this.parseGenotypes();
            }
        }
        if (this.genotypeFields != null && this.genotypeFields.length == 1) {
            isHetero = this.getVcfGenotype(0).isHeterozygous();
        }
        return isHetero;
    }

    public String check() {
        StringBuilder sb = new StringBuilder();
        if (this.ref.indexOf(",") >= 0) {
            sb.append("REF field has multiple entries (this is not allowed)\n");
        }
        for (String infoName : this.getInfoKeys()) {
            String err = this.checkInfo(infoName);
            if (err.isEmpty()) continue;
            sb.append(err + "\n");
        }
        sb.append(this.checkGenotypes());
        return sb.toString();
    }

    String checkGenotypes() {
        int numSamples;
        int numGt;
        StringBuilder err = new StringBuilder();
        if (this.getVcfFileIterator() != null && this.getVcfFileIterator().getVcfHeader() != null && (numGt = this.getVcfGenotypes().size()) != (numSamples = this.getVcfFileIterator().getVcfHeader().getNumberOfSamples())) {
            err.append("Number of genotypes (" + numGt + ") differs form the number of samples (" + numSamples + ")\n");
        }
        int numAlts = this.getAlts().length;
        int gtNum = 1;
        for (VcfGenotype vgt : this.getVcfGenotypes()) {
            int[] gts = vgt.getGenotype();
            if (gts != null) {
                for (int i2 = 0; i2 < gts.length; ++i2) {
                    if (gts[i2] <= numAlts) continue;
                    err.append("Genotype number " + gtNum + " has genotype number '" + gts[i2] + "', but there are only '" + numAlts + "' ALTs.\n");
                }
            }
            ++gtNum;
        }
        return err.toString();
    }

    String checkInfo(String infoName) {
        VcfInfoType type;
        String[] values;
        if (infoName.isEmpty()) {
            return "";
        }
        VcfHeaderInfo vcfInfo = this.getVcfInfo(infoName);
        if (vcfInfo == null) {
            return "Cannot find header for INFO field '" + infoName + "'";
        }
        String valsStr = this.getInfo(infoName);
        if (valsStr == null) {
            return "";
        }
        for (String val : values = valsStr.split(",")) {
            if (VcfEntry.isValidInfoValue(val)) continue;
            return "INFO field '" + infoName + "' has an invalid value '" + val + "' (no spaces, tabs, '=' or ';' are allowed)";
        }
        if (vcfInfo.isNumberNumber() && vcfInfo.getNumber() != values.length && ((type = vcfInfo.getVcfInfoType()) != VcfInfoType.Flag || values.length != 1)) {
            return "INFO filed '" + infoName + "' has 'Number=" + vcfInfo.getNumber() + "' in header, but it contains '" + values.length + "' elements.";
        }
        if (vcfInfo.isNumberAllAlleles() && values.length != this.alts.length + 1) {
            return "INFO filed '" + infoName + "' has 'Number=R' in header, but it contains '" + values.length + "' elements when there are '" + this.alts.length + "' alleles (it should have '" + (this.alts.length + 1) + "' elements).";
        }
        if (vcfInfo.isNumberAllAlleles() && values.length != this.alts.length) {
            return "INFO filed '" + infoName + "' has 'Number=A' in header, but it contains '" + values.length + "' elements when there are '" + this.alts.length + "' alleles.";
        }
        return "";
    }

    @Override
    public Cds cloneShallow() {
        throw new RuntimeException("Unimplemented!");
    }

    public boolean compressGenotypes() {
        if (this.getAlts().length > 1) {
            return false;
        }
        StringBuilder homs = new StringBuilder();
        StringBuilder hets = new StringBuilder();
        StringBuilder nas = new StringBuilder();
        int idx = 0;
        for (VcfGenotype gen : this.getVcfGenotypes()) {
            int score = gen.getGenotypeCode();
            if (score != 0) {
                if (score < 0) {
                    nas.append((nas.length() > 0 ? "," : "") + idx);
                } else if (score == 1) {
                    hets.append((hets.length() > 0 ? "," : "") + idx);
                } else if (score == 2) {
                    homs.append((homs.length() > 0 ? "," : "") + idx);
                } else {
                    return false;
                }
            }
            ++idx;
        }
        if (homs.length() > 0) {
            this.addInfo(VCF_INFO_HOMS, homs.toString());
        }
        if (hets.length() > 0) {
            this.addInfo(VCF_INFO_HETS, hets.toString());
        }
        if (nas.length() > 0) {
            this.addInfo(VCF_INFO_NAS, nas.toString());
        }
        if (homs.length() == 0 && hets.length() == 0 && nas.length() == 0) {
            this.addInfo(VCF_INFO_NAS, null);
        }
        return true;
    }

    public boolean delFilter(String filterStr) {
        StringBuilder sbFilter = new StringBuilder();
        boolean removed = false;
        for (String f : this.filter.split(SUB_FIELD_SEP)) {
            if (!f.equals(filterStr)) {
                sbFilter.append((sbFilter.length() > 0 ? SUB_FIELD_SEP : "") + f);
                continue;
            }
            removed = true;
        }
        if (removed) {
            this.filter = sbFilter.toString();
        }
        return removed;
    }

    public int getAltIndex(String alt) {
        for (int i2 = 0; i2 < this.alts.length; ++i2) {
            if (!this.alts[i2].equalsIgnoreCase(alt)) continue;
            return i2;
        }
        return -1;
    }

    public String[] getAlts() {
        return this.alts;
    }

    public String getAltsStr() {
        if (this.altStr != null) {
            if (this.altStr.isEmpty()) {
                return ".";
            }
            return this.altStr;
        }
        if (this.alts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String alt : this.alts) {
            sb.append(alt + " ");
        }
        this.altStr = sb.toString().trim().replace(' ', ',');
        return this.altStr;
    }

    @Override
    public String getChromosomeNameOri() {
        return this.chromosomeName;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getFormatFields() {
        if (this.formatFields == null) {
            this.formatFields = this.format == null ? new String[0] : this.format.split(":");
        }
        return this.formatFields;
    }

    public synchronized byte[] getGenotypesScores() {
        if (this.genotypeScores != null) {
            return this.genotypeScores;
        }
        if (!this.isCompressedGenotypes()) {
            List<VcfGenotype> vcfGts = this.getVcfGenotypes();
            int numSamples = vcfGts.size();
            this.genotypeScores = new byte[numSamples];
            int idx = 0;
            for (VcfGenotype vcfGt : vcfGts) {
                this.genotypeScores[idx++] = (byte)vcfGt.getGenotypeCode();
            }
            return this.genotypeScores;
        }
        String hoStr = this.getInfo(VCF_INFO_HOMS);
        String heStr = this.getInfo(VCF_INFO_HETS);
        String naStr = this.getInfo(VCF_INFO_NAS);
        int numSamples = this.getNumberOfSamples();
        this.genotypeScores = new byte[numSamples];
        this.parseSparseGt(naStr, this.genotypeScores, -1);
        this.parseSparseGt(heStr, this.genotypeScores, 1);
        this.parseSparseGt(hoStr, this.genotypeScores, 2);
        return this.genotypeScores;
    }

    public String getInfo(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.get(key);
    }

    public String getInfo(String key, String allele) {
        String infoStr;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((infoStr = this.info.get(key)) == null) {
            return null;
        }
        String[] infos = infoStr.split(",");
        int firstAltIndex = 0;
        VcfHeaderInfo vcfInfo = this.getVcfInfo(key);
        if (vcfInfo != null && vcfInfo.isNumberAllAlleles()) {
            firstAltIndex = 1;
            if (this.ref.equalsIgnoreCase(allele)) {
                return infos[0];
            }
        }
        int i2 = 0;
        for (int j = firstAltIndex; i2 < this.alts.length && j < infos.length; ++i2, ++j) {
            if (!this.alts[i2].equalsIgnoreCase(allele)) continue;
            return infos[j];
        }
        return null;
    }

    public String getInfo(String key, Variant var) {
        String infoStr;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((infoStr = this.info.get(key)) == null) {
            return null;
        }
        String[] infos = infoStr.split(",");
        int firstAltIndex = 0;
        VcfHeaderInfo vcfInfo = this.getVcfInfo(key);
        if (vcfInfo != null && vcfInfo.isNumberAllAlleles()) {
            firstAltIndex = 1;
            if (!var.isVariant()) {
                return infos[0];
            }
        }
        int i2 = firstAltIndex;
        String gtPrev = "";
        for (Variant v : this.variants()) {
            if (i2 >= infos.length) break;
            if (var.equals(v)) {
                return infos[i2];
            }
            if (v.getGenotype().equals(gtPrev)) continue;
            ++i2;
        }
        return null;
    }

    public boolean getInfoFlag(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.containsKey(key);
    }

    public double getInfoFloat(String key) {
        String f;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((f = this.info.get(key)) == null) {
            return Double.NaN;
        }
        return Gpr.parseDoubleSafe(f);
    }

    public long getInfoInt(String key) {
        String i2;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((i2 = this.info.get(key)) == null) {
            return 0L;
        }
        return Gpr.parseLongSafe(i2);
    }

    public Set<String> getInfoKeys() {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.keySet();
    }

    public String getInfoStr() {
        return this.infoStr;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getNumberOfSamples() {
        if (this.vcfFileIterator == null) {
            return 0;
        }
        VcfHeader vh = this.vcfFileIterator.getVcfHeader();
        if (vh == null) {
            return 0;
        }
        return vh.getNumberOfSamples();
    }

    public double getQuality() {
        return this.quality != null ? this.quality : 0.0;
    }

    public String getRef() {
        return this.ref;
    }

    public String getStr() {
        return this.getChromosomeName() + ":" + (this.start + 1) + "_" + this.ref + "/" + this.getAltsStr();
    }

    public List<VcfEffect> getVcfEffects() {
        return this.getVcfEffects(null);
    }

    public synchronized List<VcfEffect> getVcfEffects(EffFormatVersion formatVersion) {
        String[] effs;
        if (this.vcfEffects != null) {
            return this.vcfEffects;
        }
        String effStr = null;
        if (formatVersion == null) {
            effStr = this.getInfo("ANN");
            if (effStr != null) {
                formatVersion = EffFormatVersion.FORMAT_ANN;
            } else {
                effStr = this.getInfo("EFF");
                if (effStr != null) {
                    formatVersion = EffFormatVersion.FORMAT_EFF;
                }
            }
        } else {
            String effFieldName = VcfEffect.infoFieldName(formatVersion);
            effStr = this.getInfo(effFieldName);
        }
        this.vcfEffects = new ArrayList<VcfEffect>();
        if (effStr == null || effStr.isEmpty() || effStr.equals("true")) {
            return this.vcfEffects;
        }
        for (String eff : effs = effStr.split(",")) {
            VcfEffect veff = new VcfEffect(eff, formatVersion);
            this.vcfEffects.add(veff);
        }
        return this.vcfEffects;
    }

    public VcfFileIterator getVcfFileIterator() {
        return this.vcfFileIterator;
    }

    public VcfGenotype getVcfGenotype(int index) {
        return this.getVcfGenotypes().get(index);
    }

    public List<VcfGenotype> getVcfGenotypes() {
        if (this.vcfGenotypes == null) {
            this.parseGenotypes();
        }
        return this.vcfGenotypes;
    }

    public VcfHeaderInfo getVcfInfo(String id) {
        return this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(id);
    }

    public VcfInfoType getVcfInfoNumber(String id) {
        VcfHeaderInfo vcfInfo = this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(id);
        if (vcfInfo == null) {
            return null;
        }
        return vcfInfo.getVcfInfoType();
    }

    public boolean hasAltNonRef() {
        if (this.alts == null || this.alts.length == 0) {
            return false;
        }
        for (String alt : this.alts) {
            if (!this.isAltNonRef(alt)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(String filedName) {
        return this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(filedName) != null;
    }

    public boolean hasGenotypes() {
        return this.vcfGenotypes != null && this.vcfGenotypes.size() > 0 || this.genotypeFieldsStr != null;
    }

    public boolean hasInfo(String infoFieldName) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.containsKey(infoFieldName);
    }

    public boolean hasQuality() {
        return this.quality != null;
    }

    public boolean isAltNonRef(String alt) {
        return alt != null && (alt.equals(VCF_ALT_NON_REF) || alt.equals(VCF_ALT_NON_REF_OLD));
    }

    public boolean isBiAllelic() {
        if (this.alts == null) {
            return false;
        }
        return this.alts.length == 1;
    }

    public boolean isCompressedGenotypes() {
        return !this.hasGenotypes() && this.getNumberOfSamples() > 0 && (this.hasInfo(VCF_INFO_HOMS) || this.hasInfo(VCF_INFO_HETS) || this.hasInfo(VCF_INFO_NAS));
    }

    public boolean isFilterPass() {
        return this.filter.equals(FILTER_PASS);
    }

    public boolean isMultiallelic() {
        if (this.alts == null) {
            return false;
        }
        return this.alts.length > 1;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSingleSnp() {
        return this.ref != null && this.altStr != null && this.ref.length() == 1 && this.altStr.length() == 1 && !this.ref.equalsIgnoreCase(this.altStr);
    }

    public boolean isSingleton() {
        int count = 0;
        for (VcfGenotype gen : this) {
            if (gen.isVariant()) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    public boolean isVariant() {
        if (this.alts == null || this.alts.length == 0) {
            return false;
        }
        for (String alt : this.alts) {
            if (!this.isVariant(alt)) continue;
            return true;
        }
        return false;
    }

    public boolean isVariant(String alt) {
        return alt != null && !alt.isEmpty() && !alt.equals(".") && !alt.equals(VCF_ALT_NON_REF) && !alt.equals(VCF_ALT_NON_REF_OLD) && !alt.equals(VCF_ALT_MISSING_REF) && !alt.equals(this.ref);
    }

    @Override
    public Iterator<VcfGenotype> iterator() {
        return this.getVcfGenotypes().iterator();
    }

    public int mac() {
        long ac = -1L;
        if (this.hasField("MAC")) {
            return (int)this.getInfoInt("MAC");
        }
        if (this.hasField("AC")) {
            ac = this.getInfoInt("AC");
        }
        if (ac <= 0L) {
            ac = 0L;
            for (byte genCode : this.getGenotypesScores()) {
                if (genCode <= 0) continue;
                ac += (long)genCode;
            }
        }
        int numSamples = 0;
        List<String> sampleNames = this.vcfFileIterator.getVcfHeader().getSampleNames();
        numSamples = sampleNames != null ? sampleNames.size() : this.getVcfGenotypes().size();
        if (numSamples > 1 && ac > (long)numSamples) {
            ac = (long)(2 * numSamples) - ac;
        }
        return (int)ac;
    }

    public double maf() {
        double maf = -1.0;
        if (this.hasField("AF")) {
            maf = this.getInfoFloat("AF");
        } else if (this.hasField("MAF")) {
            maf = this.getInfoFloat("MAF");
        } else {
            int ac = 0;
            int count = 0;
            for (VcfGenotype gen : this) {
                count += 2;
                int genCode = gen.getGenotypeCode();
                if (genCode <= 0) continue;
                ac += genCode;
            }
            maf = (double)ac / (double)count;
        }
        if (maf > 0.5) {
            maf = 1.0 - maf;
        }
        return maf;
    }

    public void parse() {
        String[] fields = this.line.split("\t", 10);
        if (fields.length >= 4) {
            this.chromosomeName = fields[0].trim();
            Chromosome chromo = this.vcfFileIterator.getChromosome(this.chromosomeName);
            this.parent = chromo;
            this.vcfFileIterator.sanityCheckChromo(this.chromosomeName, chromo);
            this.start = this.vcfFileIterator.parsePosition(this.vcfFileIterator.readField(fields, 1));
            this.id = this.vcfFileIterator.readField(fields, 2);
            this.ref = this.vcfFileIterator.readField(fields, 3).toUpperCase();
            this.strandMinus = false;
            this.altStr = this.vcfFileIterator.readField(fields, 4).toUpperCase();
            this.alts = this.parseAlts(this.altStr);
            String qStr = this.vcfFileIterator.readField(fields, 5);
            this.quality = !qStr.isEmpty() ? Double.valueOf(Gpr.parseDoubleSafe(qStr)) : null;
            this.filter = this.vcfFileIterator.readField(fields, 6);
            this.infoStr = this.vcfFileIterator.readField(fields, 7);
            this.info = null;
            this.end = this.parseEnd();
            this.format = null;
            if (fields.length > 8) {
                this.format = this.vcfFileIterator.readField(fields, 8);
            }
            if (fields.length > 9) {
                this.genotypeFieldsStr = fields[9];
            }
        } else {
            throw new RuntimeException("Impropper VCF entry: Not enough fields (missing tab separators?).\n" + this.line);
        }
    }

    String[] parseAlts(String altsStr) {
        String[] altsSplit;
        if (altsStr.length() == 1) {
            return this.parseAltSingleChar(altsStr);
        }
        if (altsStr.indexOf(44) < 0) {
            this.alts = this.parseAltSingle(altsStr);
            return this.alts != null ? this.alts : new String[]{};
        }
        ArrayList<String> altsList = new ArrayList<String>();
        for (String altSingle : altsSplit = altsStr.split(",")) {
            String[] altsTmp = this.parseAltSingle(altSingle);
            if (altsTmp == null) continue;
            for (String alt : altsTmp) {
                altsList.add(alt);
            }
        }
        return altsList.toArray(EMPTY_STRING_ARRAY);
    }

    String[] parseAltSingle(String altsStr) {
        if (altsStr.length() == 1) {
            return this.parseAltSingleChar(altsStr);
        }
        return new String[]{altsStr};
    }

    String[] parseAltSingleChar(String altsStr) {
        switch (altsStr) {
            case "A": {
                return VCF_ALT_A_ARRAY;
            }
            case "C": {
                return VCF_ALT_C_ARRAY;
            }
            case "G": {
                return VCF_ALT_G_ARRAY;
            }
            case "T": {
                return VCF_ALT_T_ARRAY;
            }
            case "*": {
                return VCF_ALT_ASTERISK_ARRAY;
            }
            case ".": {
                return VCF_ALT_MISSING_ARRAY;
            }
        }
        if (!this.vcfFileIterator.isExpandIub()) {
            return new String[]{altsStr};
        }
        switch (altsStr) {
            case "N": {
                return VCF_ALT_N_ARRAY;
            }
            case "B": {
                return VCF_ALT_B_ARRAY;
            }
            case "D": {
                return VCF_ALT_D_ARRAY;
            }
            case "H": {
                return VCF_ALT_H_ARRAY;
            }
            case "V": {
                return VCF_ALT_V_ARRAY;
            }
            case "M": {
                return VCF_ALT_M_ARRAY;
            }
            case "R": {
                return VCF_ALT_R_ARRAY;
            }
            case "W": {
                return VCF_ALT_W_ARRAY;
            }
            case "S": {
                return VCF_ALT_S_ARRAY;
            }
            case "Y": {
                return VCF_ALT_Y_ARRAY;
            }
            case "K": {
                return VCF_ALT_K_ARRAY;
            }
        }
        throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + altsStr + "'");
    }

    int parseEnd() {
        if (this.ref.length() == 1 && this.altStr.length() == 1) {
            return this.start;
        }
        if (this.altStr.indexOf(60) >= 0) {
            if (this.altStr.indexOf("<INS") >= 0) {
                return this.start;
            }
            if (this.hasInfo(VCF_INFO_END)) {
                this.end = (int)this.getInfoInt(VCF_INFO_END) - 1;
                if (this.end < this.start) {
                    throw new RuntimeException("INFO field 'END' is before varaint's 'POS'\n\tEND : " + this.end + "\n\tPOS : " + this.start);
                }
                return this.end;
            }
            if (this.hasInfo(VCF_INFO_SVLEN)) {
                int svlen = (int)this.getInfoInt(VCF_INFO_SVLEN);
                if (svlen < 0) {
                    svlen = -svlen;
                }
                return this.start + (svlen - 1);
            }
            return this.start + this.ref.length() - 1;
        }
        return this.start + this.ref.length() - 1;
    }

    void parseGenotypes() {
        if (this.isCompressedGenotypes()) {
            this.uncompressGenotypes();
        } else {
            this.vcfGenotypes = new ArrayList();
            if (this.genotypeFieldsStr == null) {
                return;
            }
            this.genotypeFields = this.genotypeFieldsStr.split("\t");
            for (int i2 = 0; i2 < this.genotypeFields.length; ++i2) {
                String gen = this.genotypeFields[i2];
                if (gen.equals(".")) {
                    gen = "";
                }
                this.addGenotype(gen);
            }
        }
    }

    void parseInfo() {
        this.info = new HashMap();
        for (String inf : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] vp = inf.split("=", 2);
            if (vp.length > 1) {
                this.info.put(vp[0], vp[1]);
                continue;
            }
            this.info.put(vp[0], "true");
        }
    }

    public List<VcfLof> parseLof() {
        String[] lofs;
        String lofStr = this.getInfo("LOF");
        ArrayList<VcfLof> lofList = new ArrayList<VcfLof>();
        if (lofStr == null || lofStr.isEmpty()) {
            return lofList;
        }
        for (String lof : lofs = lofStr.split(",")) {
            lofList.add(new VcfLof(this, lof));
        }
        return lofList;
    }

    public List<VcfNmd> parseNmd() {
        String[] nmds;
        String nmdStr = this.getInfo("NMD");
        ArrayList<VcfNmd> nmdList = new ArrayList<VcfNmd>();
        if (nmdStr == null || nmdStr.isEmpty()) {
            return nmdList;
        }
        for (String nmd : nmds = nmdStr.split(",")) {
            nmdList.add(new VcfNmd(nmd));
        }
        return nmdList;
    }

    void parseSparseGt(String str, byte[] gt, int valueInt) {
        if (str == null || str.isEmpty() || str.equals("true")) {
            return;
        }
        String[] idxs = str.split(",");
        byte value = (byte)valueInt;
        for (String idx : idxs) {
            int i2 = Gpr.parseIntSafe(idx);
            gt[i2] = value;
        }
    }

    public void removeInfo(String key) {
        if (!this.infoStr.contains(key)) {
            return;
        }
        StringBuilder infoStrNew = new StringBuilder();
        for (String infoEntry : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] keyValuePair = infoEntry.split("=", 2);
            if (keyValuePair[0].equals(key)) continue;
            if (infoStrNew.length() > 0) {
                infoStrNew.append(';');
            }
            infoStrNew.append(infoEntry);
        }
        this.infoStr = infoStrNew.toString();
        if (this.info != null) {
            this.info.remove(key);
        }
        if (EffFormatVersion.isEffectVcfInfoField(key)) {
            this.vcfEffects = null;
        }
    }

    public boolean rmInfo(String info) {
        boolean deleted = false;
        StringBuilder infoSb = new StringBuilder();
        for (String inf : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] vp = inf.split("=");
            if (vp[0].equals(info)) {
                deleted = true;
                continue;
            }
            if (infoSb.length() > 0) {
                infoSb.append(SUB_FIELD_SEP);
            }
            infoSb.append(vp[0]);
            if (vp.length <= 1) continue;
            infoSb.append("=");
            infoSb.append(vp[1]);
        }
        if (deleted) {
            this.infoStr = infoSb.toString();
        }
        return deleted;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setGenotypeStr(String genotypeFieldsStr) {
        this.genotypeFieldsStr = genotypeFieldsStr;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    @Override
    public String toStr() {
        return this.getClass().getSimpleName() + "_" + this.getChromosomeName() + ":" + (this.start + 1) + "_" + this.ref + "/" + this.getAltsStr();
    }

    @Override
    public String toString() {
        boolean deleteLastTab = true;
        StringBuilder sb = new StringBuilder(this.toStringNoGt());
        sb.append("\t");
        if (this.format != null) {
            sb.append((this.format.isEmpty() ? "." : this.format) + "\t");
            if (this.vcfGenotypes != null && !this.vcfGenotypes.isEmpty()) {
                for (VcfGenotype vg : this.vcfGenotypes) {
                    sb.append(String.valueOf(vg) + "\t");
                }
            } else if (this.genotypeFieldsStr != null) {
                sb.append(this.genotypeFieldsStr);
                deleteLastTab = false;
            }
        }
        if (deleteLastTab) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toStringNoGt() {
        String chr = null;
        chr = this.chromosomeName != null ? this.chromosomeName : (this.parent != null && this.parent instanceof Chromosome ? this.parent.getId() : (this.parent != null ? this.getChromosomeName() : "."));
        StringBuilder sb = new StringBuilder(chr + "\t" + (this.start + 1) + "\t" + (this.id.isEmpty() ? "." : this.id));
        String refStr = this.ref == null || this.ref.isEmpty() ? "." : this.ref;
        sb.append("\t" + refStr);
        sb.append("\t" + this.getAltsStr());
        sb.append("\t" + (String)(this.quality != null ? "" + this.quality : "."));
        sb.append("\t" + (this.filter == null || this.filter.isEmpty() ? "." : this.filter));
        sb.append("\t" + (this.infoStr == null || this.infoStr.isEmpty() ? "." : this.infoStr));
        return sb.toString();
    }

    public VcfEntry uncompressGenotypes() {
        if (!this.isCompressedGenotypes()) {
            return this;
        }
        String hoStr = this.getInfo(VCF_INFO_HOMS);
        String heStr = this.getInfo(VCF_INFO_HETS);
        String naStr = this.getInfo(VCF_INFO_NAS);
        List<String> sampleNames = this.getVcfFileIterator().getVcfHeader().getSampleNames();
        if (sampleNames == null) {
            throw new RuntimeException("Cannot find sample names in VCF header. Unable to uncompress genotypes.");
        }
        int numSamples = sampleNames.size();
        byte[] gt = new byte[numSamples];
        this.parseSparseGt(naStr, gt, -1);
        this.parseSparseGt(heStr, gt, 1);
        this.parseSparseGt(hoStr, gt, 2);
        if (hoStr != null) {
            this.rmInfo(VCF_INFO_HOMS);
        }
        if (heStr != null) {
            this.rmInfo(VCF_INFO_HETS);
        }
        if (naStr != null) {
            this.rmInfo(VCF_INFO_NAS);
        }
        this.setFormat("GT");
        for (int i2 = 0; i2 < gt.length; ++i2) {
            this.addGenotype(switch (gt[i2]) {
                case -1 -> "./.";
                case 0 -> "0/0";
                case 1 -> "0/1";
                case 2 -> "1/1";
                default -> throw new RuntimeException("Unknown code '" + gt[i2] + "'");
            });
        }
        return this;
    }

    public List<Variant> variants() {
        if (this.variants != null) {
            return this.variants;
        }
        this.variants = new LinkedList();
        Chromosome chr = (Chromosome)this.parent;
        if (!this.isVariant()) {
            List<Variant> vars = this.variants(chr, this.start, this.ref, null, this.id);
            String alt = ".";
            for (Variant variant : vars) {
                variant.setGenotype(alt);
            }
            this.variants.addAll(vars);
        } else {
            for (String alt : this.alts) {
                if (!this.isVariant(alt)) {
                    alt = null;
                }
                List<Variant> vars = this.variants(chr, this.start, this.ref, alt, this.id);
                this.variants.addAll(vars);
            }
        }
        return this.variants;
    }

    List<Variant> variants(Chromosome chromo, int start, String reference, String alt, String id) {
        List<Variant> list = null;
        if (alt != null) {
            alt = alt.toUpperCase();
        }
        if ((list = alt == null || alt.isEmpty() || alt.equals(reference) ? Variant.factory(chromo, start, reference, null, id, false) : (reference.length() == 1 && alt.length() == 1 ? Variant.factory(chromo, start, reference, alt, id, this.vcfFileIterator.isExpandIub()) : (alt.charAt(0) == '<' ? this.variantsStructural(chromo, start, reference, alt, id) : (alt.indexOf(91) >= 0 || alt.indexOf(93) >= 0 ? this.variantsTranslocation(chromo, start, reference, alt, id) : (reference.length() == alt.length() ? this.variantsMnp(chromo, start, reference, alt, id) : this.variantsInDelMixed(chromo, start, reference, alt, id)))))) == null) {
            list = new LinkedList<Variant>();
        } else {
            for (Variant variant : list) {
                variant.setGenotype(alt);
            }
        }
        return list;
    }

    List<Variant> variantsInDelMixed(Chromosome chromo, int start, String reference, String alt, String id) {
        VcfRefAltAlign align = new VcfRefAltAlign(alt, reference);
        align.align();
        int startDiff = align.getOffset();
        switch (align.getVariantType()) {
            case DEL: {
                String ref = "";
                String ch = align.getAlignment();
                if (!ch.startsWith("-")) {
                    throw new RuntimeException("Deletion '" + ch + "' does not start with '-'. This should never happen!");
                }
                return Variant.factory(chromo, start + startDiff, ref, ch, id, this.vcfFileIterator.isExpandIub());
            }
            case INS: {
                String ch = align.getAlignment();
                String ref = "";
                if (!ch.startsWith("+")) {
                    throw new RuntimeException("Insertion '" + ch + "' does not start with '+'. This should never happen!");
                }
                return Variant.factory(chromo, start + startDiff, ref, ch, id, this.vcfFileIterator.isExpandIub());
            }
            case MIXED: {
                reference = reference.substring(startDiff);
                alt = alt.substring(startDiff);
                return Variant.factory(chromo, start + startDiff, reference, alt, id, this.vcfFileIterator.isExpandIub());
            }
        }
        throw new RuntimeException("Expecting either 'INS', 'DEL', or 'MIXED'. Unsupported type '" + String.valueOf((Object)align.getVariantType()) + "'\n\tRef: " + reference + "'\n\tAlt: '" + alt + "'\n\tVcfEntry: " + String.valueOf(this));
    }

    List<Variant> variantsMnp(Chromosome chromo, int start, String reference, String alt, String id) {
        int startDiff = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < reference.length(); ++i2) {
            if (reference.charAt(i2) == alt.charAt(i2)) continue;
            startDiff = Math.min(startDiff, i2);
        }
        int endDiff = 0;
        for (int i3 = reference.length() - 1; i3 >= 0; --i3) {
            if (reference.charAt(i3) == alt.charAt(i3)) continue;
            endDiff = Math.max(endDiff, i3);
        }
        String newRef = reference.substring(startDiff, endDiff + 1);
        String newAlt = alt.substring(startDiff, endDiff + 1);
        List<Variant> list = Variant.factory(chromo, start + startDiff, newRef, newAlt, id, this.vcfFileIterator.isExpandIub());
        return list;
    }

    List<Variant> variantsStructural(Chromosome chromo, int start, String reference, String alt, String id) {
        int svlen;
        List<Variant> list = null;
        int startVariant = Math.min(start + 1, this.end);
        String refVariant = reference;
        int n = svlen = this.end >= startVariant ? this.end - startVariant + 1 : 0;
        if (refVariant.length() > 1) {
            refVariant = reference.substring(1);
            refVariant = this.padNs(refVariant, svlen);
        } else {
            refVariant = this.padNs(null, svlen);
        }
        Variant.VariantType vaType = null;
        boolean hasImprecise = this.hasInfo(VCF_INFO_IMPRECISE);
        if (alt.startsWith("<DEL")) {
            list = Variant.factory(chromo, startVariant, refVariant, "", id, false);
            vaType = Variant.VariantType.DEL;
        } else if (alt.startsWith("<DUP")) {
            list = this.variantsStructuralDup(chromo, startVariant, refVariant, alt, id);
            vaType = Variant.VariantType.DUP;
        } else if (alt.startsWith("<INV")) {
            list = this.variantsStructuralInv(chromo, startVariant, refVariant, alt, id);
            vaType = Variant.VariantType.INV;
        } else if (alt.startsWith("<CNV")) {
            list = this.variantsStructuralCnv(chromo, startVariant, refVariant, alt, id);
            vaType = Variant.VariantType.CNV;
        } else if (alt.startsWith("<INS")) {
            list = this.variantsStructuralIns(chromo, start, alt, id);
            vaType = Variant.VariantType.INS;
        } else {
            throw new RuntimeException("Unsupported structural variant type '" + alt + "'");
        }
        for (Variant var : list) {
            var.setVariantType(vaType);
            var.setEnd(this.end);
            if (!hasImprecise) continue;
            var.setImprecise(true);
        }
        return list;
    }

    List<Variant> variantsStructuralCnv(Chromosome chromo, int start, String reference, String alt, String id) {
        Variant var = new Variant((Marker)chromo, start, this.end, id);
        var.setVariantType(Variant.VariantType.CNV);
        LinkedList<Variant> list = new LinkedList<Variant>();
        list.add(var);
        return list;
    }

    List<Variant> variantsStructuralDup(Chromosome chromo, int start, String reference, String alt, String id) {
        int svlen = this.end - start + 1;
        String altDup = this.padNs(reference + reference, svlen);
        Variant var = new Variant((Marker)chromo, start, this.ref, altDup, id);
        var.setVariantType(Variant.VariantType.DUP);
        LinkedList<Variant> list = new LinkedList<Variant>();
        list.add(var);
        return list;
    }

    List<Variant> variantsStructuralIns(Chromosome chromo, int start, String alt, String id) {
        Variant var = new Variant((Marker)chromo, start, "", alt, id);
        var.setVariantType(Variant.VariantType.INS);
        LinkedList<Variant> list = new LinkedList<Variant>();
        list.add(var);
        return list;
    }

    List<Variant> variantsStructuralInv(Chromosome chromo, int start, String reference, String alt, String id) {
        String altInv = alt;
        if (reference.length() > 1) {
            altInv = new StringBuffer(reference).reverse().toString();
            int svlen = this.end - start + 1;
            altInv = this.padNs(altInv, svlen);
        }
        Variant var = new Variant((Marker)chromo, start, reference, altInv, id);
        LinkedList<Variant> list = new LinkedList<Variant>();
        list.add(var);
        return list;
    }

    List<Variant> variantsTranslocation(Chromosome chromo, int start, String reference, String alt, String id) {
        LinkedList<Variant> list = null;
        boolean left = alt.indexOf(93) >= 0;
        String sep = left ? "\\]" : "\\[";
        String[] tpos = alt.split(sep);
        String pos = tpos[1];
        boolean before = alt.indexOf(93) == 0 || alt.indexOf(91) == 0;
        String altBases = before ? tpos[2] : tpos[0];
        String[] posSplit = pos.split(":");
        String trChrName = posSplit[0];
        Chromosome trChr = chromo.getGenome().getOrCreateChromosome(trChrName);
        int trStart = Gpr.parseIntSafe(posSplit[1]) - 1;
        VariantBnd var = new VariantBnd(chromo, start, this.ref, altBases, trChr, trStart, left, before);
        list = new LinkedList<Variant>();
        list.add(var);
        return list;
    }

    static {
        INFO_VALUE_ENCODE.put("%3B", SUB_FIELD_SEP);
        INFO_VALUE_ENCODE.put("%3D", "=");
        INFO_VALUE_ENCODE.put("%2C", ",");
        INFO_VALUE_ENCODE.put("%0D", "\n");
        INFO_VALUE_ENCODE.put("%0A", "\r");
        INFO_VALUE_ENCODE.put("%09", "\t");
    }

    public static enum AlleleFrequencyType {
        Common,
        LowFrequency,
        Rare;

    }
}

