/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.HashMap;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.vcf.VcfHeaderInfo;

public class VcfConsequenceHeader {
    VcfHeaderInfo vcfInfoCsq;
    String[] fieldNames;
    Map<String, Integer> fieldNum;

    public VcfConsequenceHeader(VcfFileIterator vcf) {
        this.parseCsqHeader(vcf);
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Integer getFieldNum(String fieldName) {
        return this.fieldNum.get(fieldName);
    }

    void parseCsqHeader(VcfFileIterator vcf) {
        this.vcfInfoCsq = vcf.getVcfHeader().getVcfHeaderInfo("CSQ");
        if (this.vcfInfoCsq == null) {
            throw new RuntimeException("Cannot find CSQ in VCF header");
        }
        String descr = this.vcfInfoCsq.getDescription();
        String fields = descr.substring(descr.lastIndexOf(58) + 1);
        this.fieldNames = fields.split("\\|");
        this.fieldNum = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < this.fieldNames.length; ++i2) {
            this.fieldNames[i2] = this.fieldNames[i2].trim();
            this.fieldNum.put(this.fieldNames[i2], i2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.fieldNames) {
            sb.append("Field '" + name + "', number " + this.getFieldNum(name) + "\n");
        }
        return sb.toString();
    }
}

