/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfConsequenceHeader;
import org.snpeff.vcf.VcfEntry;

public class VcfConsequence {
    public static final String VCF_INFO_CSQ_NAME = "CSQ";
    VcfConsequenceHeader vcfConsequenceHeader;
    Map<String, String> name2value;

    public static List<VcfConsequence> parse(VcfConsequenceHeader vcfConsequenceHeader, String csqString) {
        ArrayList<VcfConsequence> list = new ArrayList<VcfConsequence>();
        if (csqString == null || csqString.isEmpty()) {
            return list;
        }
        int idx = csqString.indexOf(61);
        if (idx >= 0) {
            if (csqString.startsWith("CSQ=")) {
                throw new RuntimeException("String does not start with 'CSQ=', this is not a CSQ field: " + csqString);
            }
            csqString = csqString.substring(idx);
        }
        for (String csq : csqString.split(",")) {
            list.add(new VcfConsequence(vcfConsequenceHeader, csq));
        }
        return list;
    }

    public static List<VcfConsequence> parse(VcfConsequenceHeader vcfConsequenceHeader, VcfEntry ve) {
        return VcfConsequence.parse(vcfConsequenceHeader, ve.getInfo(VCF_INFO_CSQ_NAME));
    }

    public VcfConsequence(VcfConsequenceHeader vcfConsequenceHeader, String csqString) {
        this.vcfConsequenceHeader = vcfConsequenceHeader;
        this.parseSingle(csqString);
    }

    public String get(String fieldName) {
        return this.name2value.get(fieldName);
    }

    public String getConsequence() {
        return this.get("Consequence");
    }

    public String getFeature() {
        return this.get("Feature");
    }

    public String getHgvsDna() {
        return this.get("HGVSc");
    }

    public String getHgvsProt() {
        return this.get("HGVSp");
    }

    void parseSingle(String csqString) {
        try {
            String[] fieldNames = this.vcfConsequenceHeader.getFieldNames();
            this.name2value = new HashMap<String, String>();
            String[] fieldValues = csqString.split("\\|", -1);
            for (int i2 = 0; i2 < fieldValues.length; ++i2) {
                this.name2value.put(fieldNames[i2], fieldValues[i2]);
            }
        }
        catch (Exception e) {
            Log.debug("Error parsing\n\tCSQ string: " + csqString);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] fieldNames = this.vcfConsequenceHeader.getFieldNames();
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fieldNames[i2] + ": " + this.get(fieldNames[i2]));
        }
        return sb.toString();
    }
}

