/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.List;

public class PedigreeEntry {
    public String father;
    public String mother;
    public String child;
    public int fatherNum = -1;
    public int motherNum = -1;
    public int childNum = -1;

    public PedigreeEntry(String original, String derived) {
        this.child = derived;
        this.father = original;
        this.mother = null;
    }

    public PedigreeEntry(String father, String mother, String child) {
        this.child = child;
        this.father = father;
        this.mother = mother;
    }

    public String getDerived() {
        return this.child;
    }

    public int getDerivedNum() {
        return this.childNum;
    }

    public String getOriginal() {
        return this.father;
    }

    public int getOriginalNum() {
        return this.fatherNum;
    }

    public boolean isDerived() {
        return this.mother == null && this.father != null;
    }

    public void sampleNumbers(List<String> sampleNames) {
        int i2 = 0;
        for (String sn : sampleNames) {
            if (sn.equals(this.father)) {
                this.fatherNum = i2;
            }
            if (sn.equals(this.child)) {
                this.childNum = i2;
            }
            if (this.mother != null && sn.equals(this.mother)) {
                this.motherNum = i2;
            }
            ++i2;
        }
        if (this.fatherNum < 0) {
            throw new RuntimeException("Cannot find pedigree Father/Original sample name '" + this.father + "'");
        }
        if (this.childNum < 0) {
            throw new RuntimeException("Cannot find pedigree Child/Derived sample name '" + this.child + "'");
        }
    }

    public String toString() {
        if (this.mother == null) {
            return "Derived=" + this.getDerived() + ", Original=" + this.getOriginal();
        }
        return "Child=" + this.child + ", Mother=" + this.mother + ", Father=" + this.father;
    }
}

