/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Tuple;
import org.snpeff.vcf.PedigreeEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public class Pedigree
implements Iterable<PedigreeEntry> {
    boolean debug;
    boolean verbose;
    List<PedigreeEntry> pedigree;
    List<PedigreeEntry> pedigreeDerived;
    int[] pedigreeDerivedArray;
    VcfFileIterator vcfFile;

    public Pedigree(VcfFileIterator vcfFile) {
        this.vcfFile = vcfFile;
        this.readPedigreeVcf();
    }

    public Pedigree(VcfFileIterator vcfFile, String cancerSamples) {
        this.vcfFile = vcfFile;
        this.readPedigreeTxt(cancerSamples);
    }

    public boolean anyBackToRef(VcfEntry vcfEntry) {
        for (PedigreeEntry pe : this.derived()) {
            int numOri = pe.getOriginalNum();
            int numDer = pe.getDerivedNum();
            VcfGenotype gtOri = vcfEntry.getVcfGenotype(numOri);
            VcfGenotype gtDer = vcfEntry.getVcfGenotype(numDer);
            int[] gd = gtDer.getGenotype();
            int[] go = gtOri.getGenotype();
            if (gd == null || go == null) continue;
            if (gtOri.isPhased() && gtDer.isPhased()) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (go[i2] <= 0 || gd[i2] != 0) continue;
                    return true;
                }
                continue;
            }
            for (int o = 0; o < go.length; ++o) {
                for (int d = 0; d < gd.length; ++d) {
                    if (go[o] <= 0 || gd[d] != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean anyDerived() {
        return this.pedigree.stream().anyMatch(pe -> pe.isDerived());
    }

    public Set<Tuple<Integer, Integer>> compareCancerGenotypes(VcfEntry vcfEntry) {
        HashSet<Tuple<Integer, Integer>> comparisons = new HashSet<Tuple<Integer, Integer>>();
        for (PedigreeEntry pe : this.derived()) {
            int numOri = pe.getOriginalNum();
            int numDer = pe.getDerivedNum();
            VcfGenotype gtOri = vcfEntry.getVcfGenotype(numOri);
            VcfGenotype gtDer = vcfEntry.getVcfGenotype(numDer);
            int[] gd = gtDer.getGenotype();
            int[] go = gtOri.getGenotype();
            if (gd == null || go == null) continue;
            if (gtOri.isPhased() && gtDer.isPhased()) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (go[i2] < 0 || gd[i2] < 0 || go[i2] == 0 || gd[i2] == go[i2]) continue;
                    Tuple<Integer, Integer> compare = new Tuple<Integer, Integer>(gd[i2], go[i2]);
                    comparisons.add(compare);
                }
                continue;
            }
            for (int o = 0; o < go.length; ++o) {
                if (go[o] <= 0) continue;
                for (int d = 0; d < gd.length; ++d) {
                    if (gd[d] < 0 || gd[d] == go[o]) continue;
                    Tuple<Integer, Integer> compare = new Tuple<Integer, Integer>(gd[d], go[o]);
                    comparisons.add(compare);
                }
            }
        }
        return comparisons;
    }

    public List<PedigreeEntry> derived() {
        if (this.pedigreeDerived == null) {
            this.pedigreeDerived = this.pedigree.stream().filter(pe -> pe.isDerived()).collect(Collectors.toList());
        }
        return this.pedigreeDerived;
    }

    @Override
    public Iterator<PedigreeEntry> iterator() {
        return this.pedigree.iterator();
    }

    void readPedigreeTxt(String cancerSamples) {
        if (this.verbose) {
            Log.info("Reading cancer samples pedigree from file '" + cancerSamples + "'.");
        }
        List<String> sampleNames = this.vcfFile.getVcfHeader().getSampleNames();
        this.pedigree = new ArrayList<PedigreeEntry>();
        for (String line : Gpr.readFile(cancerSamples).split("\n")) {
            String[] recs = line.split("\\s", -1);
            String original = recs[0];
            String derived = recs[1];
            PedigreeEntry pe = new PedigreeEntry(original, derived);
            pe.sampleNumbers(sampleNames);
            this.pedigree.add(pe);
        }
    }

    void readPedigreeVcf() {
        if (this.verbose) {
            Log.info("Reading cancer samples pedigree from VCF header.");
        }
        this.pedigree = this.vcfFile.getVcfHeader().getPedigree();
        if (this.verbose) {
            Log.info("Pedigree: " + String.valueOf(this.pedigree));
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

