/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.HashSet;
import java.util.Set;

public enum EffFormatVersion {
    FORMAT_EFF,
    FORMAT_EFF_2,
    FORMAT_EFF_3,
    FORMAT_EFF_4,
    FORMAT_ANN,
    FORMAT_ANN_1;

    public static final EffFormatVersion DEFAULT_FORMAT_VERSION;
    public static final String VCF_INFO_EFF_NAME = "EFF";
    public static final String VCF_INFO_ANN_NAME = "ANN";
    public static final String[] VCF_INFO_ANN_NAMES;
    public static final String EFFECT_TYPE_SEPARATOR = "&";
    public static final String EFFECT_TYPE_SEPARATOR_OLD = "+";
    protected static Set<String> vcfInfoNames;

    public static boolean isEffectVcfInfoField(String key) {
        return vcfInfoNames.contains(key);
    }

    public String infoFieldName() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return VCF_INFO_ANN_NAME;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return VCF_INFO_EFF_NAME;
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public boolean isAnn() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public boolean isEff() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public boolean isFullVersion() {
        switch (this.ordinal()) {
            case 0: 
            case 4: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return true;
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public String separator() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return EFFECT_TYPE_SEPARATOR;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return EFFECT_TYPE_SEPARATOR_OLD;
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public String separatorSplit() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return "\\&";
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "\\+";
            }
        }
        throw new RuntimeException("Unknown format: " + String.valueOf((Object)this));
    }

    public String vcfHeader() {
        switch (this.ordinal()) {
            case 1: {
                return "##INFO=<ID=EFF,Number=.,Type=String,Description=\"Predicted effects for this variant.Format: 'Effect ( Effect_Impact | Functional_Class | Codon_Change | Amino_Acid_change| Gene_Name | Transcript_BioType | Gene_Coding | Transcript_ID | Exon [ | ERRORS | WARNINGS ] )' \">";
            }
            case 2: {
                return "##INFO=<ID=EFF,Number=.,Type=String,Description=\"Predicted effects for this variant.Format: 'Effect ( Effect_Impact | Functional_Class | Codon_Change | Amino_Acid_change| Amino_Acid_length | Gene_Name | Transcript_BioType | Gene_Coding | Transcript_ID | Exon [ | ERRORS | WARNINGS ] )' \">";
            }
            case 3: {
                return "##INFO=<ID=EFF,Number=.,Type=String,Description=\"Predicted effects for this variant.Format: 'Effect ( Effect_Impact | Functional_Class | Codon_Change | Amino_Acid_Change| Amino_Acid_length | Gene_Name | Transcript_BioType | Gene_Coding | Transcript_ID | Exon_Rank  | Genotype [ | ERRORS | WARNINGS ] )' \">";
            }
            case 5: {
                return "##INFO=<ID=ANN,Number=.,Type=String,Description=\"Functional annotations: 'Allele | Annotation | Annotation_Impact | Gene_Name | Gene_ID | Feature_Type | Feature_ID | Transcript_BioType | Rank | HGVS.c | HGVS.p | cDNA.pos / cDNA.length | CDS.pos / CDS.length | AA.pos / AA.length | Distance | ERRORS / WARNINGS / INFO' \">";
            }
        }
        throw new RuntimeException("Unimplemented format '" + String.valueOf((Object)this) + "'");
    }

    static {
        DEFAULT_FORMAT_VERSION = FORMAT_ANN_1;
        VCF_INFO_ANN_NAMES = new String[]{VCF_INFO_ANN_NAME, VCF_INFO_EFF_NAME};
        vcfInfoNames = new HashSet<String>();
        for (String key : VCF_INFO_ANN_NAMES) {
            vcfInfoNames.add(key);
        }
    }
}

