/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.util.Date;

public class Timer {
    private static Timer timer = new Timer();
    boolean useMiliSecs = false;
    Date start = new Date();
    Date end;

    public static void show(Object msg) {
        System.out.println(String.valueOf(timer) + "\t" + (msg == null ? "null" : msg.toString()));
    }

    public static void showStdErr(Object msg) {
        System.err.println(String.valueOf(timer) + "\t" + (msg == null ? "null" : msg.toString()));
    }

    public static String toString(long elapsedMs, boolean useMiliSecs) {
        long delta = elapsedMs;
        long days = delta / 86400000L;
        long hours = delta % 86400000L / 3600000L;
        long mins = delta % 3600000L / 60000L;
        long secs = delta % 60000L / 1000L;
        long ms = delta % 1000L;
        if (days > 0L) {
            if (useMiliSecs) {
                return String.format("%d days %02d:%02d:%02d.%03d", days, hours, mins, secs, ms);
            }
            return String.format("%d days %02d:%02d:%02d", days, hours, mins, secs);
        }
        if (useMiliSecs) {
            return String.format("%02d:%02d:%02d.%03d", hours, mins, secs, ms);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs);
    }

    public long elapsed() {
        if (this.end != null) {
            return this.end.getTime() - this.start.getTime();
        }
        Date now = new Date();
        return now.getTime() - this.start.getTime();
    }

    public void end() {
        this.end = new Date();
    }

    public void setUseMiliSecs(boolean useMiliSecs) {
        this.useMiliSecs = useMiliSecs;
    }

    public void start() {
        this.start = new Date();
        this.end = null;
    }

    public String toString() {
        return Timer.toString(this.elapsed(), this.useMiliSecs);
    }
}

