/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.Timer;

public class Log {
    public static final int MAX_WARNINGS = 25;
    public static final int MAX_ERRORS = 10;
    protected static Map<ErrorWarningType, Integer> warnCount = new HashMap<ErrorWarningType, Integer>();
    private static Timer timer = new Timer();
    private static FatalErrorBehabiour fatalErrorBehabiour = FatalErrorBehabiour.EXIT;
    private static Set<ErrorWarningType> silenceWarning = new HashSet<ErrorWarningType>();

    public static void debug(Object obj) {
        Log.debug(obj, 1, true);
    }

    public static void debug(Object obj, int offset) {
        Log.debug(obj, offset, true);
    }

    public static void debug(Object obj, int offset, boolean newLine) {
        StackTraceElement ste = new Exception().getStackTrace()[1 + offset];
        Object steStr = ste.getClassName();
        int ind = ((String)steStr).lastIndexOf(46);
        steStr = ((String)steStr).substring(ind + 1);
        steStr = (String)steStr + "." + ste.getMethodName() + "(" + ste.getLineNumber() + "):\t" + (obj == null ? null : obj.toString());
        if (newLine) {
            System.err.println((String)steStr);
        } else {
            System.err.print((String)steStr);
        }
    }

    public static void error(String msg) {
        System.err.println("ERROR: " + msg);
    }

    public static void error(Throwable e, String message) {
        if (Config.get().isVerbose() && e != null) {
            e.printStackTrace();
        }
        System.err.println("ERROR: " + message);
    }

    public static void fatalError(String message) {
        Log.fatalError(null, message);
    }

    public static void fatalError(Throwable e, String message) {
        if (fatalErrorBehabiour != FatalErrorBehabiour.EXCEPTION_QUIET) {
            System.err.println("FATAL ERROR: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        switch (fatalErrorBehabiour.ordinal()) {
            case 0: {
                System.exit(-1);
                break;
            }
            case 1: 
            case 2: {
                throw new RuntimeException(message, e);
            }
            default: {
                System.err.println("WARNINGN: Unknown fatalErrorBehabiour '" + String.valueOf((Object)fatalErrorBehabiour) + "'");
                System.exit(-1);
            }
        }
    }

    public static Map<ErrorWarningType, Integer> getWarnCount() {
        return warnCount;
    }

    public static void info(Object msg) {
        System.err.println(String.valueOf(timer) + " " + (msg == null ? "null" : msg.toString()));
    }

    public static void infoln(Object msg) {
        System.err.println("\n" + String.valueOf(timer) + " " + (msg == null ? "null" : msg.toString()));
    }

    public static void reset() {
        warnCount = new HashMap<ErrorWarningType, Integer>();
        timer = new Timer();
        fatalErrorBehabiour = FatalErrorBehabiour.EXIT;
        silenceWarning = new HashSet<ErrorWarningType>();
    }

    public static void setFatalErrorBehabiour(FatalErrorBehabiour fatalErrorBehabiour) {
        Log.fatalErrorBehabiour = fatalErrorBehabiour;
    }

    public static void silenceWarning(ErrorWarningType warningType) {
        silenceWarning.add(warningType);
    }

    public static void warning(String msg) {
        System.err.println("\nWARNING: " + msg);
    }

    public static void warningln(String msg) {
        System.err.println("WARNING: " + msg);
    }

    public static void warning(ErrorWarningType warnType, String msg) {
        if (warnType != null) {
            if (!warnCount.containsKey((Object)warnType)) {
                warnCount.put(warnType, 0);
            }
            int count = warnCount.get((Object)warnType);
            warnCount.put(warnType, count + 1);
            if (!silenceWarning.contains((Object)warnType)) {
                if (count < 25) {
                    System.err.println(String.valueOf((Object)warnType) + ": " + msg);
                } else if (count == 25) {
                    System.err.println(String.valueOf((Object)warnType) + ": " + msg);
                    System.err.println(String.valueOf((Object)warnType) + ": Too many '" + String.valueOf((Object)warnType) + "' warnings, no further warnings will be shown.");
                }
            }
        } else {
            System.err.println("WARNING: " + msg);
        }
    }

    public static enum FatalErrorBehabiour {
        EXIT,
        EXCEPTION,
        EXCEPTION_QUIET;

    }
}

