/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.util.Iterator;
import org.snpeff.util.CombinatorialIterator;

public class IubString
implements Iterable<String>,
Iterator<String> {
    public static final int MAX_IUB_BASES = 10;
    int[] idx2BaseNum;
    char[] bases;
    char[][] iubCodesByIndex;
    CombinatorialIterator combIt;

    public static int countIUB(String str) {
        char[] bases = str.toCharArray();
        int count = 0;
        for (int i2 = 0; i2 < bases.length; ++i2) {
            if (!IubString.isUIB(bases[i2])) continue;
            return count++;
        }
        return count;
    }

    public static boolean hasIUB(String str) {
        char[] bases = str.toCharArray();
        for (int i2 = 0; i2 < bases.length; ++i2) {
            if (!IubString.isUIB(bases[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIUBMax(String str) {
        if (str.length() < 10) {
            return IubString.hasIUB(str);
        }
        int count = IubString.countIUB(str);
        return count > 0 && count <= 10;
    }

    public static boolean isUIB(char base) {
        switch (base) {
            case 'B': 
            case 'D': 
            case 'H': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    public static char[] iub2bases(char alt) {
        return switch (alt) {
            case 'N' -> new char[]{'A', 'C', 'G', 'T'};
            case 'B' -> new char[]{'C', 'G', 'T'};
            case 'D' -> new char[]{'A', 'G', 'T'};
            case 'H' -> new char[]{'A', 'C', 'T'};
            case 'V' -> new char[]{'A', 'C', 'G'};
            case 'M' -> new char[]{'A', 'C'};
            case 'R' -> new char[]{'A', 'G'};
            case 'W' -> new char[]{'A', 'T'};
            case 'S' -> new char[]{'C', 'G'};
            case 'Y' -> new char[]{'C', 'T'};
            case 'K' -> new char[]{'G', 'T'};
            default -> throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + alt + "'");
        };
    }

    public IubString(String str) {
        this.bases = str.toCharArray();
        int size = 0;
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            if (!IubString.isUIB(this.bases[i2])) continue;
            ++size;
        }
        this.combIt = new CombinatorialIterator(size);
        this.iubCodesByIndex = new char[size][];
        this.idx2BaseNum = new int[size];
        int j = 0;
        for (int i3 = 0; i3 < this.bases.length; ++i3) {
            if (!IubString.isUIB(this.bases[i3])) continue;
            char[] iubCodes = IubString.iub2bases(this.bases[i3]);
            this.combIt.set(j, 0, iubCodes.length - 1);
            this.iubCodesByIndex[j] = iubCodes;
            this.idx2BaseNum[j] = i3;
            ++j;
        }
    }

    @Override
    public boolean hasNext() {
        return this.combIt.hasNext();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() {
        int[] next = this.combIt.next();
        if (next == null) {
            return null;
        }
        for (int j = 0; j < this.idx2BaseNum.length; ++j) {
            int i2 = this.idx2BaseNum[j];
            char[] iubs = this.iubCodesByIndex[j];
            this.bases[i2] = iubs[next[j]];
        }
        return new String(this.bases);
    }

    @Override
    public void remove() {
    }
}

