/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URLConnection;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.snpeff.util.Log;

public class Gpr {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final int NUM_CORES = Runtime.getRuntime().availableProcessors();
    public static final String HOME = System.getProperty("user.home");
    public static final String[] GZIP_EXTENTIONS = new String[]{".gz", ".bgz"};

    public static String baseName(String file) {
        File f = new File(file);
        return f.getName();
    }

    public static String baseName(String file, String ext) {
        File f = new File(file);
        String base = f.getName();
        if (base.endsWith(ext)) {
            return base.substring(0, base.length() - ext.length());
        }
        return base;
    }

    public static String bin64(long l) {
        String bl = Long.toBinaryString(l);
        Object out = "";
        for (int i2 = bl.length(); i2 < 64; ++i2) {
            out = (String)out + "0";
        }
        return (String)out + bl;
    }

    public static boolean canRead(String fileName) {
        if (fileName.equals("-")) {
            return true;
        }
        File inputFile = new File(fileName);
        if (inputFile.exists() && inputFile.canRead() && inputFile.isFile()) {
            return true;
        }
        inputFile = new File(fileName + ".gz");
        return inputFile.exists() && inputFile.canRead() && inputFile.isFile();
    }

    public static int compareNull(Comparable c1, Comparable c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.compareTo(c2);
    }

    public static String compileDate(Class<?> cl) {
        return Gpr.compileTimeStamp(cl, new SimpleDateFormat("yyyy-MM-dd"));
    }

    public static String compileTimeStamp() {
        return Gpr.compileTimeStamp(Gpr.class);
    }

    public static String compileTimeStamp(Class<?> cl) {
        return Gpr.compileTimeStamp(cl, new SimpleDateFormat("yyyy-MM-dd HH:mm"));
    }

    public static String compileTimeStamp(Class<?> cl, SimpleDateFormat dateFormat) {
        try {
            String resName = cl.getName().replace('.', '/') + ".class";
            URLConnection conn = ClassLoader.getSystemResource(resName).openConnection();
            long epoch = 0L;
            epoch = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile().getEntry("META-INF/MANIFEST.MF").getTime() : conn.getLastModified();
            Date epochDate = new Date(epoch);
            return dateFormat.format(epochDate);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int countColumns(String file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            reader.close();
            if (line == null) {
                return 0;
            }
            String[] fields = line.split("\\s+");
            return fields.length;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int countLines(String file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int lines = 0;
            while (reader.readLine() != null) {
                ++lines;
            }
            reader.close();
            return lines;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String dirName(String file) {
        File f = new File(file);
        String paren = f.getParent();
        return paren == null ? "." : paren;
    }

    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static String extName(String file) {
        String base = Gpr.baseName(file);
        int idx = base.lastIndexOf(46);
        if (idx >= 0) {
            return base.substring(idx + 1);
        }
        return "";
    }

    public static String head(Object o) {
        StringBuilder sb = new StringBuilder();
        String[] lines = o.toString().split("\n");
        for (int i2 = 0; i2 < 10; ++i2) {
            sb.append(lines[i2] + "\n");
        }
        return sb.toString();
    }

    public static StringBuffer inputStream2StringBuffer(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer file = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            file.append(line + "\n");
            line = reader.readLine();
        }
        return file;
    }

    public static boolean isStdin(String fileName) {
        return fileName.isEmpty() || fileName.equals("-");
    }

    public static boolean isValidIp(String ip) {
        if (ip == null) {
            return false;
        }
        String[] ipSplitted = ip.split("\\.");
        if (ipSplitted.length != 4) {
            return false;
        }
        for (int i2 = 0; i2 < ipSplitted.length; ++i2) {
            if (ipSplitted[i2].length() > 3) {
                return false;
            }
            try {
                int ipPart = Integer.parseInt(ipSplitted[i2]);
                if (ipPart >= 0 && ipPart <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidRid(int i2) {
        return i2 > 0;
    }

    public static String noSpaces(String str) {
        String[] lines = str.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line.trim().replaceAll("\\s", "") + "\n");
        }
        if (lines.length == 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean parseBoolSafe(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static double parseDoubleSafe(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static float parseFloatSafe(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static int parseIntSafe(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long parseLongSafe(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String prependEachLine(String prepend, Object lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines.toString().split("\n")) {
            sb.append(prepend + line + "\n");
        }
        return sb.toString();
    }

    public static String read(InputStream is) {
        if (is == null) {
            return null;
        }
        StringBuffer strb = new StringBuffer();
        char[] buff = new char[10240];
        int len = 0;
        try {
            BufferedReader inFile = new BufferedReader(new InputStreamReader(is));
            while ((len = inFile.read(buff)) >= 0) {
                strb.append(buff, 0, len);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return strb.toString();
    }

    public static BufferedReader reader(String fileName) {
        return Gpr.reader(fileName, false);
    }

    public static BufferedReader reader(String fileName, boolean gzip) {
        BufferedReader reader = null;
        try {
            if (fileName.equals("-")) {
                return new BufferedReader(new InputStreamReader(System.in));
            }
            if (fileName.endsWith(".gz") || fileName.endsWith(".bgz") || gzip) {
                File inputFile = new File(fileName);
                if (inputFile.exists()) {
                    return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(fileName)))));
                }
                throw new RuntimeException("File not found '" + inputFile.getAbsolutePath() + "'");
            }
            File inputFile = new File(fileName);
            if (inputFile.exists()) {
                return new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));
            }
            for (String ext : GZIP_EXTENTIONS) {
                String fileNameGz = fileName + ext;
                inputFile = new File(fileNameGz);
                if (!inputFile.exists()) continue;
                return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(fileNameGz)))));
            }
            throw new RuntimeException("File not found '" + fileName + "'");
        }
        catch (FileNotFoundException e) {
            reader = null;
            Log.debug(e);
        }
        catch (IOException e) {
            reader = null;
            Log.debug(e);
        }
        return reader;
    }

    public static String readFile(String fileName) {
        return Gpr.readFile(fileName, false);
    }

    public static String readFile(String fileName, boolean gzipped) {
        StringBuffer strb = new StringBuffer();
        char[] buff = new char[10240];
        int len = 0;
        try {
            BufferedReader inFile = Gpr.reader(fileName, gzipped);
            while ((len = inFile.read(buff)) >= 0) {
                strb.append(buff, 0, len);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return strb.toString();
    }

    public static Object readFileSerialized(String fileName) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readFileSerializedGz(String fileName) {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readFileSerializedGzThrow(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    public static String removeBackslashR(String line) {
        if (line != null && !line.isEmpty() && line.charAt(line.length() - 1) == '\r') {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    public static String removeExt(String file) {
        int lastDot = file.indexOf(46);
        if (lastDot >= 0) {
            return file.substring(0, lastDot);
        }
        return file;
    }

    public static String removeExt(String file, String[] fileExtensions) {
        for (String ext : fileExtensions) {
            if (!file.toLowerCase().endsWith(ext)) continue;
            return file.substring(0, file.length() - ext.length());
        }
        return file;
    }

    public static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] str = new char[n];
        Arrays.fill(str, c);
        return new String(str);
    }

    public static String sanityzeFileName(String fileName) {
        String out = fileName.trim().replaceAll("[^0-9_a-zA-Z\\(\\)\\%\\-\\.\\[\\]\\:\\,]", "_");
        return out.replaceAll("_+", "_");
    }

    public static String sanityzeName(String fileName) {
        String out = fileName.trim().replaceAll("[^0-9_a-zA-Z\\.]", "_");
        if ((out = out.replaceAll("_+", "_")).startsWith("_")) {
            out = out.substring(1);
        }
        if (out.endsWith("_")) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public static void showMark(int i2, int showEvery) {
        if (showEvery <= 0) {
            return;
        }
        if (i2 % showEvery == 0) {
            if (i2 % (100 * showEvery) == 0) {
                System.err.print(".\n" + i2 + "\t");
            } else {
                System.err.print('.');
            }
        }
    }

    public static void showMark(int i2, int showEvery, String newLineStr) {
        if (showEvery <= 0) {
            return;
        }
        if (i2 % showEvery == 0) {
            if (i2 % (100 * showEvery) == 0) {
                System.err.print(".\n" + newLineStr + i2 + "\t");
            } else {
                System.err.print('.');
            }
        }
    }

    public static void showMarkStderr(int i2, int showEvery) {
        if (i2 % showEvery == 0) {
            if (i2 % (100 * showEvery) == 0) {
                System.err.print(".\n" + i2 + "\t");
            } else {
                System.err.print('.');
            }
        }
    }

    public static void showStackTrace(int steps) {
        Gpr.showStackTrace(steps, 1);
    }

    public static void showStackTrace(int steps, int offset) {
        Exception e = new Exception();
        String sep = "";
        for (int i2 = 0; i2 < steps; ++i2) {
            int num = i2 + offset + 1;
            if (num >= e.getStackTrace().length) continue;
            StackTraceElement ste = e.getStackTrace()[num];
            Object steStr = ste.getClassName();
            int ind = ((String)steStr).lastIndexOf(46);
            steStr = ((String)steStr).substring(ind + 1);
            steStr = (String)steStr + "." + ste.getMethodName() + "(" + ste.getLineNumber() + "):";
            System.err.println(sep + (String)steStr);
            sep = "\t";
        }
    }

    public static String[] split(String value, char delim) {
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, delim);
        return st.tokens(String.class);
    }

    public static String tabs(int tabs) {
        Object t = "";
        for (int i2 = 0; i2 < tabs; ++i2) {
            t = (String)t + "\t";
        }
        return t;
    }

    public static String tail(Object o) {
        StringBuilder sb = new StringBuilder();
        String[] lines = o.toString().split("\n");
        for (int i2 = lines.length - 10; i2 < lines.length; ++i2) {
            sb.append(lines[i2] + "\n");
        }
        return sb.toString();
    }

    public static String toByteSize(long l) {
        if (l > 0x10000000000L) {
            return String.format("%1.2f TB", (double)l / 1.099511627776E12);
        }
        if (l > 0x40000000L) {
            return String.format("%1.2f GB", (double)l / 1.073741824E9);
        }
        if (l > 0x100000L) {
            return String.format("%1.2f MB", (double)l / 1048576.0);
        }
        if (l > 1024L) {
            return String.format("%1.2f KB", (double)l / 1024.0);
        }
        return l + " bytes";
    }

    public static void toFile(String fileName, Object obj) {
        Gpr.toFile(fileName, obj, false);
    }

    public static void toFile(String fileName, Object obj, boolean append) {
        try {
            BufferedWriter outFile = new BufferedWriter(new FileWriter(fileName, append));
            outFile.write(obj.toString());
            outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileGz(String fileName, Object obj) {
        try {
            PrintStream outFile = new PrintStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            outFile.print(obj.toString());
            outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileSerialize(String fileName, Object obj) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(obj);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileSerializeGz(String fileName, Object obj) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            out.writeObject(obj);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(boolean[] vals) {
        if (vals == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(vals[i2] ? (char)'1' : '0');
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static String toString(double[] vals) {
        if (vals == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(Gpr.toString(vals[i2]));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static String toString(double[][] vals) {
        if (vals == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < vals.length; ++i2) {
            sb.append("|");
            for (int j = 0; j < vals[i2].length; ++j) {
                sb.append(" " + Gpr.toString(vals[i2][j]));
            }
            sb.append(" |\n");
        }
        return sb.toString();
    }

    public static String toString(double val) {
        double aval = Math.abs(val);
        if (aval < 1000000.0 && aval >= 100000.0) {
            return String.format("% 6.2f", val);
        }
        if (aval < 100000.0 && aval >= 10000.0) {
            return String.format("% 5.2f ", val);
        }
        if (aval < 10000.0 && aval >= 1000.0) {
            return String.format("% 4.2f  ", val);
        }
        if (aval < 1000.0 && aval >= 100.0) {
            return String.format("% 3.2f   ", val);
        }
        if (aval < 100.0 && aval >= 10.0) {
            return String.format("% 2.2f    ", val);
        }
        if (aval < 10.0 && aval >= 1.0) {
            return String.format("% 1.3f    ", val);
        }
        if (aval < 1.0 && aval >= 0.01) {
            return String.format("% 1.3f    ", val);
        }
        if (aval < 1.0 && aval >= 0.001) {
            return String.format("% 1.4f   ", val);
        }
        if (aval < 1.0 && aval >= 1.0E-6) {
            return String.format("% 1.6f ", val);
        }
        if (aval < 1.0 && aval >= 1.0E-7) {
            return String.format("% 1.7f", val);
        }
        if (val == 0.0) {
            return String.format(" 0        ", val);
        }
        return String.format("% 1.3e", val);
    }

    public static String toString(int[] vals) {
        if (vals == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(vals[i2]);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static String toStringHead(double[] vals) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < 10 && i2 < vals.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(Gpr.toString(vals[i2]));
        }
        double sum = 0.0;
        for (int i3 = 0; i3 < vals.length; ++i3) {
            sum += vals[i3];
        }
        sb.append("\tsum: " + sum);
        sb.append(" ]");
        return sb.toString();
    }

    private static class StringTokenizer {
        String string = null;
        int tokens = 0;
        int[] separatorPosition = new int[1000];

        StringTokenizer(String value, char delim) {
            this.string = value;
            StringCharacterIterator sci = new StringCharacterIterator(this.string);
            char c = sci.first();
            while (c != '\uffff') {
                if (c == delim) {
                    this.separatorPosition[this.tokens] = sci.getIndex();
                    ++this.tokens;
                    if (this.tokens >= this.separatorPosition.length) {
                        int[] copy = new int[this.separatorPosition.length * 10];
                        System.arraycopy(this.separatorPosition, 0, copy, 0, this.separatorPosition.length);
                        this.separatorPosition = copy;
                    }
                }
                c = sci.next();
            }
            ++this.tokens;
        }

        <T> T[] tokens(Class<T> componentType) {
            Constructor<T> ctor;
            Object[] r = (Object[])Array.newInstance(componentType, this.tokens);
            try {
                ctor = componentType.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot create an array of type [" + String.valueOf(componentType) + "] from an array of String. The type [" + componentType.getSimpleName() + "] must define a single arg constructor that takes a String.class instance.");
            }
            String currentValue = null;
            int i2 = 0;
            try {
                int start = 0;
                for (i2 = 0; i2 < this.tokens; ++i2) {
                    int length;
                    int nextStart = this.separatorPosition[i2];
                    if (i2 == this.tokens - 1) {
                        nextStart = this.string.length();
                    }
                    if ((length = nextStart - start) > 0) {
                        currentValue = this.string.substring(start, nextStart);
                        r[i2] = ctor.newInstance(currentValue);
                    }
                    start = nextStart + 1;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create an instance of type [" + String.valueOf(componentType) + "] from the " + i2 + "th string value [" + currentValue + "].", e);
            }
            return r;
        }
    }
}

