/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Tuple;

public class Download {
    public static final int DEFAULT_PROXY_PORT = 80;
    private static final int BUFFER_SIZE = 102400;
    boolean debug = false;
    boolean verbose = false;
    boolean update;
    boolean maskDownloadException = false;

    public static String urlBaseName(String url) {
        String[] f = url.split("/");
        String base = f[f.length - 1];
        int qidx = base.indexOf(63);
        if (qidx > 0) {
            base = base.substring(0, qidx);
        }
        return base;
    }

    void backupFile(ZipOutputStream zos, String fileName) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(fileName);
            zos.putNextEntry(new ZipEntry(fileName));
            byte[] buf = new byte[102400];
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            fis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean download(String urlString, String localFile) {
        try {
            URL url = new URL(urlString);
            return this.download(url, localFile);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean download(URL url, String localFile) {
        boolean res;
        block19: {
            res = false;
            try {
                File path;
                File file;
                URLConnection connection;
                this.sslSetup();
                if (this.verbose) {
                    Log.info("Connecting to " + String.valueOf(url));
                }
                if ((connection = this.openConnection(url)) instanceof HttpURLConnection) {
                    boolean followRedirect = true;
                    while (followRedirect) {
                        int code;
                        HttpURLConnection httpConnection = (HttpURLConnection)connection;
                        if (this.verbose) {
                            Log.info("Connecting to " + String.valueOf(url) + ", using proxy: " + httpConnection.usingProxy());
                        }
                        if ((code = httpConnection.getResponseCode()) == 200) {
                            followRedirect = false;
                            continue;
                        }
                        if (code == 302) {
                            String newUrl = connection.getHeaderField("Location");
                            if (this.verbose) {
                                Log.info("Following redirect: " + newUrl);
                            }
                            url = new URL(newUrl);
                            connection = this.openConnection(url);
                            continue;
                        }
                        if (code == 404) {
                            throw new RuntimeException("File not found on the server. Make sure the database name is correct.");
                        }
                        throw new RuntimeException("Error code from server: " + code);
                    }
                }
                InputStream is = connection.getInputStream();
                Date date = new Date(connection.getLastModified());
                if (this.debug) {
                    Log.debug("Copying file (type: " + connection.getContentType() + ", modified on: " + String.valueOf(date) + ")");
                }
                if (this.verbose) {
                    Log.info("Local file name: '" + localFile + "'");
                }
                if ((file = new File(localFile)) != null && file.getParent() != null && !(path = new File(file.getParent())).exists()) {
                    if (this.verbose) {
                        Log.info("Local path '" + String.valueOf(path) + "' doesn't exist, creating.");
                    }
                    path.mkdirs();
                }
                FileOutputStream os = null;
                os = new FileOutputStream(localFile);
                int count = 0;
                int total = 0;
                int lastShown = 0;
                byte[] data = new byte[102400];
                while ((count = is.read(data, 0, 102400)) != -1) {
                    os.write(data, 0, count);
                    if ((total += count) - lastShown <= 0x100000) continue;
                    if (this.verbose) {
                        System.err.print(".");
                    }
                    lastShown = total;
                }
                if (this.verbose) {
                    Log.info("");
                }
                is.close();
                os.close();
                if (this.verbose) {
                    Log.info("Download finished. Total " + total + " bytes.");
                }
                res = true;
            }
            catch (Exception e) {
                res = false;
                if (this.verbose) {
                    Log.info("ERROR while connecting to " + String.valueOf(url));
                }
                if (this.maskDownloadException) break block19;
                throw new RuntimeException(e);
            }
        }
        return res;
    }

    URLConnection openConnection(URL url) throws IOException {
        Proxy proxy = this.proxy();
        return proxy == null ? url.openConnection() : url.openConnection(proxy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String parseEntryPath(String entryName, String mainDir, String dataDir) {
        if (this.update) {
            int idx = ((String)entryName).indexOf(47);
            if (idx <= 0) throw new RuntimeException("Expecting at least one directory in path '" + (String)entryName + "'");
            return mainDir + ((String)entryName).substring(idx);
        }
        String[] entryPath = ((String)entryName).split("/");
        String dataName = entryPath[entryPath.length - 2] + "/" + entryPath[entryPath.length - 1];
        entryName = dataDir + "/" + dataName;
        if (!this.debug) return entryName;
        Log.debug("Local file name: '" + (String)entryName + "'");
        return entryName;
    }

    Tuple<String, Integer> parseProxyEnv(String envVarName) {
        String envProxy = System.getenv(envVarName);
        if (envProxy == null || envProxy.isBlank()) {
            return null;
        }
        if (this.verbose) {
            Log.info("Using proxy from environment variable '" + envVarName + "', value '" + envProxy + "'");
        }
        String proxyHost = null;
        int port = 80;
        try {
            URL url = new URL(envProxy);
            proxyHost = url.getHost();
            port = url.getPort();
        }
        catch (MalformedURLException e) {
            if (envProxy.indexOf(58) > 0) {
                String[] hp = envProxy.split(":");
                proxyHost = hp[0];
                port = Gpr.parseIntSafe(hp[1]);
            }
            proxyHost = envVarName;
        }
        if (this.verbose) {
            Log.info("Parsing proxy value '" + envProxy + "', host: '" + proxyHost + "', port: '" + port + "'");
        }
        return new Tuple<String, Integer>(proxyHost, port);
    }

    Tuple<String, Integer> parseProxyJavaPropperty() {
        int port;
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost == null || proxyHost.isBlank()) {
            return null;
        }
        if (this.verbose) {
            Log.info("Using proxy from Java properties: http.proxyHost: '" + proxyHost + "', http.proxyPort: '" + proxyPort + "'");
        }
        int n = port = proxyPort != null && !proxyPort.isBlank() ? Gpr.parseIntSafe(proxyPort) : 80;
        if (this.verbose) {
            Log.info("Parsing proxy value from Java propperties, host: '" + proxyHost + "', port: '" + port + "'");
        }
        return new Tuple<String, Integer>(proxyHost, port);
    }

    Proxy proxy() {
        Tuple<String, Integer> proxyHostPort = this.parseProxyEnv("http_proxy");
        if (proxyHostPort == null) {
            proxyHostPort = this.parseProxyEnv("HTTP_PROXY");
        }
        if (proxyHostPort == null) {
            proxyHostPort = this.parseProxyJavaPropperty();
        }
        if (proxyHostPort == null) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostPort.getFirst(), (int)proxyHostPort.getSecond()));
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaskDownloadException(boolean maskDownloadException) {
        this.maskDownloadException = maskDownloadException;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void sslSetup() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLContext.setDefault(ctx);
    }

    public boolean unzip(String zipFile, String mainDir, String dataDir) {
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zipFile);
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fis));
            ZipOutputStream zipBackup = null;
            String backupFile = "";
            if (this.update) {
                backupFile = String.format("%s/backup_%2$tY-%2$tm-%2$td_%2$tH:%2$tM:%2$tS.zip", mainDir, new GregorianCalendar());
                if (this.verbose) {
                    Log.info("Creating backup file '" + backupFile + "'");
                }
                zipBackup = new ZipOutputStream(new FileOutputStream(backupFile));
            }
            while ((entry = zipIn.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    String dirName;
                    File dir;
                    String localEntryName = this.parseEntryPath(entry.getName(), mainDir, dataDir);
                    if (this.debug) {
                        Log.debug("Extracting file '" + entry.getName() + "' to '" + localEntryName + "'");
                    } else if (this.verbose) {
                        Log.info("Extracting file '" + entry.getName() + "'");
                    }
                    if (zipBackup != null) {
                        this.backupFile(zipBackup, localEntryName);
                    }
                    if (!(dir = new File(dirName = Gpr.dirName(localEntryName))).exists()) {
                        if (this.verbose) {
                            Log.info("Creating local directory: '" + String.valueOf(dir) + "'");
                        }
                        if (!dir.mkdirs()) {
                            throw new RuntimeException("Cannot create directory '" + dir.getCanonicalPath() + "'");
                        }
                    }
                    FileOutputStream fos = new FileOutputStream(localEntryName);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 102400);
                    int count = 0;
                    byte[] data = new byte[102400];
                    while ((count = zipIn.read(data, 0, 102400)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    continue;
                }
                if (!entry.isDirectory()) continue;
                String dir = this.parseEntryPath(entry.getName(), mainDir, dataDir);
                if (this.verbose) {
                    Log.info("Creating local directory: '" + dir + "'");
                }
                if (new File(dir).mkdirs()) continue;
                throw new RuntimeException("Cannot create directory '" + dir + "'");
            }
            zipIn.close();
            if (zipBackup != null) {
                zipBackup.close();
                Log.info("Backup file created: '" + backupFile + "'");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

