/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import org.snpeff.util.Gpr;

public class Diff {
    boolean ignoreCase;
    boolean ignoreSpaces;
    boolean showOnlyDifferentLines;
    String s1;
    String s2;

    public Diff(String s1, String s2) {
        this.s1 = s1;
        this.s2 = s2;
        this.ignoreCase = false;
        this.ignoreSpaces = true;
        this.showOnlyDifferentLines = true;
    }

    String diff() {
        String[] lines1 = this.lines(this.s1);
        String[] lines2 = this.lines(this.s2);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < Math.max(lines1.length, lines2.length); ++i2) {
            String l1 = i2 < lines1.length ? lines1[i2] : "";
            String l2 = i2 < lines2.length ? lines2[i2] : "";
            int lineNum = i2 + 1;
            if (l1.equals(l2)) {
                if (this.showOnlyDifferentLines) continue;
                sb.append(lineNum + "\tOK   : " + l1 + "\n");
                continue;
            }
            if (!this.showOnlyDifferentLines) {
                sb.append(lineNum + "\tDiff : " + l1 + "\n");
                sb.append(lineNum + "\t     : " + l2 + "\n");
                sb.append(lineNum + "\t     : " + this.diffLine(l1, l2) + "\n");
                continue;
            }
            sb.append(lineNum + "\t: " + l1 + "\n");
            sb.append(lineNum + "\t: " + l2 + "\n");
            sb.append(lineNum + "\t: " + this.diffLine(l1, l2) + "\n\n");
        }
        return sb.toString();
    }

    String diffLine(String s1, String s2) {
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        int max = Math.max(chars1.length, chars2.length);
        char[] d = new char[max];
        for (int i2 = 0; i2 < max; ++i2) {
            char c1 = i2 < chars1.length ? chars1[i2] : (char)'\u0000';
            char c2 = i2 < chars2.length ? chars2[i2] : (char)'\u0000';
            d[i2] = c1 == c2 ? 32 : 94;
        }
        return new String(d);
    }

    public boolean equals() {
        String[] lines1 = this.lines(this.s1);
        String[] lines2 = this.lines(this.s2);
        for (int i2 = 0; i2 < Math.max(lines1.length, lines2.length); ++i2) {
            String l2;
            String l1 = i2 < lines1.length ? lines1[i2] : "";
            String string = l2 = i2 < lines2.length ? lines2[i2] : "";
            if (l1.equals(l2)) continue;
            return false;
        }
        return true;
    }

    String[] lines(String str) {
        String[] l = str.split("\n");
        for (int i2 = 0; i2 < l.length; ++i2) {
            if (this.ignoreCase) {
                l[i2] = l[i2].toLowerCase();
            }
            if (!this.ignoreSpaces) continue;
            l[i2] = Gpr.noSpaces(l[i2]);
        }
        return l;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setIgnoreSpaces(boolean ignoreSpaces) {
        this.ignoreSpaces = ignoreSpaces;
    }

    public void setShowOnlyDifferentLines(boolean showOnlyDifferentLines) {
        this.showOnlyDifferentLines = showOnlyDifferentLines;
    }

    public String toString() {
        return this.diff();
    }
}

