/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.util.Iterator;

public class CombinatorialIterator
implements Iterable<int[]>,
Iterator<int[]> {
    int[] next;
    int[] max;
    int[] min;
    boolean inc;
    boolean finished;

    public CombinatorialIterator(int size) {
        this.next = new int[size];
        this.max = new int[size];
        this.min = new int[size];
    }

    @Override
    public boolean hasNext() {
        if (this.inc) {
            this.inc();
        }
        return !this.finished;
    }

    public void inc() {
        this.inc = false;
        for (int i2 = 0; i2 < this.next.length; ++i2) {
            if (this.next[i2] < this.max[i2]) {
                int n = i2;
                this.next[n] = this.next[n] + 1;
                return;
            }
            this.next[i2] = this.min[i2];
        }
        this.finished = true;
    }

    @Override
    public Iterator<int[]> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int[] next() {
        if (this.inc) {
            this.inc();
        }
        if (!this.hasNext()) {
            return null;
        }
        this.inc = true;
        return this.next;
    }

    @Override
    public void remove() {
    }

    void reset() {
        this.inc = false;
        this.finished = false;
        for (int i2 = 0; i2 < this.next.length; ++i2) {
            this.next[i2] = this.min[i2];
        }
    }

    public void set(int idx, int min, int max) {
        if (max <= min) {
            throw new RuntimeException("Cannot initialize 'max' less or equal than 'min'. min = " + min + ", max = " + max);
        }
        this.min[idx] = min;
        this.max[idx] = max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < this.next.length; ++i2) {
            sb.append((i2 > 0 ? ", " : "") + this.next[i2]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

