/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.svg.Svg;
import org.snpeff.svg.SvgBnd;
import org.snpeff.svg.SvgNextProt;
import org.snpeff.svg.SvgScale;
import org.snpeff.svg.SvgSpacer;

public class SvgTranslocation
extends Svg {
    Transcript tr1;
    Transcript tr2;
    VariantBnd varBnd;
    SnpEffectPredictor snpEffPredictor;

    public SvgTranslocation(Transcript tr1, Transcript tr2, VariantBnd varBnd, SnpEffectPredictor snpEffPredictor) {
        this.tr1 = tr1;
        this.tr2 = tr2;
        this.varBnd = varBnd;
        this.snpEffPredictor = snpEffPredictor;
    }

    Svg nextProt(Transcript tr, Svg svgTr) {
        Markers results = this.snpEffPredictor.query(tr);
        Markers nextprotMarkers = new Markers();
        for (Marker m : results) {
            if (!(m instanceof NextProt)) continue;
            NextProt np = (NextProt)m;
            if (!tr.getId().equals(np.getTranscriptId())) continue;
            nextprotMarkers.add(m);
        }
        SvgNextProt svgNextProt = new SvgNextProt(tr, svgTr, nextprotMarkers);
        return svgNextProt;
    }

    @Override
    public String toString() {
        if (this.tr2.intersects(this.varBnd.getStart()) && this.tr1.intersects(this.varBnd.getEndPoint().getStart())) {
            Transcript trTmp = this.tr2;
            this.tr2 = this.tr1;
            this.tr1 = trTmp;
        }
        SvgScale svgScale1 = new SvgScale(this.tr1, null);
        Svg svgTr1 = Svg.factory(this.tr1, svgScale1);
        Svg svgNextProt1 = this.nextProt(this.tr1, svgTr1);
        SvgSpacer svgSpacer = new SvgSpacer(this.tr1, svgNextProt1);
        SvgScale svgScale2 = new SvgScale(this.tr2, svgSpacer);
        svgScale2.setScaleX();
        Svg svgTr2 = Svg.factory(this.tr2, svgScale2);
        Svg svgNextProt2 = this.nextProt(this.tr2, svgTr2);
        SvgBnd svgBnd = new SvgBnd(this.varBnd, svgTr1, svgTr2);
        String svgStr = svgTr1.open() + String.valueOf(svgTr1) + String.valueOf(svgScale1) + String.valueOf(svgNextProt1) + String.valueOf(svgTr2) + String.valueOf(svgScale2) + String.valueOf(svgNextProt2) + String.valueOf(svgBnd) + svgTr1.close();
        return svgStr;
    }
}

