/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import org.snpeff.interval.Cds;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Transcript;
import org.snpeff.svg.Svg;
import org.snpeff.svg.SvgGene;

public class SvgTranscript
extends Svg {
    Transcript tr;

    public SvgTranscript(Transcript tr, Svg svg) {
        super(tr, svg);
        this.tr = tr;
        if (svg != null && svg instanceof SvgGene) {
            this.baseY = svg.baseY + 20;
            this.nextBaseY = this.baseY + 40;
        }
        this.rectColorStroke = "#ffffff";
    }

    @Override
    public String id() {
        double y = this.baseY - this.rectHeight / 2;
        Gene g = (Gene)this.tr.getParent();
        return this.text(this.start(), y, g.getGeneName() + " " + this.tr.getId());
    }

    @Override
    public String toString() {
        Svg svg;
        StringBuilder sb = new StringBuilder();
        sb.append(this.markerId());
        sb.append(this.hline(this.rectHeight / 2));
        for (Cds cds : this.tr.getCds()) {
            svg = SvgTranscript.factory(cds, this);
            sb.append("\t" + String.valueOf(svg));
        }
        for (Intron intron : this.tr.introns()) {
            svg = SvgTranscript.factory(intron, this);
            sb.append("\t" + String.valueOf(svg));
        }
        return sb.toString();
    }
}

