/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import java.text.NumberFormat;
import java.util.Locale;
import org.snpeff.interval.Marker;
import org.snpeff.svg.Svg;

public class SvgScale
extends Svg {
    public static final int SCALE_TICK_HEIGHT = 20;
    public static final int SCALE_HEIGHT = 30;

    public SvgScale(Marker m, Svg svg) {
        super(m, svg);
        this.nextBaseY = this.baseY + 60;
    }

    String scale() {
        int st;
        StringBuilder sb = new StringBuilder();
        sb.append(this.line(0.0, this.baseY + 10, this.sizeY, this.baseY + 10));
        int step = this.selectStep();
        for (int pos = st = this.m.getStart() / step * step; pos < this.m.getEnd(); pos += step) {
            double x = this.pos2coord(pos);
            sb.append(this.line(x, this.baseY + 0, x, this.baseY + 20));
            String posStr = NumberFormat.getNumberInstance(Locale.US).format(pos);
            sb.append(this.text(x, this.baseY + 20 + 10, posStr));
        }
        sb.append(this.text(0.0, this.baseY + 10, "chr" + this.m.getChromosomeName()));
        return sb.toString();
    }

    int selectStep() {
        for (int i2 = 1; i2 < 100000000; i2 *= 10) {
            if (this.m.size() / i2 >= 20) continue;
            return i2;
        }
        return 1000000;
    }

    @Override
    public String toString() {
        return this.scale();
    }
}

