/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import org.snpeff.interval.Cds;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.IntervalAndSubIntervals;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.svg.SvgCds;
import org.snpeff.svg.SvgExon;
import org.snpeff.svg.SvgGene;
import org.snpeff.svg.SvgIntron;
import org.snpeff.svg.SvgTranscript;

public class Svg {
    public static final int DEFAULT_SIZE_X = 1000;
    public static final int DEFAULT_SIZE_Y = 1000;
    public static final int DEFAULT_BASE_Y = 10;
    public static final String LINE_COLOR_STROKE = "#000000";
    public static final int LINE_STROKE_WIDTH = 1;
    public static final String RECT_COLOR_FILL = "#FFFFFF";
    public static final String RECT_COLOR_STROKE = "#000000";
    public static final int RECT_HEIGHT = 20;
    public static final int RECT_STROKE_WIDTH = 1;
    public static final int TEXT_SIZE = 10;
    public static final String TEXT_STYLE = "font-family: Arial; font-size:10;";
    public static boolean debug = false;
    int baseY = 10;
    int lineStrokeWidth = 1;
    String lineColor = "#000000";
    Marker m;
    int nextBaseY;
    int posStart;
    int posEnd;
    int rectHeight = 20;
    String rectColorFill = "#FFFFFF";
    String rectColorStroke = "#000000";
    double scaleX;
    int sizeX = 1000;
    int sizeY = 1000;

    public static Svg factory(Marker m, Svg svg) {
        switch (m.getType()) {
            case EXON: {
                return new SvgExon((Exon)m, svg);
            }
            case CDS: {
                return new SvgCds((Cds)m, svg);
            }
            case INTRON: {
                return new SvgIntron((Intron)m, svg);
            }
            case GENE: {
                return new SvgGene((Gene)m, svg);
            }
            case TRANSCRIPT: {
                return new SvgTranscript((Transcript)m, svg);
            }
        }
        return new Svg(m, svg);
    }

    public Svg() {
    }

    public Svg(Marker m, Svg svg) {
        this();
        this.m = m;
        if (svg != null) {
            this.posStart = svg.posStart;
            this.posEnd = svg.posEnd;
            this.scaleX = svg.scaleX;
            this.baseY = svg.nextBaseY;
        } else {
            this.setScaleX();
        }
        this.nextBaseY = this.baseY + 40;
    }

    public String close() {
        return "</svg>\n";
    }

    double end() {
        return (double)(this.m.getEnd() - this.posStart) * this.scaleX;
    }

    public String hline(int y) {
        return this.line(this.start(), this.baseY + y, this.end(), this.baseY + y);
    }

    public String id() {
        double y = this.baseY - this.rectHeight / 2;
        return this.text(this.start(), y, this.m.getId());
    }

    String line(double x1, double y1, double x2, double y2) {
        String lineStyle = "stroke:" + this.lineColor + ";stroke-width:" + this.lineStrokeWidth;
        return "<line x1=" + x1 + " y1=" + y1 + " x2=" + x2 + " y2=" + y2 + " style=\"" + lineStyle + "\"/>\n";
    }

    public String marker() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rectangle());
        if (this.m instanceof IntervalAndSubIntervals) {
            IntervalAndSubIntervals msubs = (IntervalAndSubIntervals)this.m;
            for (Object o : msubs) {
                Marker sub = (Marker)o;
                Svg svg = Svg.factory(sub, this);
                sb.append("\t" + String.valueOf(svg));
            }
        }
        return sb.toString();
    }

    public String markerId() {
        return this.marker() + this.id();
    }

    public String open() {
        return "<svg width=\"" + this.sizeX + "\" height=\"" + this.sizeY + "\">\n";
    }

    double pos2coord(int pos) {
        return (double)(pos - this.posStart) * this.scaleX;
    }

    public String rectangle() {
        double w = this.size();
        double h = this.rectHeight;
        double x = this.start();
        double y = this.baseY;
        return this.rectangle(x, y, w, h, false);
    }

    public String rectangle(double x, double y, double w, double h, boolean empty) {
        String rectStyle = "fill:" + (empty ? "none" : this.rectColorFill) + ";stroke:" + this.rectColorStroke + ";stroke-width:1";
        return "<rect x=" + x + " y=" + y + " width=" + w + " height=" + h + " style=\"" + rectStyle + "\"/>\n";
    }

    public void setBaseY(int baseY) {
        this.baseY = baseY;
    }

    void setScaleX() {
        this.posStart = this.m.getStart();
        this.posEnd = this.m.getEnd();
        if (this.posEnd <= this.posStart) {
            throw new RuntimeException("Marker 'start' after 'end': Unsupported!");
        }
        this.scaleX = (double)this.sizeX / (double)(this.posEnd - this.posStart);
    }

    double size() {
        return (double)this.m.size() * this.scaleX;
    }

    double start() {
        return (double)(this.m.getStart() - this.posStart) * this.scaleX;
    }

    public String text(double x, double y, String str) {
        return "<text x=" + x + " y=" + y + " style=\"font-family: Arial; font-size:10;\">" + str + "</text>\n";
    }

    public String toString() {
        return this.marker();
    }
}

