/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats.plot;

import java.util.ArrayList;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Intergenic;
import org.snpeff.interval.Intron;
import org.snpeff.stats.CoverageByType;
import org.snpeff.stats.plot.GoogleGeneRegionChart;

public class GoogleGeneRegionNumExonsChart
extends GoogleGeneRegionChart {
    int exons;

    public GoogleGeneRegionNumExonsChart(CoverageByType coverageByType, String name, int exons) {
        super(coverageByType, name);
        this.exons = exons;
    }

    @Override
    void initTypes() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        boolean exonsAdded = false;
        for (String type : DEFAULT_TYPES) {
            if (type.equals(Exon.class.getSimpleName()) || type.equals(Intron.class.getSimpleName())) {
                if (exonsAdded) continue;
                for (int ex = 1; ex <= this.exons; ++ex) {
                    typeList.add(Exon.class.getSimpleName() + ":" + ex + ":" + this.exons);
                    if (ex >= this.exons) continue;
                    typeList.add(Intron.class.getSimpleName() + ":" + ex + ":" + this.exons);
                }
                exonsAdded = true;
                continue;
            }
            if (type.equals(Intergenic.class.getSimpleName())) continue;
            typeList.add(type);
        }
        this.types = typeList.toArray(new String[0]);
    }
}

