/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats.plot;

import com.googlecode.charts4j.AxisLabelsFactory;
import com.googlecode.charts4j.BarChart;
import com.googlecode.charts4j.BarChartPlot;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.GCharts;
import com.googlecode.charts4j.Plots;
import java.util.ArrayList;

public class GoogleGenePercentBar {
    static final int len = 11;
    int plotSizeY = 300;
    int plotSizeX = 800;
    ArrayList<String> labelList;
    String title = "";
    String xAxisLabel = "";
    String yAxisLabel = "";
    Data dinter;
    Data dup;
    Data dutr5;
    Data dexon;
    Data dssDonor;
    Data dintron;
    Data dssAcceptor;
    Data dutr3;
    Data ddown;
    double maxY = Double.MIN_VALUE;

    public GoogleGenePercentBar(String title, String xAxisLabel, String yAxisLabel, double intergenic, double upstream, double utr5, double exon, double spliceSiteDonor, double intron, double spliceSiteAcceptor, double utr3, double downstream) {
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.maxY = Math.max(intergenic, Math.max(upstream, Math.max(utr5, Math.max(exon, Math.max(intron, Math.max(utr3, Math.max(downstream, Math.max(spliceSiteAcceptor, spliceSiteDonor))))))));
        this.dinter = this.data(intergenic, 0, 10, 11);
        this.dup = this.data(upstream, 1, -1, 11);
        this.dutr5 = this.data(utr5, 2, -1, 11);
        this.dexon = this.data(exon, 3, 7, 11);
        this.dssDonor = this.data(spliceSiteDonor, 4, -1, 11);
        this.dintron = this.data(intron, 5, -1, 11);
        this.dssAcceptor = this.data(spliceSiteAcceptor, 6, -1, 11);
        this.dutr3 = this.data(utr3, 8, -1, 11);
        this.ddown = this.data(downstream, 9, -1, 11);
        this.labelList = new ArrayList();
        this.labelList.add("Intergenic");
        this.labelList.add("Up");
        this.labelList.add("5'UTR");
        this.labelList.add("Exon");
        this.labelList.add("Donor");
        this.labelList.add("Intron");
        this.labelList.add("Acceptor");
        this.labelList.add("Exon");
        this.labelList.add("3'UTR");
        this.labelList.add("Down");
        this.labelList.add("Intergenic");
    }

    Data data(double value, int position, int position2, int len) {
        double scaledVal = 100.0 * value / this.maxY;
        ArrayList<Double> data = new ArrayList<Double>();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 == position || i2 == position2) {
                data.add(scaledVal);
                continue;
            }
            data.add(0.0);
        }
        return Data.newData(data);
    }

    void decorate(BarChart chart) {
        chart.setTitle(this.title);
        chart.setSize(this.plotSizeX, this.plotSizeY);
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels(this.labelList));
        chart.addYAxisLabels(AxisLabelsFactory.newNumericRangeAxisLabels((double)0.0, (double)this.maxY));
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels((String)this.xAxisLabel, (double)50.0));
        chart.addYAxisLabels(AxisLabelsFactory.newAxisLabels((String)this.yAxisLabel, (double)50.0));
        chart.setDataStacked(true);
        chart.setBarWidth(50);
    }

    public String toURLString() {
        BarChartPlot plotInter = Plots.newBarChartPlot((Data)this.dinter, (Color)Color.GRAY, (String)"Intergenic");
        BarChartPlot plottUp = Plots.newBarChartPlot((Data)this.dup, (Color)Color.AQUA, (String)"Upstream");
        BarChartPlot plotUtr5 = Plots.newBarChartPlot((Data)this.dutr5, (Color)Color.SALMON, (String)"5'UTR");
        BarChartPlot plotExon = Plots.newBarChartPlot((Data)this.dexon, (Color)Color.RED, (String)"Exon");
        BarChartPlot plotSsDonor = Plots.newBarChartPlot((Data)this.dssDonor, (Color)Color.BROWN, (String)"Splice Donor");
        BarChartPlot plotIntron = Plots.newBarChartPlot((Data)this.dintron, (Color)Color.ORANGE, (String)"Intron");
        BarChartPlot plotSsAcceptor = Plots.newBarChartPlot((Data)this.dssAcceptor, (Color)Color.BURLYWOOD, (String)"Splice Acceptor");
        BarChartPlot plotUtr3 = Plots.newBarChartPlot((Data)this.dutr3, (Color)Color.DARKSALMON, (String)"3'UTR");
        BarChartPlot plotDown = Plots.newBarChartPlot((Data)this.ddown, (Color)Color.AQUAMARINE, (String)"Downstream");
        BarChart barChart = GCharts.newBarChart((BarChartPlot[])new BarChartPlot[]{plottUp, plotUtr5, plotExon, plotSsDonor, plotIntron, plotSsAcceptor, plotUtr3, plotDown, plotInter});
        this.decorate(barChart);
        return barChart.toURLString();
    }
}

