/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats.plot;

import java.util.ArrayList;
import org.snpeff.stats.plot.GoogleLineChart;
import org.snpeff.util.Gpr;

public class GoogleBarChart
extends GoogleLineChart {
    public GoogleBarChart(String name) {
        super(name);
    }

    public GoogleBarChart(String name, int width, int height) {
        super(name, width, height);
    }

    public void percentColumns() {
        ArrayList<ArrayList<String>> newColumns = new ArrayList<ArrayList<String>>();
        for (ArrayList col : this.columns) {
            newColumns.add(this.percentColumns(col));
        }
        this.columns = newColumns;
    }

    public ArrayList<String> percentColumns(ArrayList<String> col) {
        ArrayList<String> newCol = new ArrayList<String>(col.size());
        double total = 0.0;
        for (String d : col) {
            total += Gpr.parseDoubleSafe(d);
        }
        for (String d : col) {
            newCol.add("" + 100.0 * Gpr.parseDoubleSafe(d) / total);
        }
        return newCol;
    }

    @Override
    public String toStringHtmlHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>");
        sb.append("<script type=\"text/javascript\"> google.load('visualization', '1', {packages: ['corechart']}); </script>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("\tfunction draw_" + this.id + "() {\n");
        sb.append("\t\tvar data = google.visualization.arrayToDataTable([\n");
        sb.append("\t[ '' , ");
        int i2 = 0;
        for (String ct : this.columnTitltes) {
            sb.append((i2 > 0 ? "," : "") + "'" + ct + "'");
            ++i2;
        }
        sb.append("]\n");
        int maxLen = this.maxColumnLength();
        for (i2 = 0; i2 < maxLen; ++i2) {
            Object lab = this.getXLabel(i2);
            if (lab != null) {
                lab = "'" + (String)lab + "'";
            }
            sb.append("\t,[ " + (String)lab);
            for (int j = 0; j < this.columns.size(); ++j) {
                sb.append("," + this.getValue(i2, j));
            }
            sb.append("]\n");
        }
        sb.append("\t\t]);\n");
        sb.append("\t\tvar ac = new google.visualization.ColumnChart(document.getElementById('visualization_" + this.id + "'));\n");
        sb.append("\t\tac.draw(data, { title : '" + this.title + "', isStacked: " + this.stacked + ", width: " + this.width + ", height: " + this.height + ", vAxis: {title: \"" + this.vAxis + "\"}, hAxis: {title: \"" + this.hAxis + "\"} });\n");
        sb.append("\t\t}\n");
        sb.append("\tgoogle.setOnLoadCallback(draw_" + this.id + ");\n");
        sb.append("</script>\n");
        sb.append("\n");
        return sb.toString();
    }
}

