/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.util.GprSeq;

public abstract class ObservedOverExpected {
    public double expected(Exon e) {
        String seq = e.getSequence();
        double eplus = this.expected(seq);
        double eminus = this.expected(GprSeq.reverseWc(seq));
        return (eplus + eminus) / 2.0;
    }

    public double expected(Gene g) {
        double eplus = 0.0;
        double eminus = 0.0;
        for (Transcript t : g) {
            for (Exon e : t) {
                String seq = e.getSequence();
                eplus += this.expected(seq);
                eminus += this.expected(GprSeq.reverseWc(seq));
            }
        }
        return (eplus + eminus) / 2.0;
    }

    public abstract double expected(String var1);

    public double expected(Transcript t) {
        double eplus = 0.0;
        double eminus = 0.0;
        for (Exon e : t) {
            String seq = e.getSequence();
            eplus += this.expected(seq);
            eminus += this.expected(GprSeq.reverseWc(seq));
        }
        return (eplus + eminus) / 2.0;
    }

    public int observed(Exon e) {
        String seq = e.getSequence();
        int oplus = this.observed(seq);
        int ominus = this.observed(GprSeq.reverseWc(seq));
        return (oplus + ominus) / 2;
    }

    public int observed(Gene g) {
        int oplus = 0;
        int ominus = 0;
        for (Transcript t : g) {
            for (Exon e : t) {
                String seq = e.getSequence();
                oplus += this.observed(seq);
                ominus += this.observed(GprSeq.reverseWc(seq));
            }
        }
        return (oplus + ominus) / 2;
    }

    public abstract int observed(String var1);

    public int observed(Transcript t) {
        int oplus = 0;
        int ominus = 0;
        for (Exon e : t) {
            String seq = e.getSequence();
            oplus += this.observed(seq);
            ominus += this.observed(GprSeq.reverseWc(seq));
        }
        return (oplus + ominus) / 2;
    }

    public int observedChg(String sequence) {
        int count = 0;
        char[] bases = sequence.toUpperCase().toCharArray();
        for (int i2 = 0; i2 < bases.length - 2; ++i2) {
            if (bases[i2] != 'C' || bases[i2 + 1] == 'G' || bases[i2 + 2] != 'G') continue;
            ++count;
        }
        return count;
    }

    public double oe(Exon e) {
        return (double)this.observed(e) / this.expected(e);
    }

    public double oe(Gene g) {
        double exp = this.expected(g);
        return exp > 0.0 ? (double)this.observed(g) / exp : 0.0;
    }

    public double oe(String sequence) {
        double exp = this.expected(sequence);
        return exp > 0.0 ? (double)this.observed(sequence) / exp : 0.0;
    }

    public double oe(Transcript t) {
        double exp = this.expected(t);
        return exp > 0.0 ? (double)this.observed(t) / exp : 0.0;
    }
}

