/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import gnu.trove.map.hash.TIntIntHashMap;
import java.io.Serializable;
import java.util.Arrays;
import org.snpeff.stats.StatsProcedure;
import org.snpeff.stats.plot.GoogleHistogram;
import org.snpeff.stats.plot.GooglePlotInt;

public class IntStats
implements Serializable {
    int maxBins = Integer.MAX_VALUE;
    TIntIntHashMap counters = new TIntIntHashMap();
    boolean needUpdate = true;
    StatsProcedure statsProcedure = new StatsProcedure(0.0);

    public static String toStringTabTitle() {
        return "Count\tSum\tMax\tMin\tMean\tMedian\tStdDev";
    }

    public int getCount() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.count;
    }

    public int getCount(int sample) {
        return this.counters.get(sample);
    }

    public int getMax() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.maxKey;
    }

    public int getMaxBins() {
        return this.maxBins;
    }

    public int getMaxCount() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.maxValue;
    }

    public double getMean() {
        if (this.needUpdate) {
            this.update();
        }
        if (this.statsProcedure.count <= 0) {
            return 0.0;
        }
        return (double)this.statsProcedure.sum / (double)this.statsProcedure.count;
    }

    public double getMedian() {
        return this.getQuantile(0.5);
    }

    public int getMin() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.minKey;
    }

    public int getMinCount() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.minValue;
    }

    public double getQuantile(double quantile) {
        if (this.needUpdate) {
            this.update();
        }
        int[] keys = this.counters.keys();
        Arrays.sort(keys);
        int count = 0;
        int median = 0;
        int prevKey = 0;
        int threshold = (int)(quantile * (double)this.statsProcedure.count);
        boolean isOdd = this.statsProcedure.count % 2 == 1;
        for (int i2 = 0; i2 < keys.length; ++i2) {
            int key = keys[i2];
            int countKey = this.counters.get(key);
            median = key;
            if ((count += countKey) == threshold) {
                if (isOdd) {
                    return key;
                }
                int nextKey = keys[i2 + 1];
                return (double)(key + nextKey) / 2.0;
            }
            if (count > threshold) {
                if (countKey > 1) {
                    return key;
                }
                return (double)(key + prevKey) / 2.0;
            }
            prevKey = key;
        }
        return median;
    }

    public double getStd() {
        if (this.needUpdate) {
            this.update();
        }
        return Math.sqrt(this.statsProcedure.variance());
    }

    public long getSum() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.sum;
    }

    public boolean isValidData() {
        if (this.needUpdate) {
            this.update();
        }
        return this.statsProcedure.minKey <= this.statsProcedure.maxKey;
    }

    public void sample(int num) {
        int count = this.counters.get(num) + 1;
        this.counters.put(num, count);
        this.needUpdate = true;
    }

    public void setMaxBins(int maxBins) {
        this.maxBins = maxBins;
    }

    public String toString() {
        return "\tCount  : " + this.getCount() + "\n\tSum    : " + this.getSum() + "\n\tMax    : " + this.getMax() + "\n\tMin    : " + this.getMin() + "\n\tMean   : " + this.getMean() + "\n\tMedian : " + this.getMedian() + "\n\tStdDev : " + this.getStd();
    }

    public String toStringCounts() {
        StringBuilder countsb = new StringBuilder();
        int[] keys = this.counters.keys();
        Arrays.sort(keys);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            int key = keys[i2];
            int count = this.counters.get(key);
            countsb.append((i2 > 0 ? "," : "") + count);
        }
        return countsb.toString();
    }

    public String toStringHisto() {
        return "\t\tValues:\t" + this.toStringValues() + "\n\t\tCounts:\t" + this.toStringCounts() + "\n";
    }

    public String toStringPlot(String title, String xAxisLabel, boolean barChart) {
        GooglePlotInt ggplot;
        int[] values = this.counters.keys();
        Arrays.sort(values);
        int[] counts = new int[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            counts[i2] = this.counters.get(values[i2]);
        }
        if (barChart) {
            GoogleHistogram gbar = new GoogleHistogram(values, counts, title, xAxisLabel, "Count");
            gbar.setMaxBins(this.maxBins);
            ggplot = gbar;
        } else {
            ggplot = new GooglePlotInt(values, counts, title, xAxisLabel, "Count");
        }
        return ggplot.toURLString();
    }

    public String toStringTab() {
        return this.getCount() + "\t" + this.getSum() + "\t" + this.getMax() + "\t" + this.getMin() + "\t" + this.getMean() + "\t" + this.getMedian() + "\t" + this.getStd();
    }

    public String toStringValues() {
        StringBuilder keysb = new StringBuilder();
        int[] keys = this.counters.keys();
        Arrays.sort(keys);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            int key = keys[i2];
            keysb.append((i2 > 0 ? "," : "") + key);
        }
        return keysb.toString();
    }

    void update() {
        this.statsProcedure = new StatsProcedure(0.0);
        this.counters.forEachEntry(this.statsProcedure);
        this.statsProcedure = new StatsProcedure(this.statsProcedure.mean());
        this.counters.forEachEntry(this.statsProcedure);
        this.needUpdate = false;
    }
}

