/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.List;
import org.snpeff.stats.SamplingStats;
import org.snpeff.vcf.VcfEntry;

public class HomHetStats
implements SamplingStats<VcfEntry> {
    List<String> sampleNames;
    long[] countHomRef;
    long[] countAlt1;
    long[] countAlt2;
    long[] countMissing;

    @Override
    public boolean hasData() {
        return this.countHomRef != null;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        byte[] gt = vcfEntry.getGenotypesScores();
        if (gt == null || gt.length < 1) {
            return;
        }
        if (this.countHomRef == null) {
            int size = gt.length;
            this.countHomRef = new long[size];
            this.countAlt1 = new long[size];
            this.countAlt2 = new long[size];
            this.countMissing = new long[size];
        }
        block6: for (int i2 = 0; i2 < gt.length; ++i2) {
            switch (gt[i2]) {
                case -1: {
                    int n = i2;
                    this.countMissing[n] = this.countMissing[n] + 1L;
                    continue block6;
                }
                case 0: {
                    int n = i2;
                    this.countHomRef[n] = this.countHomRef[n] + 1L;
                    continue block6;
                }
                case 1: {
                    int n = i2;
                    this.countAlt1[n] = this.countAlt1[n] + 1L;
                    continue block6;
                }
                case 2: {
                    int n = i2;
                    this.countAlt2[n] = this.countAlt2[n] + 1L;
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unknown genotype code '" + gt[i2] + "'");
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            sb.append(this.toStringArray("Homozygous reference", this.countHomRef));
            sb.append(this.toStringArray("One ALT", this.countAlt1));
            sb.append(this.toStringArray("Two ALTs", this.countAlt2));
            sb.append(this.toStringArray("Missing", this.countMissing));
        }
        return sb.toString();
    }

    String toStringArray(String title, long[] count) {
        StringBuilder sb = new StringBuilder();
        sb.append(title + ",");
        long total = 0L;
        for (int i2 = 0; i2 < count.length; ++i2) {
            sb.append(count[i2] + ",");
            total += count[i2];
        }
        sb.append(total + "\n");
        return sb.toString();
    }
}

