/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.ArrayList;
import java.util.List;
import org.snpeff.stats.IntStats;
import org.snpeff.stats.SamplingStats;
import org.snpeff.stats.plot.GoogleHistogram;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public class GenotypeStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    static final String UNIQUE_SAMPLE_NAME = "No_sample_name_found";
    List<String> sampleNames;
    IntStats alleleCount = new IntStats();
    IntStats alleleFrequency = new IntStats();
    int[] countHom;
    int[] countHet;
    int[] countRef;
    int[] countMissing;

    String countBySampleBarChartUrl(int[] count, String title, String xlabel, String ylabel) {
        if (this.countMissing == null) {
            return "";
        }
        int[] sampleNum = new int[this.countMissing.length];
        for (int i2 = 0; i2 < this.countMissing.length; ++i2) {
            sampleNum[i2] = i2;
        }
        GoogleHistogram barChart = new GoogleHistogram(sampleNum, count, title, xlabel, ylabel);
        return barChart.toURLString();
    }

    public IntStats getAlleleCount() {
        return this.alleleCount;
    }

    public String getAlleleCountHistoUrl() {
        return this.alleleCount.toStringPlot("Allele Count", "Allele Count", true);
    }

    public IntStats getAlleleFrequency() {
        return this.alleleFrequency;
    }

    public String getAlleleFrequencyHistoUrl() {
        return this.alleleFrequency.toStringPlot("Allele Frequency %", "Alleles frequency", true);
    }

    public String getHetBySampleUrl() {
        return this.countBySampleBarChartUrl(this.countHet, "Heterozygous genotypes", "Sample number", "Heterozygous count");
    }

    public String getHomBySampleUrl() {
        return this.countBySampleBarChartUrl(this.countHom, "Homozygous (ALT) genotypes", "Sample number", "Homozygous count");
    }

    public String getHomHetTable() {
        int i2;
        if (this.sampleNames == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sample_names ");
        for (String s : this.sampleNames) {
            sb.append(", " + s);
        }
        sb.append("\n");
        sb.append("Reference ");
        for (i2 = 0; i2 < this.countRef.length; ++i2) {
            sb.append(", " + this.countRef[i2]);
        }
        sb.append("\n");
        sb.append("Het ");
        for (i2 = 0; i2 < this.countHet.length; ++i2) {
            sb.append(", " + this.countHet[i2]);
        }
        sb.append("\n");
        sb.append("Hom ");
        for (i2 = 0; i2 < this.countHom.length; ++i2) {
            sb.append(", " + this.countHom[i2]);
        }
        sb.append("\n");
        sb.append("Missing ");
        for (i2 = 0; i2 < this.countMissing.length; ++i2) {
            sb.append(", " + this.countMissing[i2]);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getMissingBySampleUrl() {
        return this.countBySampleBarChartUrl(this.countMissing, "Missing genotypes", "Sample number", "Missing count");
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
            if (this.sampleNames == null) {
                this.sampleNames = new ArrayList<String>();
                this.sampleNames.add(UNIQUE_SAMPLE_NAME);
            }
            int len = this.sampleNames.size();
            int lenGts = vcfEntry.getVcfGenotypes() != null ? vcfEntry.getVcfGenotypes().size() : 0;
            len = Math.max(len, lenGts);
            this.countRef = new int[len];
            this.countHet = new int[len];
            this.countHom = new int[len];
            this.countMissing = new int[len];
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        if (!vcfEntry.getVcfGenotypes().isEmpty()) {
            int ac = 0;
            int totalAc = 0;
            int gtNum = 0;
            for (VcfGenotype vcfGenotype : vcfEntry) {
                if (gtNum >= this.countHet.length) {
                    Log.debug("WARNING: VCF entry has more genotype fields than expected (expected: " + this.countHet.length + ", number of genotypes: " + gtNum + ").\n" + String.valueOf(vcfEntry));
                } else {
                    int code = vcfGenotype.getGenotypeCode();
                    if (code > 0) {
                        ac += code;
                        totalAc += 2;
                        if (code == 1) {
                            int n = gtNum;
                            this.countHet[n] = this.countHet[n] + 1;
                        } else if (code == 2) {
                            int n = gtNum;
                            this.countHom[n] = this.countHom[n] + 1;
                        }
                    } else if (code == 0) {
                        totalAc += 2;
                        int n = gtNum;
                        this.countRef[n] = this.countRef[n] + 1;
                    } else {
                        int n = gtNum;
                        this.countMissing[n] = this.countMissing[n] + 1;
                    }
                }
                ++gtNum;
            }
            this.alleleCount.sample(ac);
            double af = (double)ac / (double)totalAc;
            int afInt = (int)(100.0 * af);
            this.alleleFrequency.sample(afInt);
        } else {
            this.alleleCount.sample(1);
        }
    }

    public String toString() {
        return this.alleleCount.toString();
    }
}

