/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snpeff.util.GprHtml;

public class CountByType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TOTAL_TYPE = "Total";
    HashMap<String, Long> countByType = new HashMap();
    HashMap<String, Double> scoreByType = new HashMap();

    public long addScore(String type, double score) {
        Double currScore = this.scoreByType.get(type);
        if (currScore == null) {
            currScore = 0.0;
        }
        this.scoreByType.put(type, currScore + score);
        return this.inc(type);
    }

    public boolean contains(String key) {
        return this.countByType.containsKey(key) || this.scoreByType.containsKey(key);
    }

    public long get(String type) {
        return this.getCount(this.countByType, type);
    }

    public String getColorHtml(String type) {
        if (this.countByType.get(type) == null) {
            return "ffffff";
        }
        long count = this.get(type);
        Long max = Long.MIN_VALUE;
        Long min = Long.MAX_VALUE;
        for (String key : this.countByType.keySet()) {
            long v = this.get(key);
            max = Math.max(max, v);
            min = Math.min(min, v);
        }
        return GprHtml.heatMapColor(count, max, min, 0xFF0000, 65280);
    }

    long getCount(HashMap<String, Long> hash, String type) {
        if (type.equalsIgnoreCase(TOTAL_TYPE)) {
            long total = 0L;
            for (Long count : hash.values()) {
                total += count != null ? count : 0L;
            }
            return total;
        }
        Long count = hash.get(type);
        return count != null ? count : 0L;
    }

    public long getCount(String type) {
        Long count = this.countByType.get(type);
        return count != null ? count : 0L;
    }

    public double getScore(String type) {
        Double score = this.scoreByType.get(type);
        return score != null ? score : 0.0;
    }

    public long getTotalCount() {
        long total = 0L;
        for (Long count : this.countByType.values()) {
            total += count != null ? count : 0L;
        }
        return total;
    }

    public List<String> getTypeList() {
        return this.keysSorted();
    }

    public boolean hasCount(String type) {
        return this.countByType.containsKey(type);
    }

    public boolean hasData() {
        return !this.countByType.isEmpty();
    }

    public boolean hasScore(String type) {
        return this.scoreByType.containsKey(type);
    }

    long inc(HashMap<String, Long> hash, String type, int toAdd) {
        Long count = hash.get(type);
        if (count == null) {
            count = 0L;
        }
        count = count + (long)toAdd;
        hash.put(type, count);
        return count;
    }

    public long inc(String type) {
        return this.inc(this.countByType, type, 1);
    }

    public long inc(String type, int increment) {
        return this.inc(this.countByType, type, increment);
    }

    public boolean isEmpty() {
        return this.countByType.isEmpty() && this.scoreByType.isEmpty();
    }

    public Set<String> keySet() {
        return this.countByType.keySet();
    }

    public List<String> keysRanked(final boolean reverse) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.countByType.keySet());
        Collections.sort(keys, new Comparator<String>(){
            final /* synthetic */ CountByType this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(String arg0, String arg1) {
                return (int)(reverse ? this.this$0.get(arg1) - this.this$0.get(arg0) : this.this$0.get(arg1) - this.this$0.get(arg0));
            }
        });
        return keys;
    }

    public List<String> keysSorted() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.countByType.keySet().isEmpty()) {
            list.addAll(this.countByType.keySet());
        } else {
            list.addAll(this.scoreByType.keySet());
        }
        Collections.sort(list);
        return list;
    }

    public long max() {
        long max = Long.MIN_VALUE;
        for (Long count : this.countByType.values()) {
            max = Math.max(max, count);
        }
        return max;
    }

    public long min() {
        long min = Long.MAX_VALUE;
        for (Long count : this.countByType.values()) {
            min = Math.min(min, count);
        }
        return min;
    }

    public double percent(String type) {
        long total = this.get(TOTAL_TYPE);
        long meth = this.get(type);
        return this.toProb(meth, total);
    }

    public Map<String, Integer> ranks(boolean reverse) {
        List<String> keys = this.keysRanked(reverse);
        HashMap<String, Integer> rank = new HashMap<String, Integer>(keys.size());
        int rankNum = 0;
        for (String key : keys) {
            rank.put(key, rankNum++);
        }
        return rank;
    }

    public void remove(String type) {
        this.countByType.remove(type);
        this.scoreByType.remove(type);
    }

    public void setScore(String type, double score) {
        this.scoreByType.put(type, score);
    }

    public long sum() {
        return this.getTotalCount();
    }

    double toProb(long num, long total) {
        double p = 0.0;
        if (total > 0L) {
            p = (double)num / (double)total;
        }
        return p;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showScores) {
        StringBuffer out = new StringBuffer();
        for (String type : this.keysSorted()) {
            out.append(this.toString(type) + "\n");
        }
        return out.toString();
    }

    public String toString(String type) {
        return type + "\t" + this.get(type) + (String)(this.hasScore(type) ? "\t" + this.getScore(type) + "\t" + this.getScore(type) / (double)this.getCount(type) : "");
    }

    public String toStringLine() {
        StringBuffer out = new StringBuffer();
        for (String type : this.keysSorted()) {
            out.append(type + ":" + this.get(type) + "\t");
        }
        return out.toString();
    }

    public String toStringSort() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.countByType.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return (int)(CountByType.this.get(arg1) - CountByType.this.get(arg0));
            }
        });
        StringBuffer out = new StringBuffer();
        for (String type : keys) {
            out.append(this.toString(type) + "\n");
        }
        return out.toString();
    }

    public String toStringTop(int n) {
        List<String> keys = this.keysRanked(true);
        StringBuffer out = new StringBuffer();
        int i2 = 0;
        for (String type : keys) {
            out.append(this.toString(type) + "\n");
            if (++i2 < n) continue;
            break;
        }
        out.append("Total\t" + this.get(TOTAL_TYPE) + "\n");
        return out.toString();
    }
}

