/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class CountByKey<T>
implements Serializable {
    HashMap<T, Long> countByKey = new HashMap();

    public long get(T key) {
        return this.getCount(this.countByKey, key);
    }

    long getCount(HashMap<T, Long> hash, T key) {
        Long count = hash.get(key);
        return count != null ? count : 0L;
    }

    void inc(HashMap<T, Long> hash, T key, int toAdd) {
        Long count = hash.get(key);
        if (count == null) {
            count = 0L;
        }
        count = count + (long)toAdd;
        hash.put(key, count);
    }

    public void inc(T key) {
        this.inc(this.countByKey, key, 1);
    }

    public void inc(T key, int increment) {
        this.inc(this.countByKey, key, increment);
    }

    public boolean isEmpty() {
        return this.countByKey.isEmpty();
    }

    public Set<T> keySet() {
        return this.countByKey.keySet();
    }

    public long max() {
        long max = Long.MIN_VALUE;
        for (Long count : this.countByKey.values()) {
            max = Math.max(max, count);
        }
        return max;
    }

    public long min() {
        long min = Long.MAX_VALUE;
        for (Long count : this.countByKey.values()) {
            min = Math.min(min, count);
        }
        return min;
    }

    public int size() {
        return this.countByKey.size();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (T type : this.keySet()) {
            out.append(String.valueOf(type) + "\t" + this.get(type) + "\n");
        }
        return out.toString();
    }
}

