/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.List;
import org.snpeff.stats.SamplingStats;
import org.snpeff.vcf.VcfEntry;

public class AlleleCountStats
implements SamplingStats<VcfEntry> {
    public static final int MAX_MAC = 1000;
    List<String> sampleNames;
    int[][] counters;

    @Override
    public boolean hasData() {
        return this.counters != null;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
            int size = this.sampleNames.size();
            int sizeMac = Math.min(1000, size);
            this.counters = new int[sizeMac][size];
            for (int i2 = 0; i2 < this.counters.length; ++i2) {
                for (int j = 0; j < size; ++j) {
                    this.counters[i2][j] = 0;
                }
            }
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        byte[] gt = vcfEntry.getGenotypesScores();
        if (gt == null || gt.length < 1) {
            return;
        }
        int mac = vcfEntry.mac();
        if (mac >= 0 && mac < this.counters.length) {
            int[] count = this.counters[mac];
            for (int i3 = 0; i3 < gt.length; ++i3) {
                if (gt[i3] <= 0) continue;
                int n = i3;
                count[n] = count[n] + 1;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            for (int i2 = 0; i2 < this.counters.length; ++i2) {
                sb.append(this.toStringArray("MAC=" + i2, this.counters[i2]));
            }
        }
        return sb.toString();
    }

    String toStringArray(String title, int[] count) {
        StringBuilder sb = new StringBuilder();
        sb.append(title + ",");
        long total = 0L;
        for (int i2 = 0; i2 < count.length; ++i2) {
            sb.append(count[i2] + ",");
            total += (long)count[i2];
        }
        sb.append(total + "\n");
        return sb.toString();
    }
}

