/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.spliceSites;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.SpliceSiteBranch;
import org.snpeff.interval.SpliceSiteBranchU12;
import org.snpeff.interval.Transcript;
import org.snpeff.motif.MotifLogo;
import org.snpeff.motif.Pwm;
import org.snpeff.probablility.FisherExactTest;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.spliceSites.AcgtTree;
import org.snpeff.spliceSites.SpliceTypes;
import org.snpeff.spliceSites.TranscriptSet;
import org.snpeff.stats.CountByType;
import org.snpeff.stats.IntStats;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Tuple;

public class SnpEffCmdSpliceAnalysis
extends SnpEff {
    public static double P_VALUE_THRESHOLD = 0.001;
    public static int SIZE_CONSENSUS_DONOR = 2;
    public static int SIZE_CONSENSUS_ACCEPTOR = 2;
    public static final double THRESHOLD_ENTROPY = 0.05;
    public static final int THRESHOLD_COUNT = 100;
    public static final double THRESHOLD_P = 0.95;
    public static final double THRESHOLD_BRANCH_U12_PERCENTILE = 0.95;
    public static final double THRESHOLD_U12_OBSERVED_EXPECTED = 5.0;
    public static int HTML_WIDTH = 20;
    public static int HTML_HEIGHT = 100;
    boolean saveDb;
    String outputDir = ".";
    String genomeFasta;
    StringBuilder out = new StringBuilder();
    SpliceTypes spliceTypes;
    ArrayList<String> geneList = new ArrayList();
    HashMap<String, PwmSet> pwmSetsByName = new HashMap();
    HashMap<String, PwmSet> pwmSetsExonTypeByName = new HashMap();
    HashMap<String, Intron> intronsByStr = new HashMap();
    TranscriptSet transcriptSet;
    double thresholdPDonor;
    double thresholdEntropyDonor;
    double thresholdPAcc;
    double thresholdEntropyAcc;
    double thresholdU12Score;
    int countIntrons = 0;
    Random random = new Random();

    int countDonorAcc(String donor, String acceptor) {
        int count = 0;
        for (int i2 = 0; i2 < this.spliceTypes.getDonorAccPairSize(); ++i2) {
            String d = this.spliceTypes.getDonor(i2);
            String a = this.spliceTypes.getAcceptor(i2);
            if (!d.startsWith(donor) || !a.endsWith(acceptor)) continue;
            ++count;
        }
        return count;
    }

    double findEntropyThreshold(AcgtTree tree) {
        List<Double> values = tree.entropyAll(100);
        Collections.sort(values);
        int index = (int)((double)values.size() * 0.05);
        return values.get(index);
    }

    double findPthreshold(AcgtTree tree) {
        List<Double> values = tree.pAll(100);
        Collections.sort(values);
        int index = (int)((double)values.size() * 0.95);
        return values.get(index);
    }

    PwmSet getPwmSet(String key) {
        PwmSet ps = this.pwmSetsByName.get(key);
        if (ps == null) {
            ps = new PwmSet(key);
            this.pwmSetsByName.put(key, ps);
        }
        return ps;
    }

    PwmSet getPwmSetExonType(String key) {
        PwmSet ps = this.pwmSetsExonTypeByName.get(key);
        if (ps == null) {
            ps = new PwmSet(key);
            this.pwmSetsExonTypeByName.put(key, ps);
        }
        return ps;
    }

    void out(Object o) {
        String s = o.toString();
        this.out.append(s + "\n");
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int idx = 0; idx < args.length; ++idx) {
            String arg = args[idx];
            if (this.isOpt(arg)) {
                if (arg.equals("-s")) {
                    this.saveDb = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer != null && !this.genomeVer.isEmpty()) continue;
            this.genomeVer = arg;
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing argument: Genome version");
        }
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.genomeFasta = this.config.getFileNameGenomeFasta();
        if (this.genomeFasta == null) {
            throw new RuntimeException("Cannot find reference genome: " + String.valueOf(this.config.getFileListGenomeFasta()));
        }
        this.outputDir = this.config.getDirData() + "/spliceSites";
        this.loadDb();
        this.transcriptSet = new TranscriptSet(this.config.getGenome());
        this.transcriptSet.setVerbose(this.verbose);
        this.transcriptSet.setDebug(this.debug);
        this.transcriptSet.filter();
        this.spliceTypes = new SpliceTypes(this.config);
        this.spliceTypes.setVerbose(this.verbose);
        this.spliceTypes.setDebug(this.debug);
        this.spliceTypes.setTranscriptSet(this.transcriptSet);
        this.spliceTypes.setGenomeFasta(this.genomeFasta);
        this.spliceTypes.analyzeAndCreate();
        this.thresholdU12Score = this.spliceTypes.branchU12Threshold(0.95);
        this.spliceTypes.createSpliceFasta(this.outputDir);
        this.splicePwmAnalysis();
        String outputFile = this.outputDir + "/" + this.getClass().getSimpleName() + "_" + this.genomeVer + ".html";
        if (this.verbose) {
            Log.info("Saving output to: " + outputFile);
        }
        Gpr.toFile(outputFile, this.out);
        if (this.saveDb) {
            if (this.verbose) {
                Log.info("Saving database to file: " + this.config.getFileSnpEffectPredictor());
            }
            this.config.getSnpEffectPredictor().save(this.config);
            if (this.verbose) {
                Log.info("Done.");
            }
        } else if (this.verbose) {
            Log.info("Not saving database.");
        }
        if (this.verbose) {
            Log.info("Finished!");
        }
        return true;
    }

    void splicePwmAnalysis() {
        if (this.verbose) {
            Log.info("Splice analysis (PWM). Reading fasta file: " + this.genomeFasta);
        }
        FastaFileIterator ffi = new FastaFileIterator(this.genomeFasta);
        this.out("<pre>\n");
        for (String chrSeq : ffi) {
            this.splicePwmAnalysis(ffi.getName(), chrSeq);
        }
        this.out("</pre>\n");
        String bedFile = this.outputDir + "/" + this.getClass().getSimpleName() + "_" + this.genomeVer + "_introns_branchSitesU12.bed";
        if (this.verbose) {
            Log.info("Writing Introns and SpliceSitesBranchU12 file to BED file: '" + bedFile + "'");
        }
        Markers markersBed = new Markers();
        int countBranch = 0;
        for (String string : this.pwmSetsByName.keySet()) {
            PwmSet pwmSet = this.getPwmSet(string);
            if (pwmSet.updates < 100 || !(pwmSet.countU12ObsExp() > 5.0)) continue;
            List<SpliceSiteBranchU12> ssbu12sites = this.spliceTypes.getBranchU12(string);
            for (SpliceSiteBranchU12 bu12 : ssbu12sites) {
                Transcript tr = (Transcript)bu12.getParent();
                tr.add(bu12);
                markersBed.add(bu12);
                ++countBranch;
                if (!this.verbose) continue;
                Log.info("\tAdding BranchU12 '" + String.valueOf(bu12) + "' to transcript " + tr.getId() + "\tDonor-acceptor pair: " + string + "\tObs/Expected: " + this.getPwmSet(string).countU12ObsExp());
            }
        }
        markersBed.addAll((Collection<? extends Marker>)this.intronsByStr.values());
        markersBed.sort(false, false);
        StringBuilder sb = new StringBuilder();
        for (Marker i2 : markersBed) {
            sb.append(i2.getChromosomeName() + "\t" + (i2.getStart() + 1) + "\t" + (i2.getEnd() + 1) + "\t" + (i2 instanceof SpliceSiteBranch ? i2.getType().toString() : i2.getId()) + "\n");
        }
        Gpr.toFile(bedFile, sb);
        if (this.verbose) {
            Log.info("Added " + countBranch + " branch U12 to genome.");
        }
        if (this.verbose) {
            Log.info("Filter out low count splice sites. Exons: " + this.countIntrons + "\tThreshold: 100");
        }
        ArrayList<PwmSet> arrayList = new ArrayList<PwmSet>();
        arrayList.addAll(this.pwmSetsByName.values());
        Collections.sort(arrayList);
        this.out("<p><center><h3>Analysis by Donnor-Acceptor type</h3></center><p><table border=1>\n");
        this.out("<p><b>U12 PWM score threshold:</b> " + this.thresholdU12Score + "<p>\n");
        this.out("<tr> <th> Rank </th> <th> Donor-Acceptor </th>  <th> Count </th>  <th> Donor Motif </th> <th> U12 matches (Observed / Expected) </th> <th> Acceptor Motif </th> <th> Intron length </th> <th> Intron Type Count </th> <th> Intron Type p-values </th><th> Genes </th> </tr>\n");
        int count = 0;
        for (PwmSet pwmset : arrayList) {
            if (pwmset.updates < 100) continue;
            this.out("<tr> <td> " + count++ + " </td> " + String.valueOf(pwmset) + "</tr>\n");
        }
        this.out("</table>\n");
        ArrayList<PwmSet> arrayList2 = new ArrayList<PwmSet>();
        arrayList2.addAll(this.pwmSetsExonTypeByName.values());
        Collections.sort(arrayList2);
        this.out("<p><hr><p><center><h3>Analysis by Exon-Exon types</h3></center><p><table border=1>\n");
        this.out("<tr> <th> Rank </th> <th> Exon_Type --- Exon_Type</th>  <th> Count </th>  <th> Donor Motif </th> <th> U12 matches (Observed / Expected) </th> <th> Acceptor Motif </th> <th> Intron length </th> <th> Intron Type Count </th> <th> Intron Type p-values </th><th> Genes </th> </tr>\n");
        count = 0;
        for (PwmSet pwmset : arrayList2) {
            if (pwmset.updates < 100) continue;
            this.out("<tr> <td> " + count++ + " </td> " + String.valueOf(pwmset) + "</tr>\n");
        }
        this.out("</table>\n");
    }

    void splicePwmAnalysis(String chrName, String chrSeq) {
        int countEx = 0;
        int countTr = 0;
        HashSet<CallSite> done = new HashSet<CallSite>();
        for (Transcript tr : this.transcriptSet.getByChromo(chrName)) {
            Exon exPrev = null;
            for (Exon ex : tr.sortedStrand()) {
                ++countEx;
                if (exPrev != null) {
                    int end;
                    int start;
                    if (tr.isStrandPlus()) {
                        start = exPrev.getEnd();
                        end = ex.getStart();
                    } else {
                        start = ex.getEnd();
                        end = exPrev.getStart();
                    }
                    String exPrevType = exPrev != null ? exPrev.getSpliceType().toString() : "";
                    String exType = ex != null ? ex.getSpliceType().toString() : "";
                    String intronTypes = exPrevType + "-" + exType;
                    String key = chrName + ":" + start + "-" + end;
                    if (!done.contains(key)) {
                        this.updatePwm(tr, chrSeq, start, end, intronTypes);
                        done.add((CallSite)((Object)key));
                        Intron intron = new Intron(tr, start, end, false, intronTypes, exPrev, ex);
                        this.intronsByStr.put(intron.toString(), intron);
                    }
                }
                exPrev = ex;
            }
            ++countTr;
        }
        if (this.verbose) {
            Log.info("\tChromosome: " + chrName + "\tTranscripts: " + countTr + "\tExons: " + countEx);
        }
    }

    void updatePwm(Transcript tr, String chrSeq, int intronStart, int intronEnd, String intronTypes) {
        int len = intronEnd - intronStart;
        if (len < 2 * SpliceTypes.MAX_SPLICE_SIZE) {
            return;
        }
        String donorStr = this.spliceTypes.seqDonor(tr, chrSeq, intronStart, intronEnd);
        String accStr = this.spliceTypes.seqAcceptor(tr, chrSeq, intronStart, intronEnd);
        String intronSeqDonor = donorStr.substring(SpliceTypes.MAX_SPLICE_SIZE + 1);
        String intronSeqAcc = accStr.substring(0, SpliceTypes.MAX_SPLICE_SIZE);
        ++this.countIntrons;
        String donorConsensus = donorStr.substring(SpliceTypes.MAX_SPLICE_SIZE + 1, SpliceTypes.MAX_SPLICE_SIZE + 1 + SIZE_CONSENSUS_DONOR);
        if (donorConsensus.indexOf(78) >= 0) {
            return;
        }
        String accConsensus = accStr.substring(SpliceTypes.MAX_SPLICE_SIZE - SIZE_CONSENSUS_ACCEPTOR, SpliceTypes.MAX_SPLICE_SIZE);
        if (donorConsensus.indexOf(78) >= 0) {
            return;
        }
        int maxLenDa = 0;
        for (int i2 = 0; i2 < this.spliceTypes.getDonorAccPairSize(); ++i2) {
            int lenda;
            String don = this.spliceTypes.getDonor(i2);
            String ac = this.spliceTypes.getAcceptor(i2);
            if (!intronSeqDonor.startsWith(don) || !intronSeqAcc.endsWith(ac) || (lenda = don.length() + ac.length()) <= maxLenDa) continue;
            maxLenDa = lenda;
            donorConsensus = don;
            accConsensus = ac;
        }
        String consensus = donorConsensus + "_" + accConsensus;
        Tuple<Double, Integer> bestU12 = this.spliceTypes.addBestU12Score(tr, chrSeq, consensus, intronStart, intronEnd);
        double bestU12score = (Double)bestU12.first;
        PwmSet pwmSet = this.getPwmSet(consensus);
        pwmSet.update(accStr, donorStr);
        pwmSet.len(len);
        pwmSet.incExonTypes(intronTypes);
        pwmSet.addGene((Gene)tr.getParent());
        if (bestU12score >= this.thresholdU12Score) {
            pwmSet.incU12();
        }
        pwmSet = this.getPwmSet(" ALL");
        pwmSet.update(accStr, donorStr);
        pwmSet.incExonTypes(intronTypes);
        pwmSet.len(len);
        pwmSet = this.getPwmSetExonType(intronTypes);
        pwmSet.update(accStr, donorStr);
        pwmSet.len(len);
        pwmSet.addGene((Gene)tr.getParent());
        if (bestU12score >= this.thresholdU12Score) {
            pwmSet.incU12();
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: snpEff  spliceAnalysis [options] genome_version");
        System.err.println("Options:");
        System.err.println("    -s      : Save database");
        System.exit(-1);
    }

    class PwmSet
    implements Comparable<PwmSet> {
        int motifMatchedBases = 0;
        int motifMatchedStr = 0;
        int updates = 0;
        int countU12 = 0;
        String name;
        Pwm pwmAcc;
        Pwm pwmDonor;
        CountByType countMotif;
        CountByType countExonTypes;
        IntStats lenStats;
        HashSet<Gene> genes;

        public PwmSet(String name) {
            this.name = name;
            this.pwmAcc = new Pwm(2 * SpliceTypes.MAX_SPLICE_SIZE + 1);
            this.pwmDonor = new Pwm(2 * SpliceTypes.MAX_SPLICE_SIZE + 1);
            this.lenStats = new IntStats();
            this.countMotif = new CountByType();
            this.countExonTypes = new CountByType();
            this.genes = new HashSet();
        }

        public void addGene(Gene gene) {
            this.genes.add(gene);
        }

        @Override
        public int compareTo(PwmSet ps) {
            int diff = ps.updates - this.updates;
            if (diff != 0) {
                return diff;
            }
            return this.name.compareTo(ps.name);
        }

        public double countU12ObsExp() {
            double expected = (double)this.updates * 0.050000000000000044;
            double oe = (double)this.countU12 / expected;
            return oe;
        }

        String geneNames() {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> names = new ArrayList<String>();
            for (Gene g : this.genes) {
                names.add(g.getGeneName());
            }
            Collections.sort(names);
            int count = 1;
            for (String gn : names) {
                sb.append(gn + " ");
                if (count % 30 == 0) {
                    sb.append("\n");
                }
                ++count;
            }
            return sb.toString();
        }

        void incExonTypes(String exonTypes) {
            this.countExonTypes.inc(exonTypes);
        }

        void incU12() {
            ++this.countU12;
        }

        void len(int len) {
            this.lenStats.sample(len);
        }

        String pExonTypes() {
            StringBuilder out = new StringBuilder();
            for (String type : this.countExonTypes.keysSorted()) {
                out.append(this.pExonTypes(type));
            }
            return out.toString();
        }

        String pExonTypes(String category) {
            double pUp;
            int countBlackDrawn = 0;
            for (String type : this.countExonTypes.keysSorted()) {
                if (type.equals(category)) continue;
                countBlackDrawn = (int)((long)countBlackDrawn + this.countExonTypes.get(type));
            }
            int countWhiteDrawn = (int)this.countExonTypes.get(category);
            PwmSet pwmSet = SnpEffCmdSpliceAnalysis.this.getPwmSet(" ALL");
            CountByType countExonTypesAll = pwmSet.countExonTypes;
            int countBlack = 0;
            for (String type : countExonTypesAll.keysSorted()) {
                if (type.equals(category)) continue;
                countBlack = (int)((long)countBlack + countExonTypesAll.get(type));
            }
            int countWhite = (int)countExonTypesAll.get(category);
            Object out = "";
            double pDown = FisherExactTest.get().fisherExactTestDown(countWhiteDrawn, countBlack + countWhite, countWhite, countBlackDrawn + countWhiteDrawn);
            if (pDown > 0.0 && pDown < P_VALUE_THRESHOLD) {
                out = (String)out + String.format("p-value Down (%s) : %.4e\n", category, pDown);
            }
            if ((pUp = FisherExactTest.get().fisherExactTestUp(countWhiteDrawn, countBlack + countWhite, countWhite, countBlackDrawn + countWhiteDrawn)) > 0.0 && pUp < P_VALUE_THRESHOLD) {
                out = (String)out + String.format("p-value Down (%s) : %.4e\n", category, pUp);
            }
            return out;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("\t<td> <b>" + this.name + "</b> </td>\n");
            out.append("\t<td> " + this.updates + "</td>\n");
            MotifLogo mlDonor = new MotifLogo(this.pwmDonor);
            out.append("\t<td>\n");
            out.append(mlDonor.toStringHtml(HTML_WIDTH, HTML_HEIGHT, EffectType.SPLICE_SITE_DONOR));
            out.append("\t</td>\n");
            double oe = this.countU12ObsExp();
            String bg = "ffffff";
            if (oe > 5.0) {
                bg = "ff0000";
            } else if (oe > 2.0) {
                bg = "ff8888";
            } else if (oe > 1.2) {
                bg = "ffcccc";
            }
            out.append(String.format("\t<td bgcolor=%s> <center> %d (%1.2f) </center> </td>\n", bg, this.countU12, oe));
            MotifLogo mlAcc = new MotifLogo(this.pwmAcc);
            out.append("\t<td>\n");
            out.append(mlAcc.toStringHtml(HTML_WIDTH, HTML_HEIGHT, EffectType.SPLICE_SITE_ACCEPTOR));
            out.append("\t</td>\n");
            out.append("\t<td> <pre>\n");
            out.append(this.lenStats.toString());
            out.append("\t</pre></td>\n");
            out.append("\t<td> <pre>\n");
            out.append(this.countExonTypes);
            out.append("\t</pre></td>\n");
            out.append("\t<td> <pre>\n");
            out.append(this.pExonTypes());
            out.append("\t</pre></td>\n");
            out.append("\t<td> <textarea rows=10 cols=120 readonly> \n");
            out.append(this.geneNames());
            out.append("\t</textarea> </td>\n");
            return out.toString();
        }

        public void update(String accStr, String donorStr) {
            ++this.updates;
            if (accStr != null) {
                this.pwmAcc.updateCounts(accStr);
            }
            if (donorStr != null) {
                this.pwmDonor.updateCounts(donorStr);
            }
        }
    }
}

