/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.io.BufferedReader;
import java.util.List;
import org.snpeff.collections.MultivalueHashMap;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class SnpEffPredictorFactoryRefSeq
extends SnpEffPredictorFactory {
    public static final String CDS_STAT_COMPLETE = "cmpl";
    MultivalueHashMap<String, Gene> genesByName = new MultivalueHashMap();

    public SnpEffPredictorFactoryRefSeq(Config config) {
        super(config, 0);
        this.frameType = FrameType.UCSC;
        this.frameCorrection = true;
    }

    BioType bioType(String id) {
        String key;
        if (id.length() < 2) {
            return null;
        }
        switch (key = id.substring(0, 2)) {
            case "NM": 
            case "NP": 
            case "XM": 
            case "XP": 
            case "YP": 
            case "ZP": {
                return BioType.protein_coding;
            }
            case "AC": 
            case "AP": 
            case "NC": 
            case "NG": 
            case "NR": 
            case "NT": 
            case "NW": 
            case "NZ": 
            case "XR": 
            case "NS": {
                return BioType.pseudogene;
            }
        }
        return null;
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            if (this.fileName == null) {
                this.fileName = this.config.getBaseFileNameGenes() + ".refseq";
            }
            if (this.verbose) {
                System.out.print("Reading gene intervals file : '" + this.fileName + "'\n\t\t");
            }
            this.readRefSeqFile();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            this.finishUp();
            if (this.verbose) {
                Log.info(this.config.getGenome());
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + String.valueOf(e));
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(String geneName, String trId, Chromosome chromo, int start, int end, boolean strandMinus) {
        Gene gene2;
        Marker tr = new Marker(chromo, start, end, strandMinus, trId);
        List genes = (List)this.genesByName.get(geneName);
        int geneIndex = 0;
        if (genes != null) {
            for (Gene gene2 : genes) {
                if (!gene2.intersects(tr)) continue;
                if (start < gene2.getStart()) {
                    gene2.setStart(start);
                }
                if (gene2.getEnd() < end) {
                    gene2.setEnd(end);
                }
                return gene2;
            }
            geneIndex = genes.size() + 1;
        }
        String geneId = geneName + (String)(geneIndex > 0 ? "." + geneIndex : "");
        gene2 = new Gene(chromo, start, end, strandMinus, geneId, geneName, this.bioType(trId));
        this.genesByName.add(geneName, gene2);
        this.add(gene2);
        return gene2;
    }

    boolean isProteinCoding(String id) {
        BioType biotype = this.bioType(id);
        return biotype != null && biotype.isProteinCoding();
    }

    protected void readRefSeqFile() {
        try {
            int count = 0;
            BufferedReader reader = Gpr.reader(this.fileName);
            if (reader == null) {
                return;
            }
            this.lineNum = 1;
            while (reader.ready()) {
                String[] fields;
                this.line = reader.readLine();
                if (this.lineNum != 1 && !this.line.startsWith("#") && (fields = this.line.split("\t")).length >= 16) {
                    String id = fields[1];
                    String chromoName = fields[2];
                    boolean strandMinus = fields[3].equals("-");
                    int txstart = this.parsePosition(fields[4]);
                    int txend = this.parsePosition(fields[5]) - 1;
                    int cdsStart = this.parsePosition(fields[6]);
                    int cdsEnd = this.parsePosition(fields[7]) - 1;
                    int exonCount = Gpr.parseIntSafe(fields[8]);
                    String exonStarts = fields[9];
                    String exonEnds = fields[10];
                    String geneName = fields[12];
                    String cdsStartStat = fields[13];
                    String cdsEndStat = fields[14];
                    String exonFrames = fields[15];
                    Chromosome chromo = this.getOrCreateChromosome(chromoName);
                    String trId = this.uniqueTrId(id);
                    Gene gene = this.findOrCreateGene(geneName, trId, chromo, txstart, txend, strandMinus);
                    Transcript tr = new Transcript(gene, txstart, txend, strandMinus, trId);
                    boolean markAsCoding = this.isProteinCoding(trId) && cdsStartStat.equals(CDS_STAT_COMPLETE) && cdsEndStat.equals(CDS_STAT_COMPLETE);
                    tr.setProteinCoding(markAsCoding);
                    this.add(tr);
                    String[] exStartStr = exonStarts.split(",");
                    String[] exEndStr = exonEnds.split(",");
                    String[] exFrameStr = exonFrames.split(",");
                    for (int i2 = 0; i2 < exonCount; ++i2) {
                        int exStart = this.parsePosition(exStartStr[i2]);
                        int exEnd = this.parsePosition(exEndStr[i2]) - 1;
                        int exFrame = Gpr.parseIntSafe(exFrameStr[i2]);
                        String exId = trId + ".ex." + (i2 + 1);
                        Exon ex = new Exon(tr, exStart, exEnd, strandMinus, exId, i2);
                        exFrame = this.frameType.convertFrame(exFrame);
                        ex.setFrame(exFrame);
                        ex = this.add(ex);
                        if (exStart > cdsEnd || exEnd < cdsStart) continue;
                        Cds cds = new Cds(tr, Math.max(cdsStart, exStart), Math.min(cdsEnd, exEnd), strandMinus, exId);
                        this.add(cds);
                    }
                    ++count;
                    if (this.verbose) {
                        Gpr.showMark(count, 100, "\t\t");
                    }
                }
                ++this.lineNum;
            }
            reader.close();
        }
        catch (Exception e) {
            Log.debug("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
            throw new RuntimeException(e);
        }
    }

    String uniqueTrId(String id) {
        if (!this.transcriptsById.containsKey(id)) {
            return id;
        }
        int i2 = 2;
        String trId;
        while (this.transcriptsById.containsKey(trId = id + "." + i2)) {
            ++i2;
        }
        return trId;
    }
}

