/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Interval;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff;
import org.snpeff.util.GprSeq;

public class SnpEffPredictorFactoryRand
extends SnpEffPredictorFactoryGff {
    boolean addUtrs;
    Random random;
    int maxTranscripts;
    int maxExons;
    int minExons = 1;
    int numGenes = 1;
    int maxGeneLen;
    int minGeneSize = 100;
    String chromoSequence = "";
    Chromosome chromo;
    boolean forcePositiveStrand = false;
    boolean forceNegativeStrand = false;

    public SnpEffPredictorFactoryRand(Config config, Random random, int maxGeneLen, int maxTranscripts, int maxExons) {
        super(config);
        this.random = random;
        this.maxGeneLen = maxGeneLen;
        this.maxTranscripts = maxTranscripts;
        this.maxExons = maxExons;
        this.frameCorrection = false;
    }

    @Override
    public SnpEffectPredictor create() {
        this.chromo = new Chromosome(this.genome, 0, this.numGenes * 2 * this.maxGeneLen, "chr1");
        this.genome.add(this.chromo);
        this.chromoSequence = GprSeq.randSequence(this.random, this.chromo.size());
        int trNum = 0;
        for (int geneNum = 1; geneNum <= this.numGenes; ++geneNum) {
            boolean strandMinus;
            int start = 2 * (geneNum - 1) * this.maxGeneLen + this.random.nextInt(geneNum * this.maxGeneLen);
            int end = start + Math.max(this.minGeneSize, this.random.nextInt(this.maxGeneLen));
            boolean bl = strandMinus = !this.random.nextBoolean();
            if (this.forcePositiveStrand && this.forceNegativeStrand) {
                throw new RuntimeException("Cannot force both positive and negative strands!");
            }
            if (this.forcePositiveStrand) {
                strandMinus = false;
            }
            if (this.forceNegativeStrand) {
                strandMinus = true;
            }
            String geneId = "geneId" + geneNum;
            String geneName = "geneName" + geneNum;
            Gene gene = new Gene(this.chromo, start, end, strandMinus, geneId, geneName, BioType.protein_coding);
            this.add(gene);
            int numTr = Math.max(this.random.nextInt(this.maxTranscripts), 1);
            int nt = 0;
            while (nt < numTr) {
                this.createTranscript(gene, "" + trNum);
                ++nt;
                ++trNum;
            }
        }
        return this.snpEffectPredictor;
    }

    Transcript createTranscript(Gene gene, String trId) {
        int start = gene.getStart();
        int end = gene.getEnd();
        Transcript tr = new Transcript(gene, gene.getStart(), gene.getEnd(), gene.isStrandMinus(), "transcript_" + trId);
        tr.setProteinCoding(true);
        this.add(tr);
        int numEx = Math.max(this.random.nextInt(this.maxExons), this.minExons);
        for (int ne = 0; ne < numEx; ++ne) {
            int size = tr.size() / numEx;
            start = tr.getStart() + size * ne + this.random.nextInt(size / 2);
            end = start + this.random.nextInt(size / 2);
            Exon exon = new Exon(tr, start, end, gene.isStrandMinus(), "exon_" + trId + "_" + ne, ne + 1);
            String seq = this.chromoSequence.substring(start, end + 1);
            if (exon.isStrandMinus()) {
                seq = GprSeq.reverseWc(seq);
            }
            exon.setSequence(seq);
            this.add(exon);
        }
        if (this.addUtrs) {
            this.createUtrs(tr);
        }
        tr.adjust();
        tr.rankExons();
        return tr;
    }

    void createUtrs(Transcript tr) {
        int utr3size;
        int size = 0;
        for (Object ex : tr) {
            size += ((Interval)ex).size();
        }
        if (size < 4) {
            return;
        }
        int utr5size = this.random.nextInt(size / 4);
        size -= utr5size;
        if (utr5size > 0) {
            for (Exon ex : tr.sortedStrand()) {
                Utr5prime utr5;
                if (utr5size < 0) continue;
                if (ex.size() >= utr5size) {
                    utr5 = tr.isStrandPlus() ? new Utr5prime(ex, ex.getStart(), ex.getStart() + (utr5size - 1), ex.isStrandMinus(), ex.getId()) : new Utr5prime(ex, ex.getEnd() - (utr5size - 1), ex.getEnd(), ex.isStrandMinus(), ex.getId());
                    tr.add(utr5);
                    utr5size = -1;
                    continue;
                }
                utr5 = new Utr5prime(ex, ex.getStart(), ex.getEnd(), ex.isStrandMinus(), ex.getId());
                tr.add(utr5);
                utr5size -= ex.size();
            }
        }
        if ((utr3size = this.random.nextInt(size / 4)) > 0) {
            ArrayList exons = new ArrayList();
            exons.addAll(tr.subIntervals());
            Collections.sort(exons, new IntervalComparatorByEnd(tr.isStrandPlus()));
            for (Exon ex : exons) {
                Utr3prime utr3;
                if (utr3size < 0) continue;
                if (ex.size() >= utr3size) {
                    utr3 = tr.isStrandMinus() ? new Utr3prime(ex, ex.getStart(), ex.getStart() + (utr3size - 1), ex.isStrandMinus(), ex.getId()) : new Utr3prime(ex, ex.getEnd() - (utr3size - 1), ex.getEnd(), ex.isStrandMinus(), ex.getId());
                    tr.add(utr3);
                    utr3size = -1;
                    continue;
                }
                utr3 = new Utr3prime(ex, ex.getStart(), ex.getEnd(), ex.isStrandMinus(), ex.getId());
                tr.add(utr3);
                utr3size -= ex.size();
            }
        }
    }

    public Chromosome getChromo() {
        return this.chromo;
    }

    public String getChromoSequence() {
        return this.chromoSequence;
    }

    @Override
    protected boolean parse(String line) {
        return false;
    }

    public void setAddUtrs(boolean addUtrs) {
        this.addUtrs = addUtrs;
    }

    public void setChromo(Chromosome chromo) {
        this.chromo = chromo;
    }

    public void setForceNegativeStrand(boolean forceNegativeStrand) {
        this.forceNegativeStrand = forceNegativeStrand;
    }

    public void setForcePositiveStrand(boolean forcePositive) {
        this.forcePositiveStrand = forcePositive;
    }

    public void setMinExons(int minExons) {
        this.minExons = minExons;
    }

    public void setNumGenes(int numGenes) {
        this.numGenes = numGenes;
    }
}

