/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.GffMarker;
import org.snpeff.interval.GffType;
import org.snpeff.interval.IntergenicConserved;
import org.snpeff.interval.IntronConserved;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public abstract class SnpEffPredictorFactoryGff
extends SnpEffPredictorFactory {
    public static final String FASTA_DELIMITER = "##FASTA";
    String version = "";
    boolean mainFileHasFasta = false;

    public SnpEffPredictorFactoryGff(Config config) {
        super(config, 1);
        this.markersById = new HashMap();
        this.genesById = new HashMap();
        this.transcriptsById = new HashMap();
        this.fileName = config.getBaseFileNameGenes() + ".gff";
        this.frameCorrection = true;
        this.frameType = FrameType.GFF;
    }

    protected Exon addExon(Transcript tr, GffMarker gffMarker, String exonId) {
        int rank = 0;
        Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), exonId, rank);
        ex.setFrame(gffMarker.getFrame());
        return this.add(ex);
    }

    protected List<Exon> addExons(GffMarker gffMarker) {
        String id = gffMarker.getId();
        LinkedList<Exon> list = new LinkedList<Exon>();
        String[] parentIds = gffMarker.getGffParentIds();
        if (parentIds == null) {
            if (this.debug) {
                this.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Cannot find parent ID for exon:\n\t" + String.valueOf(gffMarker));
            }
            return null;
        }
        block5: for (String parentId : parentIds) {
            Object trId;
            parentId = parentId.trim();
            Transcript tr = this.findTranscript(parentId, id);
            Gene gene = this.findGene(parentId);
            if (tr == null && gene != null && (tr = this.findTranscript((String)(trId = String.valueOf((Object)GffType.TRANSCRIPT) + "_" + gene.getId()))) == null) {
                tr = this.addTranscript(gene, gffMarker, (String)trId);
                this.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Exon's parent '" + parentId + "' is a Gene instead of a transcript. Created transcript '" + tr.getId() + "' for " + String.valueOf(gffMarker));
            }
            if (gene == null) {
                gene = this.findGene(gffMarker.getGeneId());
            }
            if (tr == null) {
                if (gene == null) {
                    gene = this.addGene(gffMarker);
                }
                trId = parentId.isEmpty() ? String.valueOf((Object)GffType.TRANSCRIPT) + "_" + id : parentId;
                tr = this.addTranscript(gene, gffMarker, (String)trId);
                this.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Cannot find transcript '" + parentId + "'. Created transcript '" + tr.getId() + "' and gene '" + gene.getId() + "' for " + String.valueOf(gffMarker));
            }
            int rank = 0;
            switch (gffMarker.getGffType()) {
                case EXON: {
                    Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id, rank);
                    ex.setFrame(gffMarker.getFrame());
                    ex = this.add(ex);
                    list.add(ex);
                    continue block5;
                }
                case CDS: {
                    Cds cds = new Cds(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id);
                    cds.setFrame(gffMarker.getFrame());
                    String protein_id = gffMarker.getProteinId();
                    if (protein_id != null) {
                        tr.setProteinId(protein_id);
                    }
                    this.add(cds);
                    continue block5;
                }
                case START_CODON: 
                case STOP_CODON: {
                    Exon ex = new Exon(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), id, rank);
                    ex.setFrame(gffMarker.getFrame());
                    this.add(ex);
                    Cds cds = new Cds(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), String.valueOf((Object)gffMarker.getGffType()) + "_" + id);
                    cds.setFrame(gffMarker.getFrame());
                    this.add(cds);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unsupported type " + String.valueOf((Object)gffMarker.getGffType()));
                }
            }
        }
        return list.isEmpty() ? null : list;
    }

    protected Gene addGene(GffMarker gffMarker) {
        return this.addGene(gffMarker, false);
    }

    protected Gene addGene(GffMarker gffMarker, boolean findNextGeneId) {
        BioType bioType = gffMarker.getGeneBiotype();
        String geneIdOri = gffMarker.getGeneId();
        Object geneId = geneIdOri;
        int count = 2;
        while (findNextGeneId && this.genesById.containsKey(geneId)) {
            geneId = geneIdOri + "." + count;
            ++count;
        }
        Gene gene = new Gene(gffMarker.getChromosome(), gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), (String)geneId, gffMarker.getGeneName(), bioType);
        this.add(gene);
        return gene;
    }

    protected IntergenicConserved addIntergenicConserved(GffMarker gffMarker) {
        IntergenicConserved intergenicConserved = new IntergenicConserved(gffMarker.getChromosome(), gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        this.add(intergenicConserved);
        return intergenicConserved;
    }

    protected boolean addInterval(GffMarker gffMarker) {
        switch (gffMarker.getGffType()) {
            case GENE: {
                String geneId = gffMarker.getGeneId();
                if (geneId != null && this.findGene(geneId) != null) {
                    this.warning(ErrorWarningType.WARNING_GENE_ID_DUPLICATE, "Gene '" + geneId + "' already added");
                    return false;
                }
                return this.findOrCreateGene(gffMarker) != null;
            }
            case TRANSCRIPT: {
                String trId = gffMarker.getTranscriptId();
                if (trId != null && this.findTranscript(trId) != null) {
                    this.warning(ErrorWarningType.WARNING_TRANSCRIPT_ID_DUPLICATE, "Transcript '" + trId + "' already added");
                    return false;
                }
                return this.findOrCreateTranscript(gffMarker) != null;
            }
            case CDS: {
                return this.addExons(gffMarker) != null;
            }
            case EXON: 
            case START_CODON: 
            case STOP_CODON: {
                return this.addExons(gffMarker) != null;
            }
            case UTR5: {
                return this.addUtr5(gffMarker) != null;
            }
            case UTR3: {
                return this.addUtr3(gffMarker) != null;
            }
            case INTRON_CONSERVED: {
                return this.addIntronConserved(gffMarker) != null;
            }
            case INTERGENIC_CONSERVED: {
                return this.addIntergenicConserved(gffMarker) != null;
            }
        }
        return false;
    }

    protected IntronConserved addIntronConserved(GffMarker gffMarker) {
        String trId = gffMarker.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getId());
        }
        if (tr == null) {
            this.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Could not find transcript '" + trId + "'");
            return null;
        }
        IntronConserved intronConserved = new IntronConserved(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        this.add(intronConserved);
        return intronConserved;
    }

    Transcript addTranscript(Gene gene, GffMarker gffMarker, String trId) {
        String protein_id;
        String tags;
        String ver;
        Transcript tr = new Transcript(gene, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), trId);
        if (gffMarker.isProteingCoding()) {
            tr.setProteinCoding(true);
        }
        tr.setBioType(gffMarker.getTranscriptBiotype());
        String tslStr = gffMarker.getTranscriptTsl();
        if (tslStr != null) {
            tr.setTranscriptSupportLevel(TranscriptSupportLevel.parse(tslStr));
        }
        if ((ver = gffMarker.getTranscriptVersion()) != null) {
            tr.setVersion(ver);
        }
        BioType geneBioType = gffMarker.getGeneBiotype();
        if (gene.getBioType() == null && geneBioType != null) {
            gene.setBioType(geneBioType);
        }
        if ((tags = gffMarker.getTags()) != null) {
            tr.setTags(tags);
        }
        if ((protein_id = gffMarker.getProteinId()) != null) {
            tr.setProteinId(protein_id);
            if (!tr.isProteinCoding()) {
                Log.warning("Transcript is not marked as 'protein coding' but has a protein ID '" + protein_id + "'");
            }
        }
        this.add(tr);
        if (!gene.getChromosomeName().equals(tr.getChromosomeName())) {
            Log.fatalError("Trying to assign Transcript to a Gene in a different chromosome!\n\tTranscript : " + tr.toStr() + "\n\tGene       : " + gene.toStr());
        }
        return tr;
    }

    protected List<Utr3prime> addUtr3(GffMarker gffMarker) {
        LinkedList<Utr3prime> list = new LinkedList<Utr3prime>();
        for (String parentId : gffMarker.getGffParentIds()) {
            Exon exon = this.findOrCreateExon(parentId, gffMarker);
            if (exon != null) {
                Transcript tr = (Transcript)exon.getParent();
                Utr3prime u3 = new Utr3prime(exon, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
                tr.add(u3);
                this.add(u3);
                list.add(u3);
                continue;
            }
            this.warning(ErrorWarningType.WARNING_CANNOT_ADD_UTR, "Could not add UTR");
        }
        return list.isEmpty() ? null : list;
    }

    protected List<Utr5prime> addUtr5(GffMarker gffMarker) {
        LinkedList<Utr5prime> list = new LinkedList<Utr5prime>();
        for (String parentId : gffMarker.getGffParentIds()) {
            Exon exon = this.findOrCreateExon(parentId, gffMarker);
            if (exon != null) {
                Transcript tr = (Transcript)exon.getParent();
                Utr5prime u5 = new Utr5prime(exon, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
                tr.add(u5);
                this.add(u5);
                list.add(u5);
                continue;
            }
            this.warning(ErrorWarningType.WARNING_CANNOT_ADD_UTR, "Could not add UTR");
        }
        return list.isEmpty() ? null : list;
    }

    @Override
    public SnpEffectPredictor create() {
        if (this.verbose) {
            Log.info("Reading " + this.version + " data file  : '" + this.fileName + "'");
        }
        try {
            this.readGff();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            if (this.verbose) {
                Log.info("\tTotal: " + this.totalSeqsAdded + " sequences added, " + this.totalSeqsIgnored + " sequences ignored.");
            }
            this.finishUp();
            if (this.verbose) {
                Log.info(this.config.getGenome());
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + String.valueOf(e));
        }
        return this.snpEffectPredictor;
    }

    protected Exon findOrCreateExon(String parentId, GffMarker gffMarker) {
        Transcript tr = this.findTranscript(parentId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getTranscriptId());
        }
        if (tr == null) {
            this.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Cannot find transcript '" + parentId + "'");
            return null;
        }
        Marker utr = new Marker(tr, gffMarker.getStart(), gffMarker.getEnd(), gffMarker.isStrandMinus(), gffMarker.getId());
        Exon exon = tr.queryExon(utr);
        if (exon != null) {
            return exon;
        }
        exon = this.addExon(tr, gffMarker, gffMarker.getId());
        if (this.debug) {
            this.warning(ErrorWarningType.WARNING_EXON_NOT_FOUND, "Cannot find exon for UTR: '" + utr.getId() + "'. Creating exon '" + gffMarker.getId() + "'");
        }
        return exon;
    }

    protected Gene findOrCreateGene(GffMarker gffMarker) {
        Gene gene = this.findGene(gffMarker.getGeneId());
        if (gene == null) {
            gene = this.findGene(gffMarker.getId());
        }
        if (gene != null) {
            if (!gene.includes(gffMarker) && gene.intersects(gffMarker)) {
                int start = Math.min(gene.getStart(), gffMarker.getStart());
                int end = Math.max(gene.getEnd(), gffMarker.getEnd());
                this.warning(ErrorWarningType.WARNING_GENE_COORDINATES, "Gene '" + gene.getId() + "' (" + gene.toStrPos() + ") partially includes '" + gffMarker.getId() + "' (" + gffMarker.toStrPos() + "). Expanding gene coordinates to " + gene.toStrPos());
                gene.setStart(start);
                gene.setEnd(end);
            }
            if (!gene.includes(gffMarker)) {
                Gene geneOri = gene;
                gene = this.addGene(gffMarker, true);
                this.warning(ErrorWarningType.WARNING_GENE_NOT_FOUND, "Gene '" + geneOri.getId() + "' (" + geneOri.toStrPos() + ") does not include '" + gffMarker.getId() + "' (" + gffMarker.toStrPos() + "). Created new gene '" + gene.getId() + "' (" + gene.toStrPos() + ")");
            }
        }
        if (gene == null) {
            gene = this.addGene(gffMarker);
        }
        return gene;
    }

    protected Transcript findOrCreateTranscript(GffMarker gffMarker) {
        String trId = gffMarker.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr == null) {
            tr = this.findTranscript(gffMarker.getId());
        }
        if (tr == null) {
            Gene gene = this.findOrCreateGene(gffMarker);
            tr = this.addTranscript(gene, gffMarker, trId);
        }
        return tr;
    }

    protected boolean parse(String line) {
        GffMarker gffMarker = new GffMarker(this.genome, line);
        return this.addInterval(gffMarker);
    }

    @Override
    protected void readExonSequences() {
        if (this.verbose) {
            Log.info("\tReading sequences   :");
        }
        if (this.mainFileHasFasta) {
            this.readExonSequencesGff(this.fileName);
        } else {
            super.readExonSequences();
        }
    }

    protected void readExonSequencesGff(String gffFileName) {
        if (this.debug) {
            Log.info("Reading exon sequences from GFF file '" + gffFileName + "'");
        }
        try {
            BufferedReader reader = Gpr.reader(gffFileName);
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.equals(FASTA_DELIMITER)) {
                    this.mainFileHasFasta = true;
                    break;
                }
                ++this.lineNum;
            }
            String chromoName = null;
            StringBuffer chromoSb = new StringBuffer();
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line.startsWith(">")) {
                    int idxSpace;
                    if (chromoName != null) {
                        this.addSequences(chromoName, chromoSb.toString());
                    }
                    if ((idxSpace = this.line.indexOf(32)) > 0) {
                        this.line = this.line.substring(0, idxSpace);
                    }
                    chromoName = Chromosome.simpleName(this.line.substring(1).trim());
                    this.chromoNamesReference.add(chromoName);
                    chromoSb = new StringBuffer();
                    if (this.verbose) {
                        Log.info("\t\tReading sequence '" + chromoName + "'");
                    }
                } else {
                    chromoSb.append(this.line.trim());
                }
                ++this.lineNum;
            }
            if (chromoName != null) {
                this.addSequences(chromoName, chromoSb.toString());
            } else {
                this.warning(ErrorWarningType.WARNING_CHROMOSOME_NOT_FOUND, "Ignoring sequences for '" + chromoName + "'. Cannot find chromosome");
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readGff() throws Exception {
        if (this.verbose) {
            Log.info("Reading file '" + this.fileName + "'");
        }
        int count = 0;
        BufferedReader reader = Gpr.reader(this.fileName);
        if (reader == null) {
            return;
        }
        try {
            this.lineNum = 1;
            while (reader.ready()) {
                this.line = reader.readLine();
                if (this.line != null && !this.line.isEmpty()) {
                    if (this.line.equals(FASTA_DELIMITER)) {
                        this.mainFileHasFasta = true;
                        break;
                    }
                    if (!this.line.startsWith("#") && this.parse(this.line)) {
                        ++count;
                        if (this.verbose) {
                            Gpr.showMark(count, 100, "\t\t");
                        }
                    }
                }
                ++this.lineNum;
            }
        }
        catch (Exception e) {
            Log.fatalError(e, "Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
        }
        reader.close();
        if (this.verbose) {
            Log.info((count > 0 ? "\n" : "") + "\tTotal: " + count + " markers added.");
        }
    }
}

