/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.genBank.Feature;
import org.snpeff.genBank.FeatureCoordinates;
import org.snpeff.genBank.Features;
import org.snpeff.genBank.FeaturesFile;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CircularCorrection;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public abstract class SnpEffPredictorFactoryFeatures
extends SnpEffPredictorFactory {
    public static final int OFFSET = 1;
    Chromosome chromosome;
    FeaturesFile featuresFile;
    Map<String, String> proteinByTrId = new HashMap<String, String>();

    public SnpEffPredictorFactoryFeatures(Config config) {
        super(config, 1);
    }

    Transcript addCds(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        Transcript tr = this.findOrCreateTranscript(fcds, geneLatest, trLatest);
        if (fcds.getAasequence() != null) {
            tr.setProteinCoding(true);
        }
        if (fcds.isRibosomalSlippage()) {
            tr.setRibosomalSlippage(true);
        }
        this.createCdsInTranscript(tr, fcds);
        this.proteinSequenceMapping(tr, fcds);
        return tr;
    }

    protected void addFeatures(Features features) {
        for (Feature f : features.getFeatures()) {
            if (f.getType() != Feature.Type.SOURCE) continue;
            if (this.chromosome == null) {
                int start = f.getStart() - this.inOffset;
                int end = f.getEnd() - this.inOffset;
                String chrName = this.chromoName(features, f);
                this.chromosome = new Chromosome(this.genome, start, end, chrName);
                this.add(this.chromosome);
                continue;
            }
            if (!this.debug) continue;
            System.err.println("Warning: 'SOURCE' already assigned to chromosome. Ignoring feature:\n" + String.valueOf(f));
        }
        if (this.chromosome == null) {
            String chrName = this.chromoName(features, null);
            int chrSize = this.sequence(features).length();
            this.chromosome = new Chromosome(this.genome, 0, chrSize, chrName);
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            throw new RuntimeException("Could not find SOURCE feature");
        }
        if (this.verbose) {
            Log.info("Chromosome: '" + this.chromosome.getId() + "'\tlength: " + this.chromosome.size());
        }
        Gene geneLatest = null;
        ArrayList<Transcript> trLatestList = null;
        Transcript trLatest = null;
        for (Feature f : features.getFeatures()) {
            if (f.getType() == Feature.Type.GENE) {
                geneLatest = this.findOrCreateGene(f, this.chromosome, false);
                trLatestList = null;
                trLatest = null;
                continue;
            }
            if (f.getType() == Feature.Type.MRNA) {
                trLatest = this.addMrna(f, geneLatest);
            } else if (f.getType() == Feature.Type.CDS) {
                trLatest = this.addCds(f, geneLatest, trLatestList);
            } else if (f.getType() == Feature.Type.MAT_PEPTIDE) {
                this.addMaturePeptide(f, geneLatest, trLatest);
            }
            if (trLatest == null) continue;
            if (geneLatest == null || trLatestList == null || !trLatest.getParent().getId().equals(geneLatest.getId())) {
                trLatestList = new ArrayList<Transcript>();
                trLatestList.add(trLatest);
            } else {
                trLatestList.add(trLatest);
            }
            geneLatest = (Gene)trLatest.getParent();
        }
    }

    void addMaturePeptide(Feature fmatpep, Gene geneLatest, Transcript trLatest) {
        Gene gene;
        boolean ribosomalSlippage;
        boolean strandMinus;
        if (geneLatest == null) {
            throw new RuntimeException("No latest gene while traying to add a " + String.valueOf((Object)fmatpep.getType()) + ". This should not happen: Error in feature file?\nFeature: " + String.valueOf(fmatpep));
        }
        String trId = fmatpep.getMaturePeptideId();
        if (trLatest != null) {
            strandMinus = trLatest.isStrandMinus();
            ribosomalSlippage = trLatest.isRibosomalSlippage();
            gene = (Gene)trLatest.getParent();
        } else {
            strandMinus = fmatpep.isComplement();
            ribosomalSlippage = fmatpep.isRibosomalSlippage();
            gene = geneLatest;
        }
        Transcript tr = new Transcript(gene, fmatpep.getStart(), fmatpep.getEnd(), strandMinus, trId);
        tr.setProteinCoding(true);
        tr.setRibosomalSlippage(ribosomalSlippage);
        this.add(tr);
        this.createCdsInTranscript(tr, fmatpep);
        this.proteinSequenceMapping(tr, fmatpep);
    }

    Transcript addMrna(Feature f, Gene geneLatest) {
        if (this.debug) {
            Log.debug("Feature:" + String.valueOf(f));
        }
        int start = f.getStart() - this.inOffset;
        int end = f.getEnd() - this.inOffset;
        Gene gene = null;
        gene = geneLatest != null && geneLatest.intersects(start, end) ? geneLatest : this.findOrCreateGene(f, this.chromosome, false);
        String trId = f.getTranscriptId();
        Transcript tr = new Transcript(gene, start, end, f.isComplement(), trId);
        if (f.hasMultipleCoordinates()) {
            int exNum = 1;
            for (FeatureCoordinates fc : f) {
                Exon e = new Exon(tr, fc.start - this.inOffset, fc.end - this.inOffset, fc.complement, tr.getId() + "_" + exNum, exNum);
                tr.add(e);
                ++exNum;
            }
        }
        this.add(tr);
        return tr;
    }

    boolean cdsMatchesGene(Feature fcds, Gene gene) {
        if (gene == null) {
            return false;
        }
        int start = fcds.getStart() - this.inOffset;
        int end = fcds.getEnd() - this.inOffset;
        if (start < gene.getStart() || gene.getEnd() < end) {
            return false;
        }
        String geneName = fcds.getGeneName();
        return geneName != null && gene != null && gene.getGeneName().equals(geneName);
    }

    boolean cdsMatchesTr(Feature fcds, Transcript tr) {
        if (tr == null) {
            return false;
        }
        int start = fcds.getStart() - this.inOffset;
        int end = fcds.getEnd() - this.inOffset;
        if (start < tr.getStart() || tr.getEnd() < end) {
            return false;
        }
        if (fcds.hasMultipleCoordinates() && !tr.subIntervals().isEmpty()) {
            return this.cdsMatchesTrExons(fcds, tr);
        }
        return true;
    }

    boolean cdsMatchesTrExons(Feature fcds, Transcript tr) {
        ArrayList<Exon> cdsExons = new ArrayList<Exon>();
        for (FeatureCoordinates fc : fcds) {
            Exon e = new Exon(tr, fc.start - this.inOffset, fc.end - this.inOffset, fc.complement, "", -1);
            cdsExons.add(e);
        }
        Collections.sort(cdsExons);
        ArrayList<Exon> trExons = new ArrayList<Exon>();
        trExons.addAll(tr.subIntervals());
        Collections.sort(trExons);
        if (cdsExons.size() > trExons.size()) {
            return false;
        }
        return this.cdsMatchesTrExons(cdsExons, trExons, tr);
    }

    boolean cdsMatchesTrExons(List<Exon> cdsExons, List<Exon> trExons, Transcript tr) {
        if (cdsExons.size() == 1) {
            Exon cdsEx = cdsExons.get(0);
            Exon trEx = tr.findExon(cdsEx);
            return trEx != null && trEx.includes(cdsEx);
        }
        int cdsExIdx = 0;
        int trExIdx = 0;
        Exon cdsEx = cdsExons.get(cdsExIdx);
        Exon trEx = trExons.get(trExIdx);
        while (cdsEx.getStart() > trEx.getEnd()) {
            if (++trExIdx >= trExons.size()) {
                return false;
            }
            trEx = trExons.get(trExIdx);
        }
        if (trEx.getStart() > cdsEx.getStart() || trEx.getEnd() != cdsEx.getEnd()) {
            return false;
        }
        while (cdsExIdx < cdsExons.size() - 2) {
            ++cdsExIdx;
            if (++trExIdx >= trExons.size()) {
                return false;
            }
            cdsEx = cdsExons.get(cdsExIdx);
            trEx = trExons.get(trExIdx);
            if (trEx.getStart() == cdsEx.getStart() && trEx.getEnd() == cdsEx.getEnd()) continue;
            return false;
        }
        ++trExIdx;
        if (++cdsExIdx >= cdsExons.size()) {
            return true;
        }
        if (trExIdx >= trExons.size()) {
            return false;
        }
        cdsEx = cdsExons.get(cdsExIdx);
        trEx = trExons.get(trExIdx);
        return trEx.getStart() == cdsEx.getStart() && trEx.getEnd() >= cdsEx.getEnd();
    }

    String chromoName(Features features, Feature sourceFeature) {
        String chrName;
        if (!features.getVersion().isEmpty()) {
            return features.getVersion();
        }
        if (sourceFeature != null) {
            if (sourceFeature.getType() != Feature.Type.SOURCE) {
                throw new RuntimeException("Cannot find chromosome name in a non-SOURCE feature");
            }
            chrName = sourceFeature.get("chromosome");
            if (chrName != null) {
                return chrName;
            }
        }
        if ((chrName = features.getLocusName()) != null) {
            return chrName;
        }
        return this.genome.getId();
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            for (Features features : this.featuresFile) {
                this.chromosome = null;
                this.addFeatures(features);
                this.beforeExonSequences();
                String sequence = this.sequence(features);
                this.addSequences(this.chromosome.getId(), sequence);
            }
            this.finishUp();
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + String.valueOf(e));
        }
        return this.snpEffectPredictor;
    }

    void createCdsInTranscript(Transcript tr, Feature fcds) {
        if (fcds.hasMultipleCoordinates()) {
            for (FeatureCoordinates fc : fcds) {
                int cdsStart = fc.start - this.inOffset;
                int cdsEnd = fc.end - this.inOffset;
                Cds cds = new Cds(tr, cdsStart, cdsEnd, fcds.isComplement(), "CDS_" + tr.getId());
                this.add(cds);
            }
            CircularCorrection cc = new CircularCorrection(tr);
            cc.setCorrectLargeGap(this.circularCorrectLargeGap);
            cc.correct();
        } else {
            Cds cds = new Cds(tr, fcds.getStart() - this.inOffset, fcds.getEnd() - this.inOffset, fcds.isComplement(), "CDS_" + tr.getId());
            this.add(cds);
        }
    }

    Gene findOrCreateGene(Feature f, Chromosome chr, boolean warn) {
        int start = f.getStart() - this.inOffset;
        int end = f.getEnd() - this.inOffset;
        String geneId = this.geneId(f, start, end);
        String geneName = this.geneName(f, start, end);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            gene = new Gene(chr, start, end, f.isComplement(), geneId, geneName, null);
            this.add(gene);
            if (this.debug) {
                System.err.println("WARNING: Gene '" + geneId + "' not found: created.");
            }
        }
        return gene;
    }

    Transcript findOrCreateTranscript(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        boolean strandMinus;
        int end;
        int start;
        Transcript trLatestMatch = this.findTrFromLatest(fcds, geneLatest, trLatest);
        if (trLatestMatch != null) {
            return trLatestMatch;
        }
        String trId = fcds.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr != null && !tr.hasCds()) {
            return tr;
        }
        Gene gene = null;
        if (tr != null) {
            trId = this.unusedTranscriptId(trId);
            gene = (Gene)tr.getParent();
            start = tr.getStart();
            end = tr.getEnd();
            strandMinus = tr.isStrandMinus();
        } else {
            gene = this.cdsMatchesGene(fcds, geneLatest) ? geneLatest : this.findOrCreateGene(fcds, this.chromosome, false);
            start = fcds.getStart() - this.inOffset;
            end = fcds.getEnd() - this.inOffset;
            strandMinus = fcds.isComplement();
        }
        if (this.debug) {
            System.err.println("Transcript '" + trId + "' not found. Creating new transcript for gene '" + gene.getId() + "'.\n" + String.valueOf(fcds));
        }
        tr = new Transcript(gene, start, end, strandMinus, trId);
        this.add(tr);
        return tr;
    }

    Transcript findTrFromLatest(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        if (trLatest == null) {
            return null;
        }
        if (this.cdsMatchesGene(fcds, geneLatest)) {
            for (Transcript tr : trLatest) {
                if (tr.hasCds() || !this.cdsMatchesTr(fcds, tr)) continue;
                return tr;
            }
        }
        return null;
    }

    protected String geneId(Feature f, int start, int end) {
        String geneId = f.getGeneId();
        if (geneId != null) {
            return geneId;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String geneName(Feature f, int start, int end) {
        String geneName = f.getGeneName();
        if (geneName != null) {
            return geneName;
        }
        return "Gene_" + start + "_" + end;
    }

    @Override
    public Map<String, String> getProteinByTrId() {
        return this.proteinByTrId;
    }

    void proteinSequenceMapping(Transcript tr, Feature fcds) {
        String proteinSeq = fcds.getAasequence();
        if (proteinSeq == null) {
            return;
        }
        String trId = tr.getId();
        if (this.proteinByTrId.containsKey(trId)) {
            throw new RuntimeException("Protein sequence for transcript id '" + trId + "' already exists:\nProtein sequence: " + proteinSeq + "\nFeature: " + String.valueOf(fcds));
        }
        this.proteinByTrId.put(trId, proteinSeq);
    }

    String sequence(Features features) {
        String seq = features.getSequence();
        if (seq != null && !seq.isEmpty()) {
            return seq;
        }
        if (this.verbose) {
            Log.info("No sequence found in feature file.");
        }
        for (String fastaFile : this.config.getFileListGenomeFasta()) {
            if (this.verbose) {
                Log.info("\tTrying fasta file '" + fastaFile + "'");
            }
            if (!Gpr.canRead(fastaFile) || (seq = GprSeq.fastaSimpleRead(fastaFile)) == null || seq.isEmpty()) continue;
            return seq;
        }
        throw new RuntimeException("Cannot find sequence for '" + this.config.getGenome().getVersion() + "'");
    }

    String unusedTranscriptId(String trId) {
        int i2 = 2;
        String tridi;
        while (this.findTranscript(tridi = trId + "." + i2) != null) {
            ++i2;
        }
        return tridi;
    }
}

