/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CircularCorrection;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.GffType;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public abstract class SnpEffPredictorFactory {
    public static final int MARK = 100;
    public static int MIN_TOTAL_FRAME_COUNT = 10;
    boolean circularCorrectLargeGap = false;
    boolean createRandSequences = false;
    boolean debug = false;
    boolean frameCorrection;
    boolean readSequences = true;
    boolean storeSequences = false;
    boolean verbose = false;
    int lineNum;
    int inOffset;
    int totalSeqsAdded = 0;
    int totalSeqsIgnored = 0;
    String fileName;
    String fastaFile;
    String line;
    Config config;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;
    FrameType frameType;
    Set<String> chromoNamesReference;
    Map<String, Integer> exonsByChromo;
    Map<String, Marker> markersById;
    Map<String, Gene> genesById;
    Map<String, Transcript> transcriptsById;
    Random random = new Random(20140410L);

    public SnpEffPredictorFactory(Config config, int inOffset) {
        this.config = config;
        this.inOffset = inOffset;
        this.genome = config.getGenome();
        this.snpEffectPredictor = new SnpEffectPredictor(config.getGenome());
        this.exonsByChromo = new HashMap<String, Integer>();
        this.markersById = new HashMap<String, Marker>();
        this.genesById = new HashMap<String, Gene>();
        this.transcriptsById = new HashMap<String, Transcript>();
        this.chromoNamesReference = new HashSet<String>();
        this.frameCorrection = false;
        this.frameType = FrameType.UNKNOWN;
    }

    protected void add(Cds cds) {
        Transcript tr = (Transcript)cds.getParent();
        tr.add(cds);
        this.addMarker(cds, false);
    }

    protected void add(Chromosome chromo) {
        this.genome.add(chromo);
    }

    protected Exon add(Exon exon) {
        Transcript tr = (Transcript)exon.getParent();
        Exon oldex = (Exon)tr.get(exon.getId());
        if (oldex != null) {
            if (oldex.includes(exon)) {
                return oldex;
            }
            exon = new Exon(tr, exon.getStart(), exon.getEnd(), exon.isStrandMinus(), exon.getId() + "_" + tr.subIntervals().size(), exon.getRank());
        }
        tr.add(exon);
        this.addMarker(exon, false);
        return exon;
    }

    protected void add(Gene gene) {
        if (this.debug) {
            Log.debug("\tAdding gene\tID: '" + gene.getId() + "'\tname: '" + gene.getGeneName() + "'\t" + gene.toStr());
        }
        this.snpEffectPredictor.add(gene);
        if (this.genesById.containsKey(gene.getId())) {
            throw new RuntimeException("Gene  '" + gene.getId() + "' already exists");
        }
        this.genesById.put(gene.getId(), gene);
    }

    protected void add(Marker marker) {
        if (this.debug) {
            Log.debug("\tAdding " + marker.getClass().getSimpleName() + ":\tID: '" + marker.getId() + "'\t" + marker.toStr());
        }
        this.addMarker(marker, false);
    }

    protected void add(Transcript tr) {
        Gene gene = (Gene)tr.getParent();
        if (this.debug) {
            Log.debug("\tAdding transcript :\tID: '" + tr.getId() + "' to gene '" + gene.getId() + "'\t" + tr.toStr());
        }
        gene.add(tr);
        if (this.transcriptsById.containsKey(tr.getId())) {
            throw new RuntimeException("Transcript  '" + tr.getId() + "' already exists");
        }
        this.transcriptsById.put(tr.getId(), tr);
    }

    protected void addMarker(Marker marker, boolean unique) {
        String key = marker.getId();
        if (unique && this.markersById.containsKey(key)) {
            throw new RuntimeException("Marker '" + key + "' already exists");
        }
        this.markersById.put(key, marker);
    }

    protected void addSequences(String chr, String chrSeq) {
        int chrLen = chrSeq.length();
        Chromosome chromo = this.getOrCreateChromosome(chr);
        chromo.setLength(chrLen);
        chromo.detectCircular();
        int seqsAdded = 0;
        int seqsIgnored = 0;
        if (this.storeSequences) {
            if (this.verbose) {
                Log.info("\t\tAdding genomic sequences to genes: ");
            }
            int count = this.genome.getGenomicSequences().addGeneSequences(chr, chrSeq);
            if (this.verbose) {
                Log.info("\tDone (" + count + " sequences added).");
            }
        }
        if (this.verbose) {
            Log.info("\t\tAdding genomic sequences to exons: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            for (Transcript tr : gene) {
                CircularCorrection cc = new CircularCorrection(tr, chrLen);
                cc.setDebug(this.debug);
                cc.setCorrectLargeGap(this.circularCorrectLargeGap);
                cc.correct();
                for (Exon exon : tr) {
                    int ssStart = exon.getStart();
                    int ssEnd = exon.getEnd() + 1;
                    Object seq = null;
                    if (ssStart >= 0 && ssEnd <= chrLen) {
                        try {
                            seq = chrSeq.substring(ssStart, ssEnd);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            throw new RuntimeException("Error trying to add sequence to exon:\n\tChromosome sequence length: " + chrSeq.length() + "\n\tExon: " + String.valueOf(exon));
                        }
                    } else {
                        if (!chromo.isCircular()) {
                            throw new RuntimeException("Coordinated out of bounds on a non-circular chromosome. This should never happen!Error trying to add sequence to exon:\n\tExon: " + String.valueOf(exon));
                        }
                        if (ssStart < 0 && ssEnd > 0) {
                            seq = chrSeq.substring(ssStart += chrLen, chrLen) + chrSeq.substring(0, ssEnd);
                        } else if (ssStart < 0 && ssEnd < 0) {
                            seq = chrSeq.substring(ssStart += chrLen, ssEnd += chrLen);
                        }
                    }
                    if (seq == null) continue;
                    if (((String)seq).length() != exon.size()) {
                        this.warning(ErrorWarningType.WARNING_EXON_SEQUENCE_LENGTH, "Exon sequence length does not match exon.size()\n" + String.valueOf(exon));
                    }
                    if (exon.isStrandMinus()) {
                        seq = GprSeq.reverseWc((String)seq);
                    }
                    seq = ((String)seq).toUpperCase();
                    exon.setSequence((String)seq);
                    ++seqsAdded;
                }
            }
        }
        if (this.verbose) {
            Log.info("\tDone (" + seqsAdded + " sequences added, " + seqsIgnored + " ignored).");
        }
        this.totalSeqsAdded += seqsAdded;
        this.totalSeqsIgnored += seqsIgnored;
    }

    protected void adjustChromosomes() {
        if (this.verbose) {
            Log.info("Adjusting chromosomes lengths: ");
        }
        HashMap<String, Integer> lenByChr = new HashMap<String, Integer>();
        for (Gene gene : this.config.getGenome().getGenes()) {
            String chrName = gene.getChromosomeName();
            Integer len = (Integer)lenByChr.get(chrName);
            Chromosome chr = gene.getChromosome();
            if (chr.getEnd() > 0 && gene.getEnd() > chr.getEnd()) {
                Log.warning(ErrorWarningType.WARNING_CHROMOSOME_LENGTH, "Chromosome '" + chr.getChromosomeName() + "' has end coordinate " + chr.getEnd() + ", but gene ID '" + gene.getId() + "' has end coordiante " + gene.getEnd());
            }
            int max = Math.max(gene.getEnd(), len != null ? len : 0);
            lenByChr.put(chrName, max);
        }
        int adjusted = 0;
        for (String chrName : lenByChr.keySet()) {
            Chromosome chr = this.config.getGenome().getChromosome(chrName);
            int newEnd = (Integer)lenByChr.get(chrName);
            if (chr.getEnd() >= newEnd) continue;
            if (chr.size() <= 1) {
                chr.setEnd((Integer)lenByChr.get(chrName));
                this.mark(adjusted++);
                continue;
            }
            if (!this.verbose) continue;
            Log.info("\t\tChromosome '" + chr.getId() + "' has length of " + chr.size() + ", but genes end at " + String.valueOf(lenByChr.get(chrName)));
        }
    }

    void adjustGenes() {
        int i2 = 1;
        if (this.verbose) {
            Log.info("Adjusting genes: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.adjust()) continue;
            this.mark(i2++);
        }
    }

    protected void adjustTranscripts() {
        int i2 = 1;
        if (this.verbose) {
            Log.info("Adjusting transcripts: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.adjust()) continue;
                this.mark(i2++);
            }
        }
    }

    protected void beforeExonSequences() {
        if (this.debug) {
            Log.info("Actions before creating sequences");
        }
        this.exonsFromCds();
        this.deleteRedundant();
        this.collapseZeroLenIntrons();
    }

    void checkAllFramesAreZero() {
        int[] countByFrame = new int[3];
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                int frame;
                for (Exon ex : tr) {
                    frame = ex.getFrame();
                    if (frame < 0 || frame > 2) continue;
                    int n = frame;
                    countByFrame[n] = countByFrame[n] + 1;
                }
                for (Cds cds : tr.getCds()) {
                    frame = cds.getFrame();
                    if (frame < 0 || frame > 2) continue;
                    int n = frame;
                    countByFrame[n] = countByFrame[n] + 1;
                }
            }
        }
        int countByFrameTotal = countByFrame[0] + countByFrame[1] + countByFrame[2];
        int countByFrameNonZero = countByFrame[1] + countByFrame[2];
        if (countByFrameTotal >= MIN_TOTAL_FRAME_COUNT && countByFrameNonZero <= 0) {
            Log.warning(ErrorWarningType.WARNING_FRAMES_ZERO, "All frames are zero! This seems rather odd, please check that 'frame' information in your 'genes' file is accurate.");
        }
    }

    protected void codingFromCds() {
        int i2 = 0;
        if (this.verbose) {
            Log.info("Marking as 'coding' from CDS information: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (tr.getCds() == null || tr.getCds().isEmpty() || tr.isProteinCoding() || tr.getBioType() != null) continue;
                tr.setProteinCoding(true);
                ++i2;
                if (!this.debug) continue;
                System.err.println("\t\tMarking as protein coding transcript " + tr.getId());
            }
        }
        if (this.verbose) {
            Log.info("Done: " + i2 + " transcripts marked");
        }
    }

    protected void collapseZeroLenIntrons() {
        if (this.verbose) {
            Log.info("Collapsing zero length introns (if needed): ");
        }
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.collapseZeroGap()) continue;
                this.mark(count++);
            }
        }
        if (this.verbose) {
            Log.info("\tTotal collapsed transcripts: " + count);
        }
    }

    void countExonsByChromo() {
        this.exonsByChromo = new HashMap<String, Integer>();
        for (Gene gint : this.genome.getGenes()) {
            Chromosome chromo = gint.getChromosome();
            for (Transcript tint : gint) {
                for (Exon eint : tint) {
                    String chromoName = chromo.getId();
                    Integer count = this.exonsByChromo.get(chromoName);
                    if (count == null) {
                        count = 1;
                    } else {
                        Integer n = count;
                        count = count + 1;
                    }
                    this.exonsByChromo.put(chromoName, count);
                }
            }
        }
    }

    public abstract SnpEffectPredictor create();

    protected void createRandSequences() {
        if (this.debug) {
            Log.debug("\tCreating exon sequences");
        }
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    String sequence = GprSeq.randSequence(this.random, ex.size());
                    ex.setSequence(sequence);
                }
            }
        }
    }

    protected void deleteRedundant() {
        if (this.verbose) {
            Log.info("Deleting redundant exons (if needed): ");
        }
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.deleteRedundant()) continue;
                this.mark(count++);
            }
        }
        if (this.verbose) {
            Log.info("\tTotal transcripts with deleted exons: " + count);
        }
    }

    protected void exonsFromCds() {
        if (this.verbose) {
            Log.info("Create exons from CDS (if needed): ");
        }
        int count = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                int lenCds = 0;
                for (Cds cds : tr.getCds()) {
                    lenCds += cds.size();
                }
                int lenExons = 0;
                for (Exon ex : tr) {
                    lenExons += ex.size();
                }
                if (lenCds <= lenExons) continue;
                this.exonsFromCds(tr);
                ++count;
            }
        }
        if (this.verbose) {
            Log.info("Exons created for " + count + " transcripts.");
        }
    }

    protected void exonsFromCds(Transcript tr) {
        boolean cdsStrandMinus;
        List<Cds> cdss = tr.getCds();
        boolean trStrandMinus = tr.isStrandMinus();
        int cdsStrandSum = 0;
        for (Cds cds : cdss) {
            cdsStrandSum += cds.isStrandMinus() ? -1 : 1;
        }
        boolean bl = cdsStrandMinus = cdsStrandSum < 0;
        if (cdsStrandMinus != trStrandMinus) {
            if (this.verbose) {
                System.out.print(cdsStrandMinus ? (char)'-' : '+');
            }
            tr.setStrandMinus(cdsStrandMinus);
        }
        if (tr.isStrandPlus()) {
            Collections.sort(cdss, new IntervalComparatorByStart());
        } else {
            Collections.sort(cdss, new IntervalComparatorByEnd(true));
        }
        int rank = 1;
        for (Cds cds : cdss) {
            String id = String.valueOf((Object)GffType.EXON) + "_" + cds.getChromosomeName() + "_" + cds.getStart() + "_" + cds.getEnd();
            if (tr.get(id) == null) {
                Exon exon = new Exon(tr, cds.getStart(), cds.getEnd(), trStrandMinus, id, rank);
                tr.add(exon);
            }
            ++rank;
            if (!this.verbose) continue;
            System.out.print('.');
        }
    }

    protected Gene findGene(String id) {
        Gene gene = this.genesById.get(id);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get(String.valueOf((Object)GffType.GENE) + "_" + id);
    }

    protected Gene findGene(String geneId, String id) {
        Gene gene = this.findGene(geneId);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get(String.valueOf((Object)GffType.GENE) + "_" + id);
    }

    protected Marker findMarker(String id) {
        return this.markersById.get(id);
    }

    protected Transcript findTranscript(String id) {
        Transcript tr = this.transcriptsById.get(id);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get(String.valueOf((Object)GffType.TRANSCRIPT) + "_" + id);
    }

    protected Transcript findTranscript(String trId, String id) {
        Transcript tr = this.findTranscript(trId);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get(String.valueOf((Object)GffType.TRANSCRIPT) + "_" + id);
    }

    void finishUp() {
        if (this.verbose) {
            Log.info("Finishing up genome");
        }
        this.adjustTranscripts();
        this.adjustGenes();
        this.adjustChromosomes();
        this.rankExons();
        if (this.verbose) {
            Log.info("Create UTRs from CDS (if needed): ");
        }
        this.utrFromCds();
        if (this.frameCorrection) {
            this.frameCorrection();
        }
        this.removeEmptyChromos();
        this.codingFromCds();
        if (this.readSequences) {
            boolean error;
            boolean bl = error = !this.config.getGenome().isMostExonsHaveSequence();
            if (error) {
                Log.fatalError("Most Exons do not have sequences!\n" + this.showChromoNamesDifferences() + "\n\n");
            }
        }
        if (this.verbose) {
            Log.info("");
        }
    }

    void frameCorrection() {
        if (this.verbose) {
            Log.info("Correcting exons based on frame information.\n\t");
        }
        this.checkAllFramesAreZero();
        int i2 = 1;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                boolean corrected = tr.frameCorrection();
                if (!corrected) continue;
                if (this.debug) {
                    Log.debug("\tTranscript " + tr.getId() + " corrected using frame (exons: " + tr.numChilds() + ").");
                    continue;
                }
                if (!this.verbose) continue;
                Gpr.showMark(i2++, 1);
            }
        }
        if (this.verbose) {
            Log.info("");
        }
    }

    protected Chromosome getOrCreateChromosome(String chromoName) {
        Chromosome chromo = this.genome.getChromosome(chromoName);
        if (chromo == null) {
            chromo = new Chromosome(this.genome, 0, 0, chromoName);
            this.genome.add(chromo);
        }
        return chromo;
    }

    public Map<String, String> getProteinByTrId() {
        return null;
    }

    boolean hasExons(String chromoName) {
        Integer count = this.exonsByChromo.get(chromoName);
        return count != null && count > 0;
    }

    void mark(int count) {
        if (this.verbose) {
            Gpr.showMark(count, 100, "\t\t");
        }
    }

    protected int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    void rankExons() {
        int i2 = 1;
        if (this.verbose) {
            Log.info("Ranking exons: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.rankExons()) continue;
                this.mark(i2++);
            }
        }
    }

    protected void readExonSequences() {
        if (this.debug) {
            Log.info("Reading exon sequences from files");
        }
        List<String> files = this.config.getFileListGenomeFasta();
        if (this.fastaFile != null) {
            files.clear();
            files.add(this.fastaFile);
        }
        for (String file : files) {
            if (Gpr.canRead(file)) {
                if (this.verbose) {
                    Log.info("\tReading FASTA file: '" + file + "'");
                }
                FastaFileIterator ffi = new FastaFileIterator(file);
                for (String seq : ffi) {
                    String chromo = ffi.getName();
                    this.chromoNamesReference.add(chromo);
                    if (this.verbose) {
                        Log.info("\t\tReading sequence '" + chromo + "', length: " + seq.length());
                    }
                    this.addSequences(chromo, seq);
                }
                return;
            }
            if (!this.verbose) continue;
            Log.info("\tFASTA file: '" + file + "' not found.");
        }
        throw new RuntimeException("Cannot find reference sequence.");
    }

    void removeEmptyChromos() {
        if (this.verbose) {
            Log.info("Remove empty chromosomes: ");
        }
        ArrayList<Chromosome> chrToDelete = new ArrayList<Chromosome>();
        for (Chromosome chr : this.config.getGenome()) {
            if (chr.size() > 1) continue;
            chrToDelete.add(chr);
        }
        for (Chromosome chr : chrToDelete) {
            if (this.verbose) {
                Log.info("\t\tRemoving empty chromosome: '" + chr.getId() + "'");
            }
            this.config.getGenome().remove(chr);
        }
        if (this.verbose && chrToDelete.size() > 0) {
            System.out.print("\t\tChromosome left: ");
            for (Chromosome chr : this.config.getGenome()) {
                System.out.print(chr.getId() + " ");
            }
            System.out.println("");
        }
    }

    protected void replaceTranscript(Transcript trOld, Transcript trNew) {
        this.transcriptsById.remove(trOld.getId());
        this.transcriptsById.put(trNew.getId(), trNew);
    }

    public void setCircularCorrectLargeGap(boolean circularCorrectLargeGap) {
        this.circularCorrectLargeGap = circularCorrectLargeGap;
    }

    public void setCreateRandSequences(boolean createRandSequences) {
        this.createRandSequences = createRandSequences;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFastaFile(String fastaFile) {
        this.fastaFile = fastaFile;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setReadSequences(boolean readSequences) {
        this.readSequences = readSequences;
    }

    public void setStoreSequences(boolean storeSequences) {
        this.storeSequences = storeSequences;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected String showChromoNamesDifferences() {
        if (this.chromoNamesReference.isEmpty()) {
            return "";
        }
        HashSet<String> chrs = new HashSet<String>();
        for (Gene g : this.config.getGenome().getGenes()) {
            chrs.add(g.getChromosomeName());
        }
        int counMissinfRef = 0;
        StringBuilder sbMissingRef = new StringBuilder();
        ArrayList<String> chrsSorted = new ArrayList<String>();
        chrsSorted.addAll(chrs);
        Collections.sort(chrsSorted);
        for (String chr : chrsSorted) {
            if (this.chromoNamesReference.contains(chr)) continue;
            ++counMissinfRef;
            if (sbMissingRef.length() > 0) {
                sbMissingRef.append(", ");
            }
            sbMissingRef.append("'" + chr + "'");
        }
        int counMissinfGenes = 0;
        StringBuilder sbMissingGenes = new StringBuilder();
        ArrayList<String> chrsRefSorted = new ArrayList<String>();
        chrsRefSorted.addAll(this.chromoNamesReference);
        Collections.sort(chrsRefSorted);
        for (String chr : chrsRefSorted) {
            if (chrs.contains(chr)) continue;
            ++counMissinfGenes;
            if (sbMissingGenes.length() > 0) {
                sbMissingRef.append(", ");
            }
            sbMissingGenes.append("'" + chr + "'");
        }
        Object msg = "";
        if (counMissinfRef > 0 && counMissinfGenes > 0) {
            msg = "There might be differences in the chromosome names used in the genes file ('" + this.fileName + "')\nand the chromosme names used in the 'reference sequence' file" + (String)(this.fastaFile != null ? " ('" + this.fastaFile + "')" : "") + ".\nPlease check that chromosome names in both files match.\n";
        }
        return (String)msg + (String)(sbMissingRef.length() > 0 ? "\tChromosome names missing in 'reference sequence' file:\t" + sbMissingRef.toString() : "") + (String)(sbMissingGenes.length() > 0 ? "\n\tChromosome names missing in 'genes' file             :\t" + sbMissingGenes.toString() : "");
    }

    String unquote(String qstr) {
        return qstr.replaceAll("\"", "");
    }

    void utrFromCds() {
        int i2 = 1;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.utrFromCds(this.debug)) continue;
                this.mark(i2++);
            }
        }
    }

    void warning(ErrorWarningType warnType, String msg) {
        Log.warning(warnType, msg + ". File '" + this.fileName + "' line " + this.lineNum + "\t'" + this.line + "'");
    }
}

