/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genes;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.stats.TranslocationReport;
import org.snpeff.svg.SvgTranslocation;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class SnpEffCmdTranslocationsReport
extends SnpEff {
    public static final String REPORT_TEMPLATE = "translocations_report.ftl";
    public static final String DEFAULT_REPORT_HTML_FILE = "translocations_report.html";
    boolean onlyOneTranscript;
    boolean useLocalTemplate = false;
    int countTranslocations;
    String outPath = "";
    String reportFile = "translocations_report.html";
    String vcfFileName = "";
    List<TranslocationReport> translocationReports;

    public SnpEffCmdTranslocationsReport() {
        this.nextProt = true;
    }

    boolean filterVariants(Variant var) {
        Variant.VariantType vt = var.getVariantType();
        return vt != Variant.VariantType.BND && vt != Variant.VariantType.DUP && vt != Variant.VariantType.DEL;
    }

    Gene findGene(String gene) {
        SnpEffectPredictor sep = this.config.getSnpEffectPredictor();
        Gene g = sep.getGene(gene);
        if (g != null) {
            return g;
        }
        Genes genes = sep.getGenome().getGenes();
        g = genes.getGeneByName(gene);
        if (g == null) {
            Log.info("Gene '" + gene + "' not found. Skipping plot");
        }
        return g;
    }

    boolean isTranslocation(EffectType effType) {
        return effType == EffectType.GENE_FUSION || effType == EffectType.GENE_FUSION_REVERESE || effType == EffectType.GENE_FUSION_HALF;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args == null) {
            return;
        }
        this.args = args;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-onlyonetr": {
                        this.onlyOneTranscript = true;
                        break;
                    }
                    case "-outpath": {
                        if (i2 + 1 < args.length) {
                            this.outPath = args[++i2];
                            break;
                        }
                        this.usage("Missing -outPath argument");
                        break;
                    }
                    case "-report": {
                        if (i2 + 1 < args.length) {
                            this.reportFile = args[++i2];
                            break;
                        }
                        this.usage("Missing -report argument");
                        break;
                    }
                    case "-uselocaltemplate": {
                        this.useLocalTemplate = true;
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.vcfFileName.isEmpty()) {
                this.vcfFileName = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.vcfFileName.isEmpty()) {
            this.vcfFileName = "-";
        } else if (!Gpr.canRead(this.vcfFileName)) {
            this.usage("Cannot read input file '" + this.vcfFileName + "'");
        }
    }

    void report() {
        this.translocationReports = new ArrayList<TranslocationReport>();
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFileName);
        for (VcfEntry ve : vcf) {
            Variant var;
            List<Variant> vars;
            if (this.debug) {
                System.out.println(ve);
            }
            if ((vars = ve.variants()).isEmpty() || this.filterVariants(var = vars.get(0))) continue;
            ++this.countTranslocations;
            this.report(ve, var);
        }
    }

    void report(VcfEntry ve, Variant var) {
        for (VcfEffect veff : ve.getVcfEffects()) {
            if (!this.isTranslocation(veff.getEffectType())) continue;
            if (this.debug) {
                System.out.println("\t" + String.valueOf(veff));
            }
            String geneStr = veff.getGeneId();
            String[] genes = geneStr.split("&");
            if (this.verbose) {
                Log.info("Plotting translocation: '" + String.valueOf(veff) + "'");
            }
            if (genes.length < 2) continue;
            String geneName1 = genes[0];
            String geneName2 = genes[1];
            this.reportBnd(this.variantBnd(var), veff, geneName1, geneName2);
        }
    }

    String reportBnd(VariantBnd varBnd, VcfEffect veff, String gene1, String gene2) {
        if (this.debug) {
            System.out.println("\tGenes: " + gene1 + "\t" + gene2);
        }
        Gene g1 = this.findGene(gene1);
        Gene g2 = this.findGene(gene2);
        if (g1 == null || g2 == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Transcript tr1 : g1) {
            for (Transcript tr2 : g2) {
                sb.append(this.reportBnd(varBnd, veff, tr1, tr2));
                if (!this.onlyOneTranscript) continue;
                if (this.verbose) {
                    Log.info("Plotting only one transcript pair");
                }
                return sb.toString();
            }
        }
        return sb.toString();
    }

    TranslocationReport reportBnd(VariantBnd varBnd, VcfEffect veff, Transcript tr1, Transcript tr2) {
        if (this.debug) {
            System.out.println("\tTranscripts: " + tr1.getId() + "\t" + tr2.getId());
        }
        SvgTranslocation svgTranslocation = new SvgTranslocation(tr1, tr2, varBnd, this.config.getSnpEffectPredictor());
        String svgPlot = svgTranslocation.toString();
        TranslocationReport trRep = new TranslocationReport(varBnd, veff, tr1, tr2);
        trRep.setSvgPlot(svgPlot);
        this.translocationReports.add(trRep);
        if (this.outPath != null && !this.outPath.isEmpty()) {
            String fileName = this.outPath + "/" + varBnd.getChromosomeName() + ":" + (varBnd.getStart() + 1) + "_" + varBnd.getEndPoint().getChromosomeName() + ":" + (varBnd.getEndPoint().getStart() + 1) + "-" + tr2.getId() + ".html";
            Gpr.toFile(fileName, svgPlot);
            if (this.verbose) {
                Log.info("Saved to file " + fileName);
            }
        }
        return trRep;
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        this.report();
        this.summary(REPORT_TEMPLATE, this.reportFile, false);
        if (this.verbose) {
            Log.info("Done.");
        }
        return true;
    }

    public void setOnlyOneTranscript(boolean onlyOneTranscript) {
        this.onlyOneTranscript = onlyOneTranscript;
    }

    public void setVcfFileName(String vcfFileName) {
        this.vcfFileName = vcfFileName;
    }

    boolean summary(String templateFile, String outputFile, boolean noCommas) {
        try {
            if (this.verbose) {
                Log.info("Creating report file '" + outputFile + "'");
            }
            Configuration cfg = new Configuration();
            if (this.useLocalTemplate) {
                cfg.setDirectoryForTemplateLoading(new File("./templates/"));
            } else {
                cfg.setClassForTemplateLoading(SnpEffCmdEff.class, "/");
            }
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setLocale(Locale.US);
            if (noCommas) {
                cfg.setNumberFormat("0.######");
            }
            HashMap<String, Object> root = this.summaryCreateHash();
            Template temp = cfg.getTemplate(templateFile);
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(outputFile)));
            temp.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            Log.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        catch (TemplateException e) {
            Log.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        return true;
    }

    HashMap<String, Object> summaryCreateHash() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("args", this.commandLineStr(true));
        root.put("countTranslocations", this.countTranslocations);
        root.put("date", String.format("%1$TY-%1$Tm-%1$Td %1$TH:%1$TM", new Date()));
        root.put("translocations", this.translocationReports);
        root.put("version", SnpEff.VERSION);
        return root;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
            System.err.println("Command line :\t" + this.commandLineStr(false) + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff translocReport [options] genome_version input.vcf");
        System.err.println("\n");
        System.err.println("\nOptions:");
        System.err.println("\t-onlyOneTr         : Report only one transcript (used for debugging).");
        System.err.println("\t-outPath <dir>     : Create output SVG files for each translocation in 'path' (set to empty to disable). Default '" + this.outPath + "'");
        System.err.println("\t-report <file>     : Output report file name. Default: " + this.reportFile);
        System.exit(-1);
    }

    VariantBnd variantBnd(Variant var) {
        if (var.isBnd()) {
            return (VariantBnd)var;
        }
        if (var.isDup() || var.isDel()) {
            return new VariantBnd(var.getChromosome(), var.getStart(), "N", "N", var.getChromosome(), var.getEnd(), false, false);
        }
        throw new RuntimeException("Unsupported variant type '" + String.valueOf((Object)var.getVariantType()) + "'");
    }
}

