/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.ArrayList;
import org.snpeff.SnpEff;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Genome;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class SnpEffCmdSeq
extends SnpEff {
    boolean reverseWc = false;
    ArrayList<String> sequences = new ArrayList();

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-r": {
                        this.reverseWc = true;
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.sequences.add(arg);
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genome");
        }
        if (this.sequences.isEmpty()) {
            this.usage("Missing sequences");
        }
        this.log = false;
    }

    @Override
    public boolean run() {
        this.loadConfig();
        Genome genome = this.config.getGenome();
        CodonTable codonTable = CodonTables.getInstance().getTable(genome);
        if (codonTable == null) {
            Log.fatalError("Could not find codon table for genome '" + genome.getId() + "'");
        }
        for (String seq : this.sequences) {
            System.out.println("Sequence                   : " + seq);
            if (this.reverseWc) {
                seq = GprSeq.reverseWc(seq);
                System.out.println("Complement                 : " + seq);
            }
            String aa = codonTable.aa(seq);
            String aa3 = codonTable.aaThreeLetterCode(aa);
            StringBuilder aasp = new StringBuilder();
            for (char c : aa.toCharArray()) {
                aasp.append(" " + c + " ");
            }
            System.out.println("Protein (3-Letter)         : " + aa3);
            System.out.println("Protein (1-Letter-space)   : " + String.valueOf(aasp));
            System.out.println("Protein (1-Letter)         : " + aa + "\n");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff seq [-r] genome seq_1 seq_2 ... seq_N");
        System.err.println("\t-r : Reverse-Watson-Cricks complement.");
        System.exit(-1);
    }
}

