/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.SnpEff;
import org.snpeff.align.SmithWaterman;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.genBank.EmblFile;
import org.snpeff.genBank.Feature;
import org.snpeff.genBank.Features;
import org.snpeff.genBank.FeaturesFile;
import org.snpeff.genBank.GenBankFile;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.commandLine.SnpEffCmdCds;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class SnpEffCmdProtein
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double MAX_ERROR_RATE = 0.06;
    boolean checkNumOk = true;
    boolean codonTables;
    boolean storeAlignments;
    double maxErrorRate = MAX_ERROR_RATE;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String configFile = "snpEff.config";
    String proteinFile = "";
    Map<String, String> proteinById;
    AutoHashMap<String, List<Transcript>> trByChromo;
    HashMap<String, SmithWaterman> alignmentByTrId = new HashMap();

    public SnpEffCmdProtein() {
    }

    public SnpEffCmdProtein(Config config, String proteinFile) {
        this.config = config;
        this.proteinFile = proteinFile;
    }

    void add(String trId, String seq, int lineNum, boolean check) {
        if (check && this.proteinById.get(trId) != null && !this.proteinById.get(trId).equals(seq)) {
            System.err.println("ERROR: Different protein for the same transcript ID. This should never happen!!!\n\tLine number   : " + lineNum + "\n\tTranscript ID : '" + trId + "'\n\tProtein       : " + this.proteinById.get(trId) + "\n\tProtein (new) : " + seq);
        }
        this.proteinById.put(trId, seq);
        if (this.debug) {
            Log.debug("Adding proteinById{'" + trId + "'} :\t" + seq);
        }
    }

    boolean checkCodonTables() {
        if (this.verbose) {
            Log.info("Comparing Proteins...");
        }
        this.createTrByChromo();
        boolean ok = true;
        for (Chromosome chromo : this.genome) {
            String chr = chromo.getId();
            for (CodonTable codonTable : CodonTables.getInstance()) {
                this.setCodonTable(chromo, codonTable);
                double errorRate = this.proteinCompare(chr, false, false);
                ok |= errorRate < this.maxErrorRate;
            }
        }
        if (this.verbose) {
            Log.info("done");
        }
        return ok;
    }

    boolean checkProteins() {
        if (this.verbose) {
            Log.info("Comparing Proteins...");
        }
        if (this.codonTables) {
            return this.checkCodonTables();
        }
        double errorRate = this.proteinCompare(null, true, true);
        return errorRate <= this.maxErrorRate;
    }

    void createTrByChromo() {
        this.trByChromo = new AutoHashMap(new ArrayList());
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                String chr = tr.getChromosomeName();
                this.trByChromo.getOrCreate(chr).add(tr);
            }
        }
    }

    boolean equals(String protein, String proteinRef) {
        if (protein.isEmpty() && proteinRef.isEmpty()) {
            return true;
        }
        if ((protein = this.proteinFormat(protein)).equals(proteinRef = this.proteinFormat(proteinRef))) {
            return true;
        }
        String refUnk = "";
        if (proteinRef.length() > 0 && protein.equals(refUnk = proteinRef.substring(0, proteinRef.length() - 1))) {
            return true;
        }
        String proteinNoStart = "";
        String proteinRefNoStart = "";
        if (protein.length() > 0 && proteinRef.length() > 0 && (proteinNoStart = protein.substring(1)).equals(proteinRefNoStart = proteinRef.substring(1))) {
            return true;
        }
        String proteinU = protein.replace('*', 'U');
        if (proteinU.equals(proteinRef) || proteinU.equals(refUnk)) {
            return true;
        }
        String proteinNoStartU = proteinNoStart.replace('*', 'U');
        if (proteinNoStartU.equals(proteinRefNoStart)) {
            return true;
        }
        String proteinUnknownAa = this.replaceUnknownAa(proteinNoStartU, proteinRefNoStart);
        return proteinUnknownAa.equals(proteinRefNoStart);
    }

    void fatalErrorNoTranscriptsChecked() {
        StringBuilder sb = new StringBuilder();
        int maxTrIds = 20;
        sb.append("Transcript IDs from database (sample):\n" + this.sampleTrIds(maxTrIds));
        sb.append("Transcript IDs from database (fasta file):\n" + this.sampleTrIdsFasta(maxTrIds));
        Log.fatalError("No proteins checked. This is might be caused by differences in FASTA file transcript IDs respect to database's transcript's IDs.\n" + String.valueOf(sb));
    }

    public HashMap<String, SmithWaterman> getAlignmentByTrId() {
        return this.alignmentByTrId;
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalNotFound() {
        return this.totalNotFound;
    }

    public int getTotalOk() {
        return this.totalOk;
    }

    public int getTotalWarnings() {
        return this.totalWarnings;
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                if (arg.equalsIgnoreCase("-codonTables")) {
                    this.codonTables = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.proteinFile.isEmpty()) {
                this.proteinFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.proteinFile.isEmpty()) {
            this.usage("Missing protein_file parameter");
        }
    }

    double proteinCompare(String chr, boolean addTotals, boolean updateTranscriptAaCheck) {
        List<Transcript> trList = null;
        if (chr == null) {
            trList = new ArrayList();
            for (Gene g : this.genome.getGenes()) {
                for (Transcript tr : g) {
                    trList.add(tr);
                }
            }
        } else {
            trList = (List)this.trByChromo.get(chr);
        }
        if (trList.isEmpty()) {
            return 0.0;
        }
        int i2 = 1;
        if (this.verbose) {
            System.err.println("\tLabels:");
            System.err.println("\t\t'+' : OK");
            System.err.println("\t\t'.' : Missing");
            System.err.println("\t\t'*' : Error");
            System.out.print((chr != null ? chr : "") + "\t");
        }
        int countNotFound = 0;
        int countOk = 0;
        int countErrors = 0;
        for (Transcript tr : trList) {
            char status = ' ';
            String protein = tr.protein();
            String proteinReference = this.proteinById.get(tr.getId());
            if (proteinReference == null && tr.hasProteinId()) {
                proteinReference = this.proteinById.get(tr.getProteinId());
            }
            if (proteinReference == null) {
                if (tr.isProteinCoding()) {
                    status = '.';
                    if (this.debug) {
                        Log.warningln("Cannot find Protein for transcript " + tr.getId());
                    }
                }
            } else if (this.equals(protein, proteinReference)) {
                status = '+';
            } else {
                status = '*';
                if (this.debug || this.storeAlignments || onlyOneError) {
                    protein = this.proteinFormat(protein);
                    proteinReference = this.proteinFormat(proteinReference);
                    SmithWaterman sw = new SmithWaterman(protein, proteinReference);
                    if (Math.max(protein.length(), proteinReference.length()) < SnpEffCmdCds.MAX_ALIGN_LENGTH) {
                        sw.align();
                    }
                    if (this.storeAlignments) {
                        this.alignmentByTrId.put(tr.getId(), sw);
                    }
                    int maxScore = Math.min(protein.length(), proteinReference.length());
                    int score = sw.getAlignmentScore();
                    if (this.debug || onlyOneError) {
                        Log.infoln("\nERROR: Proteins do not match for transcript " + tr.getId() + "\tStrand:" + (tr.isStrandPlus() ? "+" : "-") + "\tExons: " + tr.numChilds() + "\n" + String.format("\tSnpEff protein     (%6d) : '%s'\n", protein.length(), protein) + String.format("\tReference protein  (%6d) : '%s'\n", proteinReference.length(), proteinReference) + "\tAlignment (Snpeff protein vs Reference protein).\tScore: " + score + "\tMax. possible score: " + maxScore + "\tDiff: " + (maxScore - score) + "\n" + String.valueOf(sw));
                        Log.info("Transcript details:\n" + String.valueOf(tr));
                    }
                }
                if (onlyOneError) {
                    Log.info("Transcript details:\n" + String.valueOf(tr));
                    throw new RuntimeException("DIE");
                }
            }
            boolean ok = false;
            switch (status) {
                case '.': {
                    ++countNotFound;
                    break;
                }
                case '+': {
                    ++countOk;
                    ok = true;
                    if (!this.debug) break;
                    System.out.println("\nFASTA_PROTEIN_OK\t>" + tr.getId() + "\nFASTA_PROTEIN_OK\t" + proteinReference);
                    break;
                }
                case '*': {
                    ++countErrors;
                    if (!this.debug) break;
                    System.out.println("\nFASTA_PROTEIN_ERROR\t>" + tr.getId() + "\nFASTA_PROTEIN_ERROR\t" + proteinReference);
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown status '" + status + "'");
                }
            }
            if (ok && updateTranscriptAaCheck) {
                tr.setAaCheck(true);
            }
            if (!this.verbose || status == 32) continue;
            System.out.print(status);
            if (++i2 % 100 != 0) continue;
            System.out.print("\n\t");
        }
        double errorRate = (double)countErrors / (double)(countErrors + countOk);
        if (this.verbose) {
            Log.info("\n");
        }
        System.out.println("\tProtein check:\t" + this.genome.getVersion() + (String)(chr != null ? "\tChromosome: " + chr : "") + (String)(chr != null ? "\tCodon table: " + CodonTables.getInstance().getTable(this.genome, chr).getName() : "") + "\tOK: " + countOk + "\tNot found: " + countNotFound + "\tErrors: " + countErrors + "\tError percentage: " + 100.0 * errorRate + "%");
        if (addTotals) {
            this.totalNotFound += countNotFound;
            this.totalOk += countOk;
            this.totalErrors += countErrors;
        } else if (this.checkNumOk && this.totalOk <= 0) {
            this.fatalErrorNoTranscriptsChecked();
        }
        return errorRate;
    }

    String proteinFormat(String protein) {
        int idxLast;
        if (protein.isEmpty()) {
            return "";
        }
        char lastChar = (protein = protein.toUpperCase()).charAt(idxLast = protein.length() - 1);
        if (lastChar == '*' || lastChar == '?') {
            protein = protein.substring(0, idxLast);
        }
        if ((protein = protein.replace('X', '?')).startsWith("?")) {
            protein = protein.substring(1);
        }
        return protein;
    }

    void readProteinFile() {
        if (this.verbose) {
            Log.info("Reading proteins from file '" + this.proteinFile + "'...");
        }
        this.proteinById = new HashMap<String, String>();
        if (this.proteinFile.endsWith("txt") || this.proteinFile.endsWith("txt.gz")) {
            this.readProteinFileTxt();
        } else if (this.proteinFile.endsWith(".gbk")) {
            this.readProteinFileGenBank();
        } else if (this.proteinFile.endsWith(".embl")) {
            this.readProteinFileEmbl();
        } else {
            this.readProteinFileFasta();
        }
        if (this.verbose) {
            Log.info("done (" + this.proteinById.size() + " Proteins).");
        }
    }

    void readProteinFileEmbl() {
        EmblFile featuresFile = new EmblFile(this.proteinFile);
        this.readProteinFileFeatures(featuresFile);
    }

    void readProteinFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.proteinFile);
        for (String seq : ffi) {
            String fastaId = ffi.getIdFromFastaHeader();
            this.add(fastaId, seq, ffi.getLineNum(), true);
            List<String> ids = ffi.fastaHeader2Ids();
            for (String id : ids) {
                this.add(id, seq, ffi.getLineNum(), false);
            }
        }
    }

    void readProteinFileFeatures(FeaturesFile featuresFile) {
        for (Features features : featuresFile) {
            String trIdPrev = null;
            for (Feature f : features.getFeatures()) {
                if (f.getType() == Feature.Type.GENE) {
                    trIdPrev = null;
                    continue;
                }
                if (f.getType() == Feature.Type.MRNA) {
                    trIdPrev = f.getTranscriptId();
                    continue;
                }
                if (f.getType() != Feature.Type.CDS) continue;
                String trId = trIdPrev;
                if (trId == null) {
                    trId = f.getTranscriptId();
                }
                String seq = f.getAasequence();
                if (this.debug) {
                    Log.debug(trId + "\t" + seq);
                }
                if (trId == null || seq == null) continue;
                this.add(trId, seq, -1, true);
            }
        }
    }

    void readProteinFileGenBank() {
        GenBankFile featuresFile = new GenBankFile(this.proteinFile);
        this.readProteinFileFeatures(featuresFile);
    }

    void readProteinFileTxt() {
        String proteinData = Gpr.readFile(this.proteinFile);
        String[] proteinLines = proteinData.split("\n");
        int lineNum = 1;
        for (String proteinLine : proteinLines) {
            String[] field = proteinLine.split("\\s+");
            if (field.length >= 2) {
                String seq = field[1].trim();
                String trId = field[0].trim();
                this.add(trId, seq, lineNum, true);
            }
            ++lineNum;
        }
    }

    String replaceUnknownAa(String protein, String proteinRef) {
        char[] pref;
        char[] p = protein.toCharArray();
        if (p.length != (pref = proteinRef.toCharArray()).length) {
            return protein;
        }
        for (int i2 = 0; i2 < p.length; ++i2) {
            if (p[i2] != '?' || pref[i2] == '?') continue;
            p[i2] = pref[i2];
        }
        return new String(p);
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Log.info("Checking database using protein sequences");
        }
        this.loadConfig();
        if (this.proteinById == null) {
            this.readProteinFile();
        }
        this.loadDb();
        return this.checkProteins();
    }

    String sampleTrIds(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Gene g : this.config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                sb.append("\t'" + tr.getId() + "'\n");
                if (count++ <= maxTrIds) continue;
                return sb.toString();
            }
        }
        return sb.toString();
    }

    String sampleTrIdsFasta(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String trid : this.proteinById.keySet()) {
            sb.append("\t'" + trid + "'\n");
            if (count++ <= maxTrIds) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public void setCheckNumOk(boolean checkNumOk) {
        this.checkNumOk = checkNumOk;
    }

    void setCodonTable(Chromosome chromo, CodonTable codonTable) {
        CodonTables.getInstance().set(this.genome, chromo, codonTable);
        for (Transcript tr : (List)this.trByChromo.get(chromo.getId())) {
            tr.resetCache();
        }
    }

    public void setProteinByTrId(Map<String, String> proteinById) {
        this.proteinById = proteinById;
    }

    public void setMaxErrorRate(double maxErrorRate) {
        this.maxErrorRate = maxErrorRate;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff protein [options] genome_version proteing_file");
        System.err.println("\nOptions:");
        System.err.println("\t-codonTables    : Try all codon tables on each chromosome and calculate error rates.");
        System.exit(-1);
    }
}

