/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.List;
import org.snpeff.SnpEff;
import org.snpeff.pdb.DistanceResult;
import org.snpeff.pdb.ProteinInteractions;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class SnpEffCmdPdb
extends SnpEff {
    ProteinInteractions proteinInteractions;

    public List<DistanceResult> getDistanceResults() {
        return this.proteinInteractions.getDistanceResults();
    }

    public void initialize() {
        String[] argsSnpEff = new String[]{"eff", "-c", this.configFile, this.genomeVer};
        this.args = argsSnpEff;
        this.setGenomeVer(this.genomeVer);
        this.parseArgs(argsSnpEff);
        this.loadConfig();
        if (this.genomeVer != null) {
            Log.info("Loading SnpEff's database: " + this.genomeVer);
            this.loadDb();
            Log.info("Done.");
        }
    }

    @Override
    public void parseArgs(String[] args) {
        this.proteinInteractions = new ProteinInteractions();
        this.proteinInteractions.setVerbose(this.verbose);
        this.proteinInteractions.setDebug(this.debug);
        if (args == null) {
            return;
        }
        this.args = args;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                arg = arg.toLowerCase();
                switch (arg.toLowerCase()) {
                    case "-aasep": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setAaMinSeparation(Gpr.parseIntSafe(args[++i2]));
                            break;
                        }
                        this.usage("Missing parameter in '-aaSep'");
                        break;
                    }
                    case "-idmap": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setIdMapFile(args[++i2]);
                            break;
                        }
                        this.usage("Missing parameter in '-idMap'");
                        break;
                    }
                    case "-maxdist": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setDistanceThreshold(Gpr.parseDoubleSafe(args[++i2]));
                            break;
                        }
                        this.usage("Missing parameter in '-maxDist'");
                        break;
                    }
                    case "-maxerr": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setMaxMismatchRate(Gpr.parseDoubleSafe(args[++i2]));
                            break;
                        }
                        this.usage("Missing parameter: '-maxErr'");
                        break;
                    }
                    case "-org": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setPdbOrganismCommon(args[++i2].toUpperCase());
                            break;
                        }
                        this.usage("Missing parameter in '-org'");
                        break;
                    }
                    case "-orgscientific": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setPdbOrganismScientific(args[++i2].toUpperCase());
                            break;
                        }
                        this.usage("Missing parameter in '-orgScientific'");
                        break;
                    }
                    case "-pdbdir": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setPdbDir(args[++i2]);
                            break;
                        }
                        this.usage("Missing parameter in '-pdbDir'");
                        break;
                    }
                    case "-res": {
                        if (i2 + 1 < args.length) {
                            this.proteinInteractions.setPdbResolution(Gpr.parseDoubleSafe(args[++i2]));
                            break;
                        }
                        this.usage("Missing parameter: '-res'");
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer != null && !this.genomeVer.isEmpty()) continue;
            this.genomeVer = arg;
            this.proteinInteractions.setGenomeVer(this.genomeVer);
        }
        String check = this.proteinInteractions.checkParams();
        if (check != null) {
            this.usage(check);
        }
    }

    @Override
    public boolean run() {
        return this.run(false);
    }

    public boolean run(boolean storeResults) {
        this.loadConfig();
        this.proteinInteractions.initialize(this.config);
        this.loadDb();
        this.proteinInteractions.run(storeResults);
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
            System.err.println("Command line :\t" + this.commandLineStr(false) + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff pdb [options] genome_version");
        System.err.println("\n");
        System.err.println("\nOptions:");
        System.err.println("\t-aaSep <number>                 : Minimum number of AA of separation within the sequence. Default: " + this.proteinInteractions.getAaMinSeparation());
        System.err.println("\t-idMap <file>                   : ID map file (i.e. file containing mapping from PDB ID to transcript ID). Default: " + this.proteinInteractions.getIdMapFile());
        System.err.println("\t-maxDist <number>               : Maximum distance in Angstrom for any atom in a pair of amino acids to be considered 'in contact'. Default: " + this.proteinInteractions.getDistanceThreshold());
        System.err.println("\t-maxErr <number>                : Maximum amino acid sequence difference between PDB file and genome. Default: " + this.proteinInteractions.getMaxMismatchRate());
        System.err.println("\t-org <name>                     : Organism 'common name'. Default: " + this.proteinInteractions.getPdbOrganismCommon());
        System.err.println("\t-orgScientific <name>           : Organism 'scientific name'. Default: " + this.proteinInteractions.getPdbOrganismScientific());
        System.err.println("\t-pdbDir <path>                  : Path to PDB files (files in all sub-dirs are scanned).");
        System.err.println("\t-res <number>                   : Maximum PDB file resolution. Default: " + this.proteinInteractions.getPdbResolution());
        this.usageGenericAndDb();
        System.exit(-1);
    }
}

