/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.SnpEff;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.geneSets.GeneSets;
import org.snpeff.geneSets.GeneSetsRanked;
import org.snpeff.geneSets.GeneStats;
import org.snpeff.geneSets.algorithm.EnrichmentAlgorithm;
import org.snpeff.geneSets.algorithm.EnrichmentAlgorithmGreedyVariableSize;
import org.snpeff.geneSets.algorithm.FisherPValueAlgorithm;
import org.snpeff.geneSets.algorithm.FisherPValueGreedyAlgorithm;
import org.snpeff.geneSets.algorithm.LeadingEdgeFractionAlgorithm;
import org.snpeff.geneSets.algorithm.NoneAlgorithm;
import org.snpeff.geneSets.algorithm.RankSumPValueAlgorithm;
import org.snpeff.geneSets.algorithm.RankSumPValueGreedyAlgorithm;
import org.snpeff.gsa.ChrPosScoreList;
import org.snpeff.gsa.PvaluesList;
import org.snpeff.gsa.ScoreList;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantWithScore;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;

public class SnpEffCmdGsa
extends SnpEff {
    public static int READ_INPUT_SHOW_EVERY = 1000;
    public static int MAX_WARNS = 20;
    SnpEff.InputFormat inputFormat = SnpEff.InputFormat.VCF;
    boolean useClosestGene = false;
    boolean useGeneId = false;
    boolean usePvalues = true;
    boolean removeUnusedSets = false;
    boolean orderDescending = false;
    int upDownStreamLength = 5000;
    int minGeneSetSize = 0;
    int maxGeneSetSize = Integer.MAX_VALUE;
    int numberofGeneSetsToSelect = 20;
    int initGeneSetSize = 100;
    int randIterations = 0;
    double maxPvalueAdjusted = 0.05;
    double maxPvalue = Double.NaN;
    double interestingPerc = 0.05;
    String inputFile = "";
    String infoName = "";
    String msigdb = "";
    String geneScoreFile = "";
    String geneScoreFileSave = null;
    String commandsFile = null;
    String geneInterestingFile = "";
    String saveFile = null;
    String correctionCmd = null;
    ScoreList.ScoreSummary scoreSummary = ScoreList.ScoreSummary.MIN;
    SnpEffectPredictor snpEffectPredictor;
    Genome genome;
    GeneSets geneSets;
    ChrPosScoreList chrPosScoreList;
    AutoHashMap<String, ScoreList> geneScores;
    HashMap<String, Double> geneScore;
    HashSet<String> genesInteresting;
    EnrichmentAlgorithm.EnrichmentAlgorithmType enrichmentAlgorithmType = EnrichmentAlgorithm.EnrichmentAlgorithmType.RANKSUM_GREEDY;

    protected void config() {
        this.loadConfig();
        if (this.geneScoreFile.isEmpty() && this.geneInterestingFile.isEmpty()) {
            this.loadDb();
            SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
            snpEffectPredictor.setUpDownStreamLength(this.upDownStreamLength);
            if (this.verbose) {
                Log.info("Building interval forest");
            }
            snpEffectPredictor.buildForest();
            if (this.verbose) {
                Log.info("done.");
            }
        }
    }

    void correctScores() {
        String[] lines;
        Object residuesFile;
        String scoresFile = this.geneScoreFileSave;
        try {
            if (this.geneScoreFileSave == null) {
                scoresFile = File.createTempFile("geneScoreFile_in_", ".txt").getCanonicalPath();
                residuesFile = File.createTempFile("geneScoreFile_out_", ".txt").getCanonicalPath();
                new File(scoresFile).deleteOnExit();
                new File((String)residuesFile).deleteOnExit();
            } else {
                residuesFile = Gpr.dirName(this.geneScoreFileSave) + "/" + Gpr.baseName(this.geneScoreFileSave) + ".corrected.txt";
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.correctionCmd == null || this.geneScores.isEmpty()) {
            if (this.geneScoreFileSave != null) {
                this.createScoresFile(this.geneScoreFileSave, false);
                this.createScoresFile((String)residuesFile, true);
            }
            return;
        }
        this.createScoresFile(scoresFile, false);
        String commandLine = this.correctionCmd + " " + scoresFile + " " + (String)residuesFile;
        try {
            if (this.verbose) {
                Log.info("Correction: Invoking command " + commandLine);
            }
            Process process = Runtime.getRuntime().exec(commandLine);
            process.waitFor();
            if (process.exitValue() > 0) {
                throw new RuntimeException("Process execution error, exit value '" + process.exitValue() + "'\n\tCommand line:\t" + commandLine);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing command: " + commandLine, e);
        }
        if (this.verbose) {
            Log.info("Correction: Reading results from file '" + (String)residuesFile + "'");
        }
        if (!Gpr.canRead((String)residuesFile)) {
            throw new RuntimeException("Cannot read correction's results from file '" + (String)residuesFile + "'");
        }
        this.geneScore = new HashMap();
        for (String line : lines = Gpr.readFile((String)residuesFile).split("\n")) {
            String[] recs = line.split("\t");
            String geneId = recs[0];
            double score = Gpr.parseDoubleSafe(recs[1]);
            this.geneScore.put(geneId, score);
        }
        if (this.verbose) {
            Log.info("Correction: Done, " + lines.length + " values added.");
        }
    }

    void createInterestingGenes() {
        if (!this.geneInterestingFile.isEmpty()) {
            this.createInterestingGenesFile();
        } else {
            this.createInterestingGenesScores();
        }
    }

    void createInterestingGenesFile() {
        int hasGene = 0;
        for (String geneId : this.genesInteresting) {
            if (this.geneSets.hasGene(geneId)) {
                ++hasGene;
            }
            this.geneSets.addInteresting(geneId);
        }
        if (this.verbose) {
            Log.info("Intereting genes from file\n\tIntereting genes in file  : " + this.genesInteresting.size() + "\n\tFound genes               : " + hasGene);
        }
    }

    void createInterestingGenesScores() {
        ScoreList scores = new ScoreList();
        for (double pval : this.geneScore.values()) {
            scores.add(pval);
        }
        double quantile = this.interestingPerc;
        if (this.orderDescending) {
            quantile = 1.0 - this.interestingPerc;
        }
        double scoreThreshold = scores.quantile(quantile);
        int count = 0;
        int countAdded = 0;
        this.geneSets.setDoNotAddIfNotInGeneSet(true);
        for (String geneId : this.geneScore.keySet()) {
            if (!(this.orderDescending && this.geneScore.get(geneId) >= scoreThreshold) && (this.orderDescending || !(this.geneScore.get(geneId) <= scoreThreshold))) continue;
            if (this.geneSets.addInteresting(geneId)) {
                ++countAdded;
            }
            ++count;
        }
        if (this.verbose) {
            double realPerc = 100.0 * (double)count / (double)this.geneScore.size();
            double realPercAdded = 100.0 * (double)countAdded / (double)this.geneScore.size();
            Log.info(String.format("Score threshold:\n\tRange                    : [ %f , %f ]\n\tQuantile                 : %.2f%%\n\tThreshold                : %f\n\tInteresting genes        : %d  (%.2f%%)\n\tInteresting genes added  : %d  (%.2f%%)", scores.min(), scores.max(), 100.0 * this.interestingPerc, scoreThreshold, count, realPerc, countAdded, realPercAdded));
        }
    }

    void createScoresFile(String fileName, boolean scoresOnly) {
        StringBuilder scores = new StringBuilder();
        if (this.geneScoreFileSave != null) {
            scores.append("geneId\tscore");
            if (!scoresOnly) {
                scores.append("\tscoreCount\t" + new GeneStats().title() + "\n");
            }
            scores.append("\n");
        }
        AutoHashMap<String, GeneStats> genesStats = new AutoHashMap<String, GeneStats>(new GeneStats());
        for (Gene gene : this.genome.getGenes()) {
            String geneName = this.useGeneId ? gene.getId() : gene.getGeneName();
            genesStats.getOrCreate(geneName).add(gene, this.useGeneId);
        }
        for (String geneId : this.geneScores.keySet()) {
            ScoreList gpl = (ScoreList)this.geneScores.get(geneId);
            double score = gpl.score(this.scoreSummary);
            scores.append(geneId + "\t" + score);
            if (!scoresOnly) {
                scores.append("\t" + gpl.size() + "\t" + String.valueOf(genesStats.getOrCreate(geneId)));
            }
            scores.append("\n");
        }
        if (this.verbose) {
            Log.info("Saving gene scores to file: '" + fileName + "'");
        }
        Gpr.toFile(fileName, scores);
    }

    void enrichmentAnalysis() {
        GeneSetsRanked geneSetsRanked = null;
        if (this.geneScore != null) {
            for (String geneId : this.geneScore.keySet()) {
                this.geneSets.setValue(geneId, this.geneScore.get(geneId));
            }
            this.geneSets.setVerbose(this.verbose);
            if (this.enrichmentAlgorithmType.isRank()) {
                geneSetsRanked = new GeneSetsRanked(this.geneSets);
                geneSetsRanked.rankByValue(!this.orderDescending);
                if (this.removeUnusedSets) {
                    geneSetsRanked.removeUnusedSets();
                }
            } else if (this.removeUnusedSets) {
                this.geneSets.removeUnusedSets();
            }
        }
        EnrichmentAlgorithm algorithm = null;
        switch (this.enrichmentAlgorithmType) {
            case NONE: {
                algorithm = new NoneAlgorithm(this.geneSets);
                break;
            }
            case RANKSUM_GREEDY: {
                algorithm = new RankSumPValueGreedyAlgorithm(geneSetsRanked, this.numberofGeneSetsToSelect);
                break;
            }
            case RANKSUM: {
                algorithm = new RankSumPValueAlgorithm(geneSetsRanked, this.numberofGeneSetsToSelect);
                break;
            }
            case FISHER_GREEDY: {
                algorithm = new FisherPValueGreedyAlgorithm(this.geneSets, this.numberofGeneSetsToSelect);
                break;
            }
            case FISHER: {
                algorithm = new FisherPValueAlgorithm(this.geneSets, this.numberofGeneSetsToSelect);
                break;
            }
            case LEADING_EDGE_FRACTION: {
                algorithm = new LeadingEdgeFractionAlgorithm(this.geneSets, this.numberofGeneSetsToSelect, this.orderDescending);
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented algorithm!");
            }
        }
        if (this.enrichmentAlgorithmType.isBinary()) {
            this.createInterestingGenes();
        }
        algorithm.setMaxGeneSetSize(this.maxGeneSetSize);
        algorithm.setMinGeneSetSize(this.minGeneSetSize);
        algorithm.setMaxPValue(this.maxPvalue);
        algorithm.setMaxPvalueAdjusted(this.maxPvalueAdjusted);
        algorithm.setVerbose(this.verbose);
        algorithm.setDebug(this.debug);
        if (this.enrichmentAlgorithmType.isGreedy()) {
            if (this.debug) {
                Log.debug("Setting initGeneSetSize:" + this.initGeneSetSize);
            }
            ((EnrichmentAlgorithmGreedyVariableSize)algorithm).setInitialSize(this.initGeneSetSize);
        }
        algorithm.select();
        if (this.saveFile != null) {
            if (this.verbose) {
                Log.info("Saving results to '" + this.saveFile + "'");
            }
            Gpr.toFile(this.saveFile, algorithm.getOutput());
        }
    }

    void initialize() {
        if (this.config == null) {
            this.config();
        }
        if (this.geneScoreFile.isEmpty() && this.geneInterestingFile.isEmpty()) {
            this.snpEffectPredictor = this.config.getSnpEffectPredictor();
            this.genome = this.config.getGenome();
        }
        if (this.verbose) {
            Log.info("Reading MSigDb from file: '" + this.msigdb + "'");
        }
        GeneSets geneSets = this.geneSets = this.enrichmentAlgorithmType.isRank() ? new GeneSetsRanked(this.msigdb) : new GeneSets(this.msigdb);
        if (this.verbose) {
            Log.info("Done.\n\t\tGene sets added : " + this.geneSets.getGeneSetCount() + "\n\t\tGenes added     : " + this.geneSets.getGeneCount());
        }
    }

    void mapToGenes() {
        if (this.verbose) {
            Log.info("Mapping scores to genes.");
        }
        this.geneScores = this.usePvalues ? new AutoHashMap(new PvaluesList()) : new AutoHashMap(new ScoreList());
        int unmapped = 0;
        int mappedMultiple = 0;
        for (int i2 = 0; i2 < this.chrPosScoreList.size(); ++i2) {
            List<String> geneIds = this.mapToGenes(this.chrPosScoreList.getChromosomeName(i2), this.chrPosScoreList.getStart(i2), this.chrPosScoreList.getEnd(i2));
            if (geneIds == null || geneIds.isEmpty()) {
                ++unmapped;
                continue;
            }
            if (geneIds.size() > 1) {
                ++mappedMultiple;
            }
            double score = this.chrPosScoreList.getScore(i2);
            for (String geneId : geneIds) {
                ScoreList gpl = this.geneScores.getOrCreate(geneId);
                gpl.setGeneId(geneId);
                gpl.add(score);
            }
        }
        if (this.verbose) {
            Log.info("Done:\n\tNumber of scores         : " + this.chrPosScoreList.size() + "\n\tUnmapped                 : " + unmapped + "\n\tMapped to multiple genes : " + mappedMultiple);
        }
        if (this.debug) {
            System.err.println("Mapping Gene to Score:");
            ArrayList geneIds = new ArrayList(this.geneScores.keySet());
            Collections.sort(geneIds);
            for (String geneId : geneIds) {
                System.err.println("\t" + String.valueOf(this.geneScores.get(geneId)));
            }
        }
    }

    List<String> mapToGenes(String chr, int start, int end) {
        LinkedList<String> geneIds = new LinkedList<String>();
        Marker m = new Marker(this.genome.getChromosome(chr), start, end, false, "");
        if (this.useClosestGene) {
            Gene gene = this.snpEffectPredictor.queryClosestGene(m);
            if (gene != null) {
                geneIds.add(this.useGeneId ? gene.getId() : gene.getGeneName());
            }
            return geneIds;
        }
        Markers hits = this.snpEffectPredictor.query(m);
        for (Marker mm : hits) {
            if (!(mm instanceof Gene)) continue;
            Gene gene = (Gene)mm;
            geneIds.add(this.useGeneId ? gene.getId() : gene.getGeneName());
        }
        return geneIds;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                if (arg.equals("-i")) {
                    if (i2 + 1 < args.length) {
                        this.inputFormat = SnpEff.InputFormat.valueOf(args[++i2].toUpperCase());
                        continue;
                    }
                    this.usage("Missing input format in command line option '-i'");
                    continue;
                }
                if (arg.equals("-info")) {
                    if (i2 + 1 < args.length) {
                        this.infoName = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-info'");
                    continue;
                }
                if (arg.equals("-ud") || arg.equalsIgnoreCase("-upDownStreamLen")) {
                    if (i2 + 1 < args.length) {
                        this.upDownStreamLength = Gpr.parseIntSafe(args[++i2]);
                        continue;
                    }
                    this.usage("Missing value in command line option '-ud'");
                    continue;
                }
                if (arg.equals("-geneScore")) {
                    if (i2 + 1 < args.length) {
                        String method = args[++i2].toUpperCase();
                        this.scoreSummary = ScoreList.ScoreSummary.valueOf(method);
                        continue;
                    }
                    this.usage("Missing value in command line option '-geneScore'");
                    continue;
                }
                if (arg.equals("-algo")) {
                    if (i2 + 1 < args.length) {
                        String algo = args[++i2].toUpperCase();
                        this.enrichmentAlgorithmType = EnrichmentAlgorithm.EnrichmentAlgorithmType.valueOf(algo);
                        continue;
                    }
                    this.usage("Missing value in command line option '-algo'");
                    continue;
                }
                if (arg.equals("-geneScoreFile")) {
                    if (i2 + 1 < args.length) {
                        this.geneScoreFile = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-geneScoreFile'");
                    continue;
                }
                if (arg.equals("-saveGeneScoreFile")) {
                    if (i2 + 1 < args.length) {
                        this.geneScoreFileSave = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-saveGeneScoreFile'");
                    continue;
                }
                if (arg.equals("-commands")) {
                    if (i2 + 1 < args.length) {
                        this.commandsFile = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-commands'");
                    continue;
                }
                if (arg.equals("-save")) {
                    if (i2 + 1 < args.length) {
                        this.saveFile = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-save'");
                    continue;
                }
                if (arg.equals("-correction")) {
                    if (i2 + 1 < args.length) {
                        this.correctionCmd = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-correction'");
                    continue;
                }
                if (arg.equals("-maxPvalue")) {
                    if (i2 + 1 < args.length) {
                        this.maxPvalue = Gpr.parseDoubleSafe(args[++i2]);
                        continue;
                    }
                    this.usage("Missing value in command line option '-maxPvalue'");
                    continue;
                }
                if (arg.equals("-maxPvalueAdj")) {
                    if (i2 + 1 < args.length) {
                        this.maxPvalueAdjusted = Gpr.parseDoubleSafe(args[++i2]);
                        continue;
                    }
                    this.usage("Missing value in command line option '-maxPvalueAdj'");
                    continue;
                }
                if (arg.equals("-geneInterestingFile")) {
                    if (i2 + 1 < args.length) {
                        this.geneInterestingFile = args[++i2];
                        continue;
                    }
                    this.usage("Missing value in command line option '-geneScoreFile'");
                    continue;
                }
                if (arg.equals("-minSetSize")) {
                    this.minGeneSetSize = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (arg.equals("-maxSetSize")) {
                    this.maxGeneSetSize = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (arg.equals("-initSetSize")) {
                    this.initGeneSetSize = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (arg.equals("-rand")) {
                    this.randIterations = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (arg.equals("-interesting")) {
                    this.interestingPerc = Gpr.parseDoubleSafe(args[++i2]);
                    continue;
                }
                if (arg.equals("-mapClosestGene")) {
                    this.useClosestGene = true;
                    continue;
                }
                if (arg.equals("-geneId")) {
                    this.useGeneId = true;
                    continue;
                }
                if (arg.equals("-score")) {
                    this.usePvalues = false;
                    continue;
                }
                if (arg.equals("-desc")) {
                    this.orderDescending = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.msigdb.isEmpty()) {
                this.msigdb = arg;
                continue;
            }
            if (!this.inputFile.isEmpty()) continue;
            this.inputFile = arg;
        }
        if (this.genomeVer.isEmpty() && this.geneScoreFile.isEmpty() && this.geneInterestingFile.isEmpty()) {
            this.usage("Missing genome version.");
        }
        if (this.commandsFile == null) {
            if (this.inputFormat == SnpEff.InputFormat.VCF && this.infoName.isEmpty() && this.geneScoreFile.isEmpty() && this.geneInterestingFile.isEmpty()) {
                this.usage("Missing '-info' comamnd line option.");
            }
            if (this.inputFile.isEmpty()) {
                this.inputFile = "-";
            }
            if (!Gpr.canRead(this.inputFile)) {
                Log.fatalError("Cannot read input file '" + this.inputFile + "'");
            }
            if (this.msigdb.isEmpty()) {
                Log.fatalError("Missing Gene-Sets file");
            }
            if (!Gpr.canRead(this.msigdb)) {
                Log.fatalError("Cannot read Gene-Sets file '" + this.msigdb + "'");
            }
            if (this.maxGeneSetSize <= 0) {
                this.usage("MaxSetSize must be a positive number.");
            }
            if (this.minGeneSetSize >= this.maxGeneSetSize) {
                this.usage("MaxSetSize (" + this.maxGeneSetSize + ") must larger than MinSetSize (" + this.minGeneSetSize + ").");
            }
            if (this.interestingPerc < 0.0 || this.interestingPerc > 1.0) {
                this.usage("Interesting percentile must be in the [0 , 1.0] range.");
            }
            if (!this.geneInterestingFile.isEmpty() && !this.enrichmentAlgorithmType.isBinary()) {
                this.usage("Cannot specify '-geneInterestingFile' using algorithm '" + String.valueOf((Object)this.enrichmentAlgorithmType) + "'");
            }
        } else if (!Gpr.canRead(this.commandsFile)) {
            Log.fatalError("Cannot read commands file '" + this.commandsFile + "'");
        }
    }

    void readGeneInteresting(String geneScoreFile) {
        if (this.verbose) {
            Log.info("Reading interesting genes file '" + this.geneInterestingFile + "'");
        }
        String[] lines = Gpr.readFile(geneScoreFile).split("\n");
        this.genesInteresting = new HashSet();
        for (String g : lines) {
            this.genesInteresting.add(g.trim());
        }
        if (this.verbose) {
            Log.info("Done. Added: " + this.genesInteresting.size());
        }
    }

    void readGeneScores(String geneScoreFile) {
        if (this.verbose) {
            Log.info("Reading gene scores file '" + geneScoreFile + "'");
        }
        this.geneScore = new HashMap();
        String[] lines = Gpr.readFile(geneScoreFile).split("\n");
        double minp = Double.POSITIVE_INFINITY;
        double maxp = Double.NEGATIVE_INFINITY;
        for (String line : lines) {
            String[] rec = line.split("\\s");
            String geneId = rec[0].trim();
            double score = Gpr.parseDoubleSafe(rec[1]);
            if (score > 0.0 && score <= 1.0) {
                this.geneScore.put(geneId, score);
                minp = Math.min(minp, score);
                maxp = Math.max(maxp, score);
                continue;
            }
            if (!this.verbose) continue;
            Log.info("\tWarning: Ignoring entry (zero p-value):\t'" + line + "'");
        }
        if (this.verbose) {
            Log.info("Done.\n\tScores added        : " + this.geneScore.size() + "\n\tMin score (p-value) : " + minp + "\n\tMax score (p-value) : " + maxp);
        }
    }

    void readInput() {
        if (this.verbose) {
            Log.info("Reading input file '" + this.inputFile + "' (format '" + String.valueOf((Object)this.inputFormat) + "')");
        }
        switch (this.inputFormat) {
            case VCF: {
                this.chrPosScoreList = this.readInputVcf();
                break;
            }
            case BED: {
                this.chrPosScoreList = this.readInputBed();
                break;
            }
            default: {
                Log.fatalError("Input format '" + String.valueOf((Object)this.inputFormat) + "' not supported!");
            }
        }
        if (this.verbose) {
            System.err.println("");
            Log.info("Done.");
        }
        if (this.debug) {
            System.err.println("scores:\n\tchr\tstart\tend\tp_value");
            for (int i2 = 0; i2 < this.chrPosScoreList.size(); ++i2) {
                System.err.println("\t" + this.chrPosScoreList.getChromosomeName(i2) + "\t" + this.chrPosScoreList.getStart(i2) + "\t" + this.chrPosScoreList.getEnd(i2) + "\t" + this.chrPosScoreList.getScore(i2));
            }
        }
    }

    ChrPosScoreList readInputBed() {
        ChrPosScoreList cppList = new ChrPosScoreList();
        int num = 1;
        BedFileIterator bfi = new BedFileIterator(this.inputFile);
        for (Variant sc : bfi) {
            cppList.add(sc.getChromosome(), sc.getStart(), sc.getEnd(), ((VariantWithScore)sc).getScore());
            if (!this.verbose) continue;
            Gpr.showMark(num++, READ_INPUT_SHOW_EVERY);
        }
        return cppList;
    }

    ChrPosScoreList readInputTxt() {
        ChrPosScoreList cppList = new ChrPosScoreList();
        Genome genome = this.config.getGenome();
        int num = 1;
        LineFileIterator lfi = new LineFileIterator(this.inputFile);
        for (String line : lfi) {
            if (line.startsWith("#")) continue;
            String[] fields = line.split("\t");
            if (fields.length < 3) {
                System.err.println("Warning: Ignoring line number " + lfi.getLineNum() + ". Exepcting format 'chr \t pos \t score \n'.\n\tLine:\t'" + line + "'");
                continue;
            }
            String chr = fields[0];
            int start = Gpr.parseIntSafe(fields[1]);
            double score = Gpr.parseDoubleSafe(fields[2]);
            Chromosome chromo = genome.getOrCreateChromosome(chr);
            cppList.add(chromo, start, start, score);
            if (!this.verbose) continue;
            Gpr.showMark(num++, READ_INPUT_SHOW_EVERY);
        }
        return cppList;
    }

    ChrPosScoreList readInputVcf() {
        ChrPosScoreList cppList = new ChrPosScoreList();
        int num = 1;
        int warns = 0;
        VcfFileIterator vcf = new VcfFileIterator(this.inputFile);
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            double score = ve.getInfoFloat(this.infoName);
            if (Double.isNaN(score)) {
                if (warns <= MAX_WARNS) {
                    System.err.println("Warning: Cannot find INFO field '" + this.infoName + "'. Ignoring VCF entry " + vcf.getLineNum() + "\t" + String.valueOf(ve));
                    if (warns == MAX_WARNS) {
                        System.err.println("Too many warnings! No more warnings shown.");
                    }
                }
                ++warns;
            } else {
                cppList.add(ve.getChromosome(), ve.getStart(), ve.getEnd(), score);
            }
            if (!this.verbose) continue;
            Gpr.showMark(num++, READ_INPUT_SHOW_EVERY);
        }
        return cppList;
    }

    @Override
    public boolean run() {
        if (this.commandsFile == null) {
            return this.runAnalisis();
        }
        return this.runCommands();
    }

    protected boolean runAnalisis() {
        this.initialize();
        if (this.geneScoreFile.isEmpty() && this.geneInterestingFile.isEmpty()) {
            this.readInput();
            this.mapToGenes();
            this.scoreGenes();
            this.correctScores();
        } else if (!this.geneScoreFile.isEmpty()) {
            this.readGeneScores(this.geneScoreFile);
            this.correctScores();
        } else if (!this.geneInterestingFile.isEmpty()) {
            this.readGeneInteresting(this.geneInterestingFile);
        }
        this.enrichmentAnalysis();
        if (this.randIterations > 0) {
            this.runAnalisisRand();
        }
        if (this.verbose) {
            Log.info("Done.");
        }
        return true;
    }

    protected boolean runAnalisisRand() {
        HashMap<String, Double> geneScoreOri = this.geneScore;
        for (int iter = 1; iter <= this.randIterations; ++iter) {
            Log.info("Random scores. Iteration " + iter);
            this.geneScore = new HashMap();
            for (String gene : geneScoreOri.keySet()) {
                this.geneScore.put(gene, Math.random());
            }
            this.enrichmentAnalysis();
        }
        this.geneScore = geneScoreOri;
        if (this.verbose) {
            Log.info("Done.");
        }
        return true;
    }

    protected boolean runCommands() {
        boolean ok = true;
        this.config();
        for (String commnadLine : Gpr.readFile(this.commandsFile).split("\n")) {
            if (this.verbose) {
                Log.info("COMMAND: " + commnadLine);
                System.out.println("COMMAND: " + commnadLine);
            }
            String[] args = commnadLine.split("\t");
            SnpEffCmdGsa snpEffCmdGsa = new SnpEffCmdGsa();
            snpEffCmdGsa.setConfig(this.config);
            StringBuilder err = new StringBuilder();
            ok &= this.run(snpEffCmdGsa, args, err);
        }
        if (this.verbose) {
            Log.info("Done!");
        }
        return ok;
    }

    void scoreGenes() {
        if (this.verbose) {
            Log.info("Aggregating scores by gene (scoring genes)");
        }
        double scoreMin = Double.MAX_VALUE;
        double scoreMax = Double.MIN_VALUE;
        this.geneScore = new HashMap();
        for (String geneId : this.geneScores.keySet()) {
            ScoreList gpl = (ScoreList)this.geneScores.get(geneId);
            double score = gpl.score(this.scoreSummary);
            scoreMax = Math.max(score, scoreMax);
            scoreMin = Math.min(score, scoreMin);
            this.geneScore.put(geneId, score);
        }
        if (this.verbose) {
            Log.info("Done. Score range: [ " + scoreMin + " , " + scoreMax + " ]");
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff gsa [options] genome_version geneSets.gmt [input_file]");
        System.err.println("\n\tInput data options:");
        System.err.println("\t-commands <file>              : Read commands from file (allows multiple analysis loading the database only once).");
        System.err.println("\t-geneId                       : Use geneID instead of gene names. Default: " + this.useGeneId);
        System.err.println("\t-i <format>                   : Input format {vcf, bed, txt}. Default: " + String.valueOf((Object)this.inputFormat));
        System.err.println("\t-info <name>                  : INFO tag used for scores (in VCF input format).");
        System.err.println("\t-desc                         : Sort scores in descending order (high score are better then low scores). Default " + this.orderDescending);
        System.err.println("\t-save <file>                  : Save results to file.");
        System.err.println("\t-score                        : Treat input data as scores instead of p-values.");
        System.err.println("\n\tAlgorithm options:");
        System.err.println("\t-algo <name>                  : Gene set enrichment algorithm {FISHER_GREEDY, RANKSUM_GREEDY, FISHER, RANKSUM, LEADING_EDGE_FRACTION, NONE}. Default: " + String.valueOf((Object)this.enrichmentAlgorithmType));
        System.err.println("\t-correction <cmd>             : Correction of scores using command 'cmd' (e.g. an R script).");
        System.err.println("\t-geneScore                    : Method to summarize gene scores {MIN, MAX, AVG, AVG_MIN_10, AVG_MAX_10, FISHER_CHI_SQUARE, Z_SCORES, SIMES}. Default: " + String.valueOf((Object)this.scoreSummary));
        System.err.println("\t-geneScoreFile <file>         : Read gene score from file instead of calculating them. Format: 'geneId \\t score'");
        System.err.println("\t-mapClosestGene               : Map to closest gene. Default: " + this.useClosestGene);
        System.err.println("\t-maxPvalue <num>              : Maximum un-adjusted p-value to show result. Default: None");
        System.err.println("\t-maxPvalueAdj <num>           : Maximum adjusted p-value to show result. Default: " + this.maxPvalueAdjusted);
        System.err.println("\t-saveGeneScoreFile <file>     : Save gene scores to file.");
        System.err.println("\t-rand <num>                   : Perform 'num' iterations using random scores. Default: " + this.randIterations);
        System.err.println("\n\tAlgorithm specific options: FISHER and FISHER_GREEDY");
        System.err.println("\t-interesting <num>            : Consider a gene 'interesting' if the score is in the 'num' percentile. Default: " + this.interestingPerc);
        System.err.println("\t-geneInterestingFile <file>   : Use 'interesting' genes from file instead of calculating them.");
        System.err.println("\n\tGene Set options:");
        System.err.println("\t-minSetSize <num>             : Minimum number of genes in a gene set. Default: " + this.minGeneSetSize);
        System.err.println("\t-maxSetSize <num>             : Maximum number of genes in a gene set. Default: " + this.maxGeneSetSize);
        System.err.println("\t-initSetSize <num>            : Initial number of genes in a gene set (size range algorithm). Default: " + this.initGeneSetSize);
        System.exit(-1);
    }
}

