/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.filter.VariantEffectFilter;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantNonRef;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.outputFormatter.BedAnnotationOutputFormatter;
import org.snpeff.outputFormatter.BedOutputFormatter;
import org.snpeff.outputFormatter.OutputFormatter;
import org.snpeff.outputFormatter.VcfOutputFormatter;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ProteinFastaWriter;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.VcfAnnotator;
import org.snpeff.stats.CountByType;
import org.snpeff.stats.VariantEffectStats;
import org.snpeff.stats.VariantStats;
import org.snpeff.stats.VcfStats;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Timer;
import org.snpeff.util.Tuple;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.Pedigree;
import org.snpeff.vcf.VcfEntry;

public class SnpEffCmdEff
extends SnpEff
implements VcfAnnotator {
    public static final String TEMPLATES_DIR = "src/main/resources";
    public static final String SUMMARY_TEMPLATE = "snpEff_summary.ftl";
    public static final String SUMMARY_CSV_TEMPLATE = "snpEff_csv_summary.ftl";
    public static final String SUMMARY_GENES_TEMPLATE = "snpEff_genes.ftl";
    public static final String DEFAULT_SUMMARY_HTML_FILE = "snpEff_summary.html";
    public static final String DEFAULT_SUMMARY_CSV_FILE = "snpEff_summary.csv";
    public static final String DEFAULT_SUMMARY_GENES_FILE = "snpEff_genes.txt";
    public static final int SHOW_EVERY = 10000;
    boolean anyCancerSample;
    boolean cancer = false;
    boolean chromoPlots = true;
    boolean createSummaryCsv = false;
    boolean createSummaryHtml = true;
    boolean lossOfFunction = true;
    boolean fastaProtNoRef = false;
    boolean useGeneId = false;
    boolean useLocalTemplate = false;
    boolean useOicr = false;
    boolean useSequenceOntology = true;
    int totalErrs = 0;
    int countVcfEntries = 0;
    long countInputLines = 0L;
    long countVariants = 0L;
    long countEffects = 0L;
    String cancerSamples = null;
    String chrStr = "";
    String inputFile = "";
    String fastaProt;
    ProteinFastaWriter proteinFastaWriter = null;
    String summaryFileCsv = "snpEff_summary.csv";
    String summaryFileHtml = "snpEff_summary.html";
    String summaryGenesFile = "snpEff_genes.txt";
    SnpEff.InputFormat inputFormat = SnpEff.InputFormat.VCF;
    SnpEff.OutputFormat outputFormat = SnpEff.OutputFormat.VCF;
    VariantEffectFilter variantEffectResutFilter;
    ArrayList<String> filterIntervalFiles;
    ArrayList<String> inputFiles;
    IntervalForest filterIntervals;
    VariantStats variantStats;
    VariantEffectStats variantEffectStats;
    SnpEffectPredictor snpEffectPredictor;
    VcfStats vcfStats;
    List<VcfEntry> vcfEntriesDebug = null;
    EffFormatVersion formatVersion = EffFormatVersion.DEFAULT_FORMAT_VERSION;
    Pedigree pedigree;
    CountByType errByType;
    CountByType warnByType;
    OutputFormatter outputFormatter = null;
    Timer annotateTimer;

    public SnpEffCmdEff() {
        this.variantEffectResutFilter = new VariantEffectFilter();
        this.filterIntervalFiles = new ArrayList();
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        return false;
    }

    public boolean annotate(String inputFile, String outputFile) {
        this.annotateInit(outputFile);
        VcfFileIterator vcf = null;
        switch (this.inputFormat) {
            case VCF: {
                vcf = this.annotateVcf(inputFile);
                break;
            }
            case BED: {
                this.annotateBed(inputFile, this.outputFormatter);
                break;
            }
            default: {
                throw new RuntimeException("Cannot create variant file iterator on input format '" + String.valueOf((Object)this.inputFormat) + "'");
            }
        }
        this.outputFormatter.close();
        boolean err = this.annotateFinish(vcf);
        return !err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean printed = false;
        boolean filteredOut = false;
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        try {
            ++this.countInputLines;
            ++this.countVcfEntries;
            if (vcfFile.isHeadeSection() && this.cancer) {
                this.pedigree = this.readPedigree(vcfFile);
                this.anyCancerSample = this.pedigree.anyDerived();
            }
            if (this.createSummaryHtml || this.createSummaryCsv) {
                this.vcfStats.sample(vcfEntry);
            }
            if (this.filterIntervals != null && this.filterIntervals.query(vcfEntry).isEmpty()) {
                filteredOut = true;
                boolean bl = false;
                return bl;
            }
            this.outputFormatter.startSection(vcfEntry);
            boolean impactLowOrHigher = false;
            List<Variant> variants = vcfEntry.variants();
            for (Variant variant : variants) {
                ++this.countVariants;
                this.showProgress();
                impactLowOrHigher |= this.annotateVariant(variant);
            }
            if (this.anyCancerSample && impactLowOrHigher) {
                this.annotateVariantCancer(variants, vcfEntry);
            }
            this.outputFormatter.printSection(vcfEntry);
            printed = true;
        }
        catch (Throwable t) {
            ++this.totalErrs;
            Log.error(t, "Error while processing VCF entry (line " + vcfFile.getLineNum() + ") :\n\t" + String.valueOf(vcfEntry) + "\n" + String.valueOf(t));
            if (this.testing) {
                throw new RuntimeException("Error while processing VCF entry (line " + vcfFile.getLineNum() + ") :\n\t" + String.valueOf(vcfEntry) + "\n" + String.valueOf(t), t);
            }
        }
        finally {
            if (!printed && !filteredOut) {
                this.outputFormatter.printSection(vcfEntry);
            }
        }
        return true;
    }

    void annotateBed(String inputFile, OutputFormatter outputFormatter) {
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        BedFileIterator variantFileIterator = new BedFileIterator(inputFile, this.config.getGenome());
        for (Variant variant : variantFileIterator) {
            try {
                ++this.countInputLines;
                ++this.countVariants;
                if (this.verbose && this.countVariants % 10000L == 0L) {
                    Log.info("\t" + this.countVariants + " variants");
                }
                if (this.filterIntervals != null && this.filterIntervals.stab(variant).size() <= 0) continue;
                if (this.createSummaryHtml || this.createSummaryCsv) {
                    this.variantStats.sample(variant);
                }
                VariantEffects variantEffects = snpEffectPredictor.variantEffect(variant);
                outputFormatter.startSection(variant);
                for (VariantEffect variantEffect : variantEffects) {
                    this.variantEffectStats.sample(variantEffect);
                    outputFormatter.add(variantEffect);
                    ++this.countEffects;
                }
                outputFormatter.printSection(variant);
            }
            catch (Throwable t) {
                ++this.totalErrs;
                Log.error(t, "Error while processing variant (line " + variantFileIterator.getLineNum() + ") :\n\t" + String.valueOf(variant) + "\n" + String.valueOf(t));
            }
        }
        variantFileIterator.close();
    }

    @Override
    public boolean annotateFinish(VcfFileIterator vcfFile) {
        boolean ok = true;
        if (vcfFile != null) {
            vcfFile.close();
        }
        if (this.proteinFastaWriter != null) {
            this.proteinFastaWriter.close();
        }
        if (this.createSummaryCsv) {
            if (this.verbose) {
                Log.info("Creating summary file: " + this.summaryFileCsv);
            }
            ok &= this.summary(SUMMARY_CSV_TEMPLATE, this.summaryFileCsv, true);
        }
        if (this.createSummaryHtml) {
            if (this.verbose) {
                Log.info("Creating summary file: " + this.summaryFileHtml);
            }
            ok &= this.summary(SUMMARY_TEMPLATE, this.summaryFileHtml, false);
        }
        if (this.createSummaryHtml || this.createSummaryCsv) {
            if (this.verbose) {
                Log.info("Creating genes file: " + this.summaryGenesFile);
            }
            ok &= this.summary(SUMMARY_GENES_TEMPLATE, this.summaryGenesFile, true);
        }
        if (this.totalErrs > 0) {
            System.err.println(this.totalErrs + " errors.");
        }
        return !ok;
    }

    protected void annotateInit(String outputFile) {
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.totalErrs = 0;
        this.countEffects = 0L;
        this.countVariants = 0L;
        this.countInputLines = 0L;
        this.anyCancerSample = false;
        this.pedigree = null;
        this.errByType = new CountByType();
        this.warnByType = new CountByType();
        this.countVcfEntries = 0;
        this.annotateTimer = new Timer();
        this.variantStats = new VariantStats(this.config.getGenome());
        this.variantEffectStats = new VariantEffectStats(this.config.getGenome());
        this.variantEffectStats.setUseSequenceOntology(this.useSequenceOntology);
        this.vcfStats = new VcfStats();
        if (this.fastaProt != null) {
            this.proteinFastaWriter = new ProteinFastaWriter(this.fastaProt, this.fastaProtNoRef, this.verbose);
        }
        this.outputFormatter = null;
        switch (this.outputFormat) {
            case VCF: {
                VcfOutputFormatter vof = new VcfOutputFormatter(this.vcfEntriesDebug);
                vof.setFormatVersion(this.formatVersion);
                vof.setLossOfFunction(this.lossOfFunction);
                vof.setConfig(this.config);
                this.outputFormatter = vof;
                break;
            }
            case GATK: {
                this.outputFormatter = new VcfOutputFormatter(this.vcfEntriesDebug);
                ((VcfOutputFormatter)this.outputFormatter).setGatk(true);
                break;
            }
            case BED: {
                this.outputFormatter = new BedOutputFormatter();
                break;
            }
            case BEDANN: {
                this.outputFormatter = new BedAnnotationOutputFormatter();
                break;
            }
            default: {
                throw new RuntimeException("Unknown output format '" + String.valueOf((Object)this.outputFormat) + "'");
            }
        }
        this.outputFormatter.setVersion(VERSION_AUTHOR);
        this.outputFormatter.setCommandLineStr(this.commandLineStr(false));
        this.outputFormatter.setVariantEffectResutFilter(this.variantEffectResutFilter);
        this.outputFormatter.setSupressOutput(this.suppressOutput);
        this.outputFormatter.setChrStr(this.chrStr);
        this.outputFormatter.setUseSequenceOntology(this.useSequenceOntology);
        this.outputFormatter.setUseOicr(this.useOicr);
        this.outputFormatter.setUseHgvs(this.hgvs);
        this.outputFormatter.setUseGeneId(this.useGeneId);
        this.outputFormatter.setOutputFile(outputFile);
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        if (this.inputFormat != SnpEff.InputFormat.VCF || this.outputFormat != SnpEff.OutputFormat.VCF) {
            throw new RuntimeException();
        }
        this.annotateInit((String)null);
        return false;
    }

    boolean annotateVariant(Variant variant) {
        if (!variant.isVariant()) {
            return false;
        }
        boolean impactModerateOrHigh = false;
        boolean impactLowOrHigher = false;
        if (this.createSummaryHtml || this.createSummaryCsv) {
            this.variantStats.sample(variant);
        }
        VariantEffects variantEffects = this.snpEffectPredictor.variantEffect(variant);
        this.outputFormatter.startSection(variant);
        for (VariantEffect variantEffect : variantEffects) {
            if (this.createSummaryHtml || this.createSummaryCsv) {
                this.variantEffectStats.sample(variantEffect);
            }
            if (variantEffect.hasError()) {
                this.errByType.inc(variantEffect.getError());
            }
            if (variantEffect.hasWarning()) {
                this.warnByType.inc(variantEffect.getWarning());
            }
            impactLowOrHigher |= variantEffect.getEffectImpact() != VariantEffect.EffectImpact.MODIFIER;
            impactModerateOrHigh |= variantEffect.getEffectImpact() == VariantEffect.EffectImpact.MODERATE || variantEffect.getEffectImpact() == VariantEffect.EffectImpact.HIGH;
            this.outputFormatter.add(variantEffect);
            ++this.countEffects;
        }
        this.outputFormatter.printSection(variant);
        if (this.proteinFastaWriter != null && impactModerateOrHigh) {
            this.proteinFastaWriter.write(variant, variantEffects);
        }
        return impactLowOrHigher;
    }

    void annotateVariantCancer(List<Variant> variants, int altGtNum, int refGtNum) {
        VariantNonRef varNonRef = this.variantCancer(variants, altGtNum, refGtNum);
        if (!varNonRef.isVariant()) {
            return;
        }
        VariantEffects variantEffects = this.snpEffectPredictor.variantEffect(varNonRef);
        this.outputFormatter.startSection(varNonRef);
        for (VariantEffect variantEffect : variantEffects) {
            this.outputFormatter.add(variantEffect);
        }
        this.outputFormatter.printSection(varNonRef);
    }

    void annotateVariantCancer(List<Variant> variants, VcfEntry vcfEntry) {
        if (!this.shouldAnnotateVariantCancer(variants, vcfEntry)) {
            return;
        }
        Set<Tuple<Integer, Integer>> comparisons = this.pedigree.compareCancerGenotypes(vcfEntry);
        for (Tuple<Integer, Integer> comp : comparisons) {
            int altGtNum = (Integer)comp.first;
            int refGtNum = (Integer)comp.second;
            this.annotateVariantCancer(variants, altGtNum, refGtNum);
        }
    }

    VcfFileIterator annotateVcf(String inputFile) {
        VcfFileIterator vcfFile = new VcfFileIterator(inputFile, this.config.getGenome());
        vcfFile.setDebug(this.debug);
        if (this.multiThreaded) {
            StreamSupport.stream(vcfFile.spliterator(), true).forEach(this::annotate);
        } else {
            for (VcfEntry vcfEntry : vcfFile) {
                this.annotate(vcfEntry);
            }
        }
        if (this.countVcfEntries == 0) {
            this.outputFormatter.print(vcfFile.getVcfHeader().toString());
        }
        if (this.verbose) {
            if (!this.errByType.isEmpty()) {
                System.err.println("\nERRORS: Some errors were detected\nError type\tNumber of errors\n" + String.valueOf(this.errByType) + "\n");
            }
            if (!this.warnByType.isEmpty()) {
                System.err.println("\nWARNINGS: Some warning were detected\nWarning type\tNumber of warnings\n" + String.valueOf(this.warnByType) + "\n");
            }
        }
        return vcfFile;
    }

    public VariantEffectStats getChangeEffectResutStats() {
        return this.variantEffectStats;
    }

    public int getTotalErrs() {
        return this.totalErrs;
    }

    public VariantStats getvariantStats() {
        return this.variantStats;
    }

    String outputFile(String inputFile) {
        String base = Gpr.baseName(inputFile, ".gz");
        switch (this.inputFormat) {
            case VCF: {
                base = Gpr.baseName(inputFile, ".vcf");
                break;
            }
            case BED: {
                base = Gpr.baseName(inputFile, ".bed");
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented option for input file type " + String.valueOf((Object)this.inputFormat));
            }
        }
        String outputFile = Gpr.dirName(inputFile) + "/" + base + ".eff";
        switch (this.outputFormat) {
            case BED: 
            case BEDANN: {
                outputFile = outputFile + ".bed";
                break;
            }
            case VCF: 
            case GATK: {
                outputFile = outputFile + ".vcf";
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented option for output file type " + String.valueOf((Object)this.outputFormat));
            }
        }
        if (this.createSummaryCsv) {
            this.summaryFileCsv = Gpr.dirName(inputFile) + "/" + base + "_summary.csv";
        }
        if (this.createSummaryHtml) {
            this.summaryFileHtml = Gpr.dirName(inputFile) + "/" + base + "_summary.html";
        }
        this.summaryGenesFile = Gpr.dirName(inputFile) + "/" + base + "_genes.txt";
        return outputFile;
    }

    @Override
    public void parseArgs(String[] args) {
        boolean isOutVcf;
        if (args == null) {
            return;
        }
        boolean isFileList = false;
        this.args = args;
        block64: for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                if (arg.equalsIgnoreCase("-fileList")) {
                    isFileList = true;
                    continue;
                }
                switch (arg = arg.toLowerCase()) {
                    case "-chr": {
                        this.chrStr = args[++i2];
                        break;
                    }
                    case "-csvstats": {
                        String dir;
                        String base;
                        this.createSummaryCsv = true;
                        if (i2 + 1 < args.length) {
                            this.summaryFileCsv = args[++i2];
                            base = Gpr.baseName(this.summaryFileCsv, ".csv");
                            dir = Gpr.dirName(this.summaryFileCsv);
                            this.summaryGenesFile = (String)(dir != null ? dir + "/" : "") + base + ".genes.txt";
                            break;
                        }
                        this.usage("Missing parameter: CSV stats file name ");
                        break;
                    }
                    case "-fastaprot": {
                        if (i2 + 1 < args.length) {
                            this.fastaProt = args[++i2];
                            break;
                        }
                        this.usage("Missing -cancerSamples argument");
                        break;
                    }
                    case "-fastaprotnoref": {
                        this.fastaProtNoRef = true;
                    }
                    case "-nochromoplots": {
                        this.chromoPlots = false;
                        break;
                    }
                    case "-nostats": {
                        this.createSummaryCsv = false;
                        this.createSummaryHtml = false;
                        break;
                    }
                    case "-o": {
                        String outFor;
                        if (i2 + 1 >= args.length) continue block64;
                        if ((outFor = args[++i2].toUpperCase()).equals("VCF")) {
                            this.outputFormat = SnpEff.OutputFormat.VCF;
                            break;
                        }
                        if (outFor.equals("GATK")) {
                            this.outputFormat = SnpEff.OutputFormat.GATK;
                            this.useSequenceOntology = false;
                            this.hgvs = false;
                            this.nextProt = false;
                            this.motif = false;
                            this.spliceRegionIntronMax = 0;
                            this.spliceRegionIntronMin = 0;
                            this.spliceRegionExonSize = 0;
                            break;
                        }
                        if (outFor.equals("BED")) {
                            this.outputFormat = SnpEff.OutputFormat.BED;
                            this.lossOfFunction = false;
                            break;
                        }
                        if (outFor.equals("BEDANN")) {
                            this.outputFormat = SnpEff.OutputFormat.BEDANN;
                            this.lossOfFunction = false;
                            break;
                        }
                        if (outFor.equals("TXT")) {
                            this.usage("Output format 'TXT' has been deprecated. Please use 'VCF' instead.\nYou can extract VCF fields to a TXT file using 'SnpSift extractFields' (https://pcingola.github.io/SnpEff/SnpSift.html#Extract).");
                            break;
                        }
                        this.usage("Unknown output file format '" + outFor + "'");
                        break;
                    }
                    case "-s": 
                    case "-stats": 
                    case "-htmlstats": {
                        String dir;
                        String base;
                        this.createSummaryHtml = true;
                        if (i2 + 1 < args.length) {
                            this.summaryFileHtml = args[++i2];
                            base = Gpr.baseName(this.summaryFileHtml, ".html");
                            dir = Gpr.dirName(this.summaryFileHtml);
                            this.summaryGenesFile = (String)(dir != null ? dir + "/" : "") + base + ".genes.txt";
                            break;
                        }
                        this.usage("Missing parameter: HTML stats file name ");
                        break;
                    }
                    case "-uselocaltemplate": {
                        this.useLocalTemplate = true;
                        break;
                    }
                    case "-cancer": {
                        this.cancer = true;
                        break;
                    }
                    case "-cancersamples": {
                        if (i2 + 1 < args.length) {
                            this.cancerSamples = args[++i2];
                            break;
                        }
                        this.usage("Missing -cancerSamples argument");
                        break;
                    }
                    case "-classic": {
                        this.useSequenceOntology = false;
                        this.formatVersion = EffFormatVersion.FORMAT_EFF_4;
                        this.hgvs = this.hgvsForce;
                        break;
                    }
                    case "-formateff": {
                        this.formatVersion = EffFormatVersion.FORMAT_EFF_4;
                        break;
                    }
                    case "-geneid": {
                        this.useGeneId = true;
                        break;
                    }
                    case "-lof": {
                        this.lossOfFunction = true;
                        break;
                    }
                    case "-nohgvs": {
                        this.hgvs = false;
                        this.hgvsShift = false;
                        break;
                    }
                    case "-noshifthgvs": 
                    case "-no_shift_hgvs": {
                        this.hgvsShift = false;
                        break;
                    }
                    case "-nolof": {
                        this.lossOfFunction = false;
                        break;
                    }
                    case "-oicr": {
                        this.useOicr = true;
                        break;
                    }
                    case "-sequenceontology": {
                        this.useSequenceOntology = true;
                        break;
                    }
                    case "-fi": 
                    case "-filterinterval": {
                        if (i2 + 1 < args.length) {
                            this.filterIntervalFiles.add(args[++i2]);
                            break;
                        }
                        this.usage("Option '-fi' without config filter_interval_file argument");
                        break;
                    }
                    case "-i": {
                        if (i2 + 1 < args.length) {
                            String inFor;
                            if ((inFor = args[++i2].toUpperCase()).equals("VCF")) {
                                this.inputFormat = SnpEff.InputFormat.VCF;
                                this.outputFormat = SnpEff.OutputFormat.VCF;
                                break;
                            }
                            if (inFor.equals("BED")) {
                                this.inputFormat = SnpEff.InputFormat.BED;
                                this.outputFormat = SnpEff.OutputFormat.BED;
                                this.lossOfFunction = false;
                                break;
                            }
                            if (inFor.equals("TXT")) {
                                this.usage("Input format 'TXT' has been deprecated. Please use 'VCF' instead.");
                                break;
                            }
                            this.usage("Unknown input file format '" + inFor + "'");
                            break;
                        }
                        this.usage("Missing input format in command line option '-i'");
                        break;
                    }
                    case "-no-downstream": {
                        this.variantEffectResutFilter.add(EffectType.DOWNSTREAM);
                        break;
                    }
                    case "-no-upstream": {
                        this.variantEffectResutFilter.add(EffectType.UPSTREAM);
                        break;
                    }
                    case "-no-intergenic": {
                        this.variantEffectResutFilter.add(EffectType.INTERGENIC);
                        break;
                    }
                    case "-no-intron": {
                        this.variantEffectResutFilter.add(EffectType.INTRON);
                        break;
                    }
                    case "-no-utr": {
                        this.variantEffectResutFilter.add(EffectType.UTR_3_PRIME);
                        this.variantEffectResutFilter.add(EffectType.UTR_3_DELETED);
                        this.variantEffectResutFilter.add(EffectType.UTR_5_PRIME);
                        this.variantEffectResutFilter.add(EffectType.UTR_5_DELETED);
                        break;
                    }
                    case "-no": {
                        String[] filterOutArray;
                        String filterOut = "";
                        if (i2 + 1 < args.length) {
                            filterOut = args[++i2];
                        }
                        for (String filterStr : filterOutArray = filterOut.split(",")) {
                            if (filterStr.equalsIgnoreCase("utr")) {
                                this.variantEffectResutFilter.add(EffectType.UTR_3_PRIME);
                                this.variantEffectResutFilter.add(EffectType.UTR_3_DELETED);
                                this.variantEffectResutFilter.add(EffectType.UTR_5_PRIME);
                                this.variantEffectResutFilter.add(EffectType.UTR_5_DELETED);
                                continue;
                            }
                            if (filterStr.equalsIgnoreCase("None")) continue;
                            this.variantEffectResutFilter.add(EffectType.valueOf(filterStr.toUpperCase()));
                        }
                        continue block64;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                    }
                }
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.inputFile.isEmpty()) {
                this.inputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.inputFile.isEmpty()) {
            this.inputFile = "-";
        } else if (!Gpr.canRead(this.inputFile)) {
            this.usage("Cannot read input file '" + this.inputFile + "'");
        }
        if (isFileList) {
            this.inputFiles = new ArrayList();
            for (String file : this.readFile(this.inputFile).split("\n")) {
                this.inputFiles.add(file);
            }
        }
        boolean bl = isOutVcf = this.outputFormat == SnpEff.OutputFormat.VCF || this.outputFormat == SnpEff.OutputFormat.GATK;
        if (isOutVcf && this.inputFormat != SnpEff.InputFormat.VCF) {
            this.usage("Output in VCF format is only supported when the input is also in VCF format");
        }
        if (!isOutVcf && this.lossOfFunction) {
            this.usage("Loss of function annotation is only supported when when output is in VCF format");
        }
        if (!isOutVcf && this.cancer) {
            this.usage("Canccer annotation is only supported when when output is in VCF format");
        }
        if (this.multiThreaded) {
            this.createSummaryHtml = false;
            this.createSummaryCsv = false;
        }
        if (this.multiThreaded && this.cancer) {
            this.usage("Cancer analysis is currently not supported in multi-threaded mode.");
        }
        if (this.multiThreaded && !isOutVcf) {
            this.usage("Multi-threaded option is only supported when when output is in VCF format");
        }
        if (this.multiThreaded && (this.createSummaryHtml || this.createSummaryCsv)) {
            this.usage("Multi-threaded option should be used with 'noStats'.");
        }
    }

    String readFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            Log.fatalError("No such file '" + fileName + "'");
        }
        if (!file.canRead()) {
            Log.fatalError("Cannot open file '" + fileName + "'");
        }
        return Gpr.readFile(fileName);
    }

    int readFilterIntFile(String intFile) {
        Markers markers = this.loadMarkers(intFile);
        if (this.filterIntervals == null) {
            this.filterIntervals = new IntervalForest();
        }
        for (Marker filterInterval : markers) {
            this.filterIntervals.add(filterInterval);
        }
        return markers.size();
    }

    Pedigree readPedigree(VcfFileIterator vcfFile) {
        if (this.cancerSamples != null) {
            return new Pedigree(vcfFile, this.cancerSamples);
        }
        return new Pedigree(vcfFile);
    }

    @Override
    public HashMap<String, String> reportValues() {
        HashMap<String, String> report = super.reportValues();
        if (this.variantStats != null) {
            report.put("variants", "" + this.variantStats.getCount());
        }
        return report;
    }

    @Override
    public boolean run() {
        return this.run(false) != null;
    }

    public List<VcfEntry> run(boolean createList) {
        if (!this.variantEffectResutFilter.anythingSet()) {
            this.variantEffectResutFilter = null;
        }
        this.filterIntervals = null;
        this.loadConfig();
        this.loadDb();
        if (!Gpr.canRead(this.inputFile)) {
            this.usage("Cannot open input file '" + this.inputFile + "'");
        }
        for (String filterIntFile : this.filterIntervalFiles) {
            if (this.filterIntervals == null) {
                this.filterIntervals = new IntervalForest();
            }
            if (this.verbose) {
                Log.info("Reading filter interval file '" + filterIntFile + "'");
            }
            int count = this.readFilterIntFile(filterIntFile);
            if (!this.verbose) continue;
            Log.info("done (" + count + " intervals loaded). ");
        }
        if (this.filterIntervals != null) {
            if (this.verbose) {
                Log.info("Building filter interval forest");
            }
            this.filterIntervals.build();
            if (this.verbose) {
                Log.info("done.");
            }
        }
        if (createList) {
            this.vcfEntriesDebug = new ArrayList<VcfEntry>();
        }
        boolean ok = true;
        if (this.verbose) {
            Log.info("Predicting variants");
        }
        if (this.inputFiles == null) {
            ok = this.annotate(this.inputFile, null);
        } else {
            for (String inputFile : this.inputFiles) {
                String outputFile = this.outputFile(inputFile);
                if (this.verbose) {
                    Log.info("Analyzing file\n\tInput         : '" + inputFile + "'\n\tOutput        : '" + outputFile + "'" + (String)(this.createSummaryHtml ? "\n\tSummary (HTML): '" + this.summaryFileHtml + "'" : "") + (String)(this.createSummaryCsv ? "\n\tSummary (CSV) : '" + this.summaryFileCsv + "'" : ""));
                }
                ok &= this.annotate(inputFile, outputFile);
            }
        }
        if (this.verbose) {
            Log.info("done.");
        }
        if (!ok) {
            return null;
        }
        if (this.vcfEntriesDebug == null) {
            return new ArrayList<VcfEntry>();
        }
        return this.vcfEntriesDebug;
    }

    public void setFormatVersion(EffFormatVersion formatVersion) {
        this.formatVersion = formatVersion;
    }

    boolean shouldAnnotateVariantCancer(List<Variant> variants, VcfEntry vcfEntry) {
        if (vcfEntry.isMultiallelic()) {
            return true;
        }
        return this.pedigree.anyBackToRef(vcfEntry);
    }

    void showProgress() {
        int millisec;
        int secs;
        if (this.verbose && this.countVariants % 10000L == 0L && (secs = (millisec = (int)this.annotateTimer.elapsed()) / 1000) > 0) {
            int varsPerSec = (int)((double)this.countVariants * 1000.0 / (double)millisec);
            Log.info("\t" + this.countVariants + " variants (" + varsPerSec + " variants per second), " + this.countVcfEntries + " VCF entries");
        }
    }

    boolean summary(String templateFile, String outputFile, boolean noCommas) {
        try {
            Configuration cfg = new Configuration();
            if (this.useLocalTemplate) {
                cfg.setDirectoryForTemplateLoading(new File(TEMPLATES_DIR));
            } else {
                cfg.setClassForTemplateLoading(SnpEffCmdEff.class, "/");
            }
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setLocale(Locale.US);
            if (noCommas) {
                cfg.setNumberFormat("0.######");
            }
            HashMap<String, Object> root = this.summaryCreateHash();
            Template temp = cfg.getTemplate(templateFile);
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(outputFile)));
            temp.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            Log.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        catch (TemplateException e) {
            Log.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        return true;
    }

    HashMap<String, Object> summaryCreateHash() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("args", this.commandLineStr(!this.createSummaryCsv));
        root.put("changeStats", this.variantEffectStats);
        root.put("chromoPlots", this.chromoPlots);
        root.put("countEffects", this.countEffects);
        root.put("countInputLines", this.countInputLines);
        root.put("countVariants", this.countVariants);
        root.put("date", String.format("%1$TY-%1$Tm-%1$Td %1$TH:%1$TM", new Date()));
        root.put("genesFile", Gpr.baseName(this.summaryGenesFile, ""));
        root.put("genome", this.config.getGenome());
        root.put("genomeVersion", this.genomeVer);
        root.put("variantEffectResutFilter", this.variantEffectResutFilter);
        root.put("variantStats", this.variantStats);
        root.put("snpEffectPredictor", this.config.getSnpEffectPredictor());
        root.put("vcfStats", this.vcfStats);
        root.put("version", SnpEff.VERSION);
        return root;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
            System.err.println("Command line :\t" + this.commandLineStr(false) + "\n");
            if (this.testing) {
                throw new RuntimeException("Error: " + message);
            }
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff [ann] [options] genome_version [input_file]");
        System.err.println("\n");
        System.err.println("\tvariants_file                   : Default is STDIN");
        System.err.println("\n");
        System.err.println("\nOptions:");
        System.err.println("\t-chr <string>                   : Prepend 'string' to chromosome name (e.g. 'chr1' instead of '1'). Only on TXT output.");
        System.err.println("\t-classic                        : Use old style annotations instead of Sequence Ontology and Hgvs.");
        System.err.println("\t-csvStats <file>                : Create CSV summary file.");
        System.err.println("\t-download                       : Download reference genome if not available. Default: " + this.download);
        System.err.println("\t-i <format>                     : Input format [ vcf, bed ]. Default: VCF.");
        System.err.println("\t-fileList                       : Input actually contains a list of files to process.");
        System.err.println("\t-o <format>                     : Output format [ vcf, gatk, bed, bedAnn ]. Default: VCF.");
        System.err.println("\t-s , -stats, -htmlStats         : Create HTML summary file.  Default is 'snpEff_summary.html'");
        System.err.println("\t-noStats                        : Do not create stats (summary) file");
        System.err.println("\nResults filter options:");
        System.err.println("\t-fi , -filterInterval  <file>   : Only analyze changes that intersect with the intervals specified in this file (you may use this option many times)");
        System.err.println("\t-no-downstream                  : Do not show DOWNSTREAM changes");
        System.err.println("\t-no-intergenic                  : Do not show INTERGENIC changes");
        System.err.println("\t-no-intron                      : Do not show INTRON changes");
        System.err.println("\t-no-upstream                    : Do not show UPSTREAM changes");
        System.err.println("\t-no-utr                         : Do not show 5_PRIME_UTR or 3_PRIME_UTR changes");
        System.err.println("\t-no <effectType>                : Do not show 'EffectType'. This option can be used several times.");
        System.err.println("\nAnnotations options:");
        System.err.println("\t-cancer                         : Perform 'cancer' comparisons (Somatic vs Germline). Default: " + this.cancer);
        System.err.println("\t-cancerSamples <file>           : Two column TXT file defining 'oringinal \\t derived' samples.");
        System.err.println("\t-fastaProt <file>               : Create an output file containing the resulting protein sequences.");
        System.err.println("\t-fastaProtNoRef                 : Do not add reference sequences to the output (only valid when -fastaProt). Default: " + this.fastaProtNoRef);
        System.err.println("\t-formatEff                      : Use 'EFF' field compatible with older versions (instead of 'ANN').");
        System.err.println("\t-geneId                         : Use gene ID instead of gene name (VCF output). Default: " + this.useGeneId);
        System.err.println("\t-hgvs                           : Use HGVS annotations for amino acid sub-field. Default: " + this.hgvs);
        System.err.println("\t-hgvsOld                        : Use old HGVS notation. Default: " + this.hgvsOld);
        System.err.println("\t-hgvs1LetterAa                  : Use one letter Amino acid codes in HGVS notation. Default: " + this.hgvsOneLetterAa);
        System.err.println("\t-hgvsTrId                       : Use transcript ID in HGVS notation. Default: " + this.hgvsTrId);
        System.err.println("\t-lof                            : Add loss of function (LOF) and Nonsense mediated decay (NMD) tags.");
        System.err.println("\t-noHgvs                         : Do not add HGVS annotations.");
        System.err.println("\t-noLof                          : Do not add LOF and NMD annotations.");
        System.err.println("\t-noOut                          : Do not write the output resuts to STDOUT (maybe used for debugging).");
        System.err.println("\t-noShiftHgvs                    : Do not shift variants according to HGVS notation (most 3prime end).");
        System.err.println("\t-oicr                           : Add OICR tag in VCF file. Default: " + this.useOicr);
        System.err.println("\t-sequenceOntology               : Use Sequence Ontology terms. Default: " + this.useSequenceOntology);
        this.usageGenericAndDb();
        System.exit(-1);
    }

    VariantNonRef variantCancer(List<Variant> variants, int altGtNum, int refGtNum) {
        if (altGtNum == 0) {
            Variant variantRef = variants.get(refGtNum - 1);
            Variant variantAlt = variantRef.reverse();
            return new VariantNonRef(variantAlt, variantRef);
        }
        Variant variantRef = variants.get(refGtNum - 1);
        Variant variantAlt = variants.get(altGtNum - 1);
        return new VariantNonRef(variantAlt, variantRef);
    }
}

