/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.snpeff.SnpEff;
import org.snpeff.logStatsServer.VersionCheck;
import org.snpeff.util.Download;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class SnpEffCmdDownload
extends SnpEff {
    boolean update;

    boolean downloadAndInstall(URL url, String localFile, boolean maskDownloadExceptions) {
        Download download = new Download();
        download.setVerbose(this.verbose);
        download.setDebug(this.debug);
        download.setUpdate(this.update);
        download.setMaskDownloadException(maskDownloadExceptions);
        if (this.verbose) {
            Log.info("Downloading from '" + String.valueOf(url) + "' to local file '" + localFile + "'");
        }
        if (download.download(url, localFile) && download.unzip(localFile, this.config.getDirMain(), this.config.getDirData())) {
            if (this.verbose) {
                Log.info("Unzip: OK");
            }
            if (new File(localFile).delete() && this.verbose) {
                Log.info("Deleted local file '" + localFile + "'");
            }
            return true;
        }
        return false;
    }

    boolean downloadAndInstall(List<URL> urls) {
        boolean maskExceptions = urls.size() > 1;
        for (URL url : urls) {
            String localFile;
            if (!this.downloadAndInstall(url, localFile = System.getProperty("java.io.tmpdir") + "/" + Download.urlBaseName(url.toString()), maskExceptions)) continue;
            return true;
        }
        Log.fatalError("Failed to download database from " + String.valueOf(urls));
        return false;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (String arg : args) {
            if (this.isOpt(arg)) {
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    @Override
    public boolean run() {
        if (this.genomeVer.equals("snpeff")) {
            this.update = true;
            return this.runDownloadSnpEff();
        }
        return this.runDownloadGenome();
    }

    boolean runDownloadGenome() {
        List<URL> urls;
        this.loadConfig();
        if (this.verbose) {
            Log.info("Downloading database for '" + this.genomeVer + "'");
        }
        if (this.downloadAndInstall(urls = this.config.downloadUrl(this.genomeVer))) {
            if (this.verbose) {
                Log.info("Done");
            }
            return true;
        }
        return false;
    }

    boolean runDownloadSnpEff() {
        URL url;
        this.genomeVer = "";
        this.loadConfig();
        VersionCheck versionCheck = VersionCheck.version("SnpEff", "5.4a", this.config.getVersionsUrl(), this.verbose);
        if (!versionCheck.isNewVersion()) {
            Log.info("No new version found. This seems to be the latest version (" + versionCheck.getLatestVersion() + ") or server could not be contacted. Nothing done.");
            return false;
        }
        Log.info("New version: \n\tNew version  : " + versionCheck.getLatestVersion() + "\n\tRelease date : " + versionCheck.getLatestReleaseDate() + "\n\tDownload URL : " + versionCheck.getLatestUrl());
        if (this.verbose) {
            Log.info("Downloading SnpEff");
        }
        try {
            url = new URL(versionCheck.getLatestUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String localFile = System.getProperty("java.io.tmpdir") + "/" + Gpr.baseName(url.toString());
        this.downloadAndInstall(url, localFile, false);
        if (this.verbose) {
            Log.info("Done");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff download [options] {snpeff | genome_version}");
        System.exit(-1);
    }
}

