/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.snpeff.SnpEff;
import org.snpeff.util.Gpr;

public class SnpEffCmdDatabases
extends SnpEff {
    public static final String DARK_ROW = "bgcolor=#CCCCCC";
    public static final String LIGHT_ROW = "bgcolor=#EEEEEE";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String FTP_PROTOCOL = "ftp://";
    boolean galaxy = false;
    boolean html = false;
    HashMap<String, String> nameByGenomeVer;
    ArrayList<String> namesSorted;
    ArrayList<String> genVerSorted;

    void galaxyConfig() {
        System.out.println("\t<param name=\"genomeVersion\" type=\"select\" label=\"Genome\">");
        for (String name : this.namesSorted) {
            for (String genVer : this.genVerSorted) {
                String n = this.config.getName(genVer);
                if (!name.equals(n)) continue;
                System.out.println("\t\t<option value=\"" + genVer + "\">" + name.replace('_', ' ') + " : " + genVer + "</option>");
            }
        }
        System.out.println("\t</param>");
    }

    void htmlTable() {
        boolean dark = false;
        String bg = "";
        System.out.println("\t<table> <tr bgcolor=#CCCCCC> <td> <b> Genome </b> </td>  <td> <b> Version </b> </td>  <td> <b> Reference </b> </td> </tr>");
        for (String name : this.namesSorted) {
            bg = dark ? DARK_ROW : LIGHT_ROW;
            dark = !dark;
            boolean showName = true;
            for (String genVer : this.genVerSorted) {
                String n = this.config.getName(genVer);
                if (!name.equals(n)) continue;
                System.out.println("\t\t<tr " + bg + ">");
                String name2show = showName ? name.replace('_', ' ') : "&nbsp;";
                System.out.println("\t\t\t<td> " + name2show + " </td>");
                showName = false;
                String url = "http://sourceforge.net/projects/snpeff/files/databases/v5.4/snpEff_v5.4_" + genVer + ".zip";
                System.out.println("\t\t\t<td> <a class=\"body\" href=\"" + url + "\"> " + genVer + " </a> </td>");
                String ref = this.config.getReference(genVer);
                String link = "";
                if (ref != null) {
                    if (ref.indexOf(44) > 0) {
                        ref = ref.substring(0, ref.indexOf(44));
                    }
                    link = ref;
                    int idx = ref.indexOf(47, HTTP_PROTOCOL.length());
                    if (idx > 0) {
                        ref = ref.substring(0, idx);
                    }
                    if (ref.startsWith(HTTP_PROTOCOL)) {
                        ref = ref.substring(HTTP_PROTOCOL.length());
                    }
                    if (ref.startsWith(FTP_PROTOCOL)) {
                        ref = ref.substring(FTP_PROTOCOL.length());
                    }
                } else {
                    ref = "";
                }
                System.out.println("\t\t\t<td> <a class=\"body\" href=\"" + link + "\">" + ref + "</a> </td>");
                System.out.println("\t\t</tr>");
            }
        }
        System.out.println("\t</table>");
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length > 1) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (arg.equals("galaxy")) {
                this.galaxy = true;
                this.html = false;
                continue;
            }
            if (!arg.equals("html")) continue;
            this.html = true;
            this.galaxy = false;
        }
    }

    @Override
    public boolean run() {
        this.genomeVer = "hg19";
        this.loadConfig();
        this.nameByGenomeVer = new HashMap();
        for (String genVer : this.config) {
            this.nameByGenomeVer.put(genVer, this.config.getName(genVer));
        }
        this.namesSorted = new ArrayList();
        this.namesSorted.addAll(this.nameByGenomeVer.values());
        Collections.sort(this.namesSorted);
        this.genVerSorted = new ArrayList();
        for (String genVer : this.config) {
            this.genVerSorted.add(genVer);
        }
        Collections.sort(this.genVerSorted);
        if (this.galaxy) {
            this.galaxyConfig();
        } else if (this.html) {
            this.htmlTable();
        } else {
            this.txtTable();
        }
        return true;
    }

    void txtTable() {
        System.out.println(String.format("%-60s\t%-60s\t%-10s\t%-30s\t%s", "Genome", "Organism", "Status", "Bundle", "Database download link"));
        System.out.println(String.format("%-60s\t%-60s\t%-10s\t%-30s\t%s", "------", "--------", "------", "------", "----------------------"));
        for (String genomeVer : this.genVerSorted) {
            String name = this.nameByGenomeVer.get(genomeVer);
            String url = this.config.downloadUrl(genomeVer).toString();
            String bundle = this.config.getBundleName(genomeVer);
            if (bundle == null) {
                bundle = "";
            }
            String database = this.config.getDirData() + "/" + genomeVer + "/snpEffectPredictor.bin";
            String status = "";
            if (Gpr.canRead(database)) {
                status = "OK";
            }
            System.out.println(String.format("%-60s\t%-60s\t%-10s\t%-30s\t%s", genomeVer, name, status, bundle, url));
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: snpEff databases [galaxy|html]");
        System.err.println("\nOptions");
        System.err.println("\tgalaxy  : Show databases in a galaxy menu format.");
        System.err.println("\thtml    : Show databases in a HTML format.");
        System.exit(-1);
    }
}

