/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.HashSet;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intergenic;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;

public class SnpEffCmdClosest
extends SnpEff {
    public static final String CLOSEST = "CLOSEST";
    public static final String INFO_LINE = "##INFO=<ID=CLOSEST,Number=4,Type=String,Description=\"Closest exon: Distance (bases), exons Id, transcript Id, gene name\">";
    boolean bedFormat = false;
    boolean tss = false;
    String inFile;
    SnpEffectPredictor snpEffectPredictor;

    public SnpEffCmdClosest() {
        this.command = "closestExon";
    }

    public SnpEffCmdClosest(Config config) {
        this.command = "closestExon";
        this.config = config;
        this.inFile = config.getFileNameProteins();
    }

    void addHeaderLines(VcfFileIterator vcf) {
        vcf.getVcfHeader().addLine("##SnpEffVersion=\"" + SnpEff.VERSION + "\"");
        String cmdLine = this.commandLineStr(false);
        if (!cmdLine.isEmpty()) {
            vcf.getVcfHeader().addLine("##SnpEffCmd=\"" + this.commandLineStr(false) + "\"");
        }
        vcf.getVcfHeader().addLine(INFO_LINE);
    }

    void bedIterate() {
        BedFileIterator bfi = new BedFileIterator(this.inFile, this.config.getGenome());
        bfi.setCreateChromos(true);
        for (Variant bed : bfi) {
            try {
                Markers closestMarkers = this.findClosestMarker(bed);
                String id = bed.getId();
                if (closestMarkers != null) {
                    StringBuilder idsb = new StringBuilder();
                    idsb.append(bed.getId());
                    if (idsb.length() > 0) {
                        idsb.append(";");
                    }
                    int dist = this.reportDistance(closestMarkers, bed);
                    idsb.append(dist);
                    for (Marker closestMarker : closestMarkers) {
                        idsb.append(";" + closestMarker.idChain(",", ":", false));
                    }
                    id = idsb.toString();
                }
                System.out.println(bed.getChromosomeName() + "\t" + bed.getStart() + "\t" + (bed.getEnd() + 1) + "\t" + id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    Markers findClosestMarker(Marker queryMarker) {
        int initialExtension = 1000;
        Chromosome chr = queryMarker.getChromosome();
        if (chr != null && chr.size() > 0) {
            for (int extend = initialExtension; extend < chr.size(); extend *= 2) {
                int end;
                int start = Math.max(queryMarker.getStart() - extend, 0);
                Marker extended = new Marker(chr, start, end = queryMarker.getEnd() + extend, false, "");
                Markers markers = this.snpEffectPredictor.queryDeep(extended);
                int minDistance = this.minDistance(queryMarker, markers);
                if (minDistance >= Integer.MAX_VALUE) continue;
                Markers closest = this.findClosestMarkers(queryMarker, markers, minDistance);
                return closest;
            }
        }
        return null;
    }

    Markers findClosestMarkers(Marker queryMarker, Markers markers, int maxDistance) {
        Markers closest = new Markers();
        HashSet<String> done = new HashSet<String>();
        for (Marker m : markers) {
            String idChain;
            int dist;
            if (m instanceof Chromosome || m instanceof Intergenic || m instanceof Gene || m instanceof Transcript || (dist = m.distance(queryMarker)) > maxDistance || this.findTranscript(m) == null || done.contains(idChain = m.idChain())) continue;
            closest.add(m);
            done.add(idChain);
        }
        return closest;
    }

    Transcript findTranscript(Marker m) {
        if (m instanceof Transcript) {
            return (Transcript)m;
        }
        return (Transcript)m.findParent(Transcript.class);
    }

    int minDistance(Marker queryMarker, Markers markers) {
        int minDist = Integer.MAX_VALUE;
        for (Marker m : markers) {
            int dist;
            if (m instanceof Chromosome || m instanceof Intergenic || m instanceof Gene || m instanceof Transcript || (dist = m.distance(queryMarker)) > minDist || this.findTranscript(m) == null) continue;
            minDist = dist;
        }
        return minDist;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg) {
                    case "-bed": {
                        this.bedFormat = true;
                        break;
                    }
                    case "-tss": {
                        this.tss = true;
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.inFile == null) {
                this.inFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.inFile == null || this.inFile.isEmpty()) {
            this.usage("Missing 'file' parameter");
        }
    }

    int reportDistance(Markers closestMarkers, Marker queryMarker) {
        Marker firstMarker = closestMarkers.getMarkers().get(0);
        if (this.tss) {
            Transcript tr = this.findTranscript(firstMarker);
            Marker trTss = tr.getTss();
            int d = trTss.distance(queryMarker);
            return tr.intersects(queryMarker) ? -d : d;
        }
        return firstMarker.distance(queryMarker);
    }

    @Override
    public boolean run() {
        if (this.config == null) {
            this.loadConfig();
        }
        this.loadDb();
        if (this.verbose) {
            Log.info("Building interval forest...");
        }
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.snpEffectPredictor.buildForest();
        if (this.verbose) {
            Log.info("done");
        }
        if (this.verbose) {
            Log.info("Reading file '" + this.inFile + "'");
        }
        if (this.bedFormat) {
            this.bedIterate();
        } else {
            this.vcfIterate();
        }
        if (this.verbose) {
            Log.info("done");
        }
        return true;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff closestExon [options] genome_version file.vcf");
        System.err.println("\nOptions:");
        System.err.println("\t-bed : Input format is BED. Default: VCF");
        System.err.println("\t-tss : Measure distance from TSS (transcription start site)");
        System.exit(-1);
    }

    void vcfIterate() {
        VcfFileIterator vcf = new VcfFileIterator(this.inFile, this.config.getGenome());
        vcf.setCreateChromos(true);
        vcf.setDebug(this.debug);
        boolean header = true;
        for (VcfEntry ve : vcf) {
            try {
                Markers closestMarkers;
                if (header) {
                    this.addHeaderLines(vcf);
                    String headerStr = vcf.getVcfHeader().toString();
                    if (!headerStr.isEmpty()) {
                        System.out.println(headerStr);
                    }
                    header = false;
                }
                if ((closestMarkers = this.findClosestMarker(ve)) != null) {
                    StringBuilder closestsb = new StringBuilder();
                    int dist = this.reportDistance(closestMarkers, ve);
                    closestsb.append(dist);
                    for (Marker closestMarker : closestMarkers) {
                        closestsb.append("|" + closestMarker.idChain(",", ":", false));
                    }
                    ve.addInfo(CLOSEST, closestsb.toString());
                }
                System.out.println(ve);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

