/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import org.snpeff.SnpEff;
import org.snpeff.nextProt.NextProtDb;
import org.snpeff.util.Log;

public class SnpEffCmdBuildNextProt
extends SnpEff {
    String xmlDirName;
    String trIdFile;

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                this.usage("Unknonwn option '" + arg + "'");
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i2];
                continue;
            }
            if (this.xmlDirName != null && !this.xmlDirName.isEmpty()) continue;
            this.xmlDirName = args[i2];
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genome version");
        }
        if (this.xmlDirName == null || this.xmlDirName.isEmpty()) {
            this.usage("Missing nextProt XML dir");
        }
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        NextProtDb nextProtDb = new NextProtDb(this.xmlDirName, this.config);
        nextProtDb.setVerbose(this.verbose);
        nextProtDb.setDebug(this.debug);
        nextProtDb.parse();
        nextProtDb.saveDatabase();
        if (this.verbose) {
            Log.info("Done!");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff buildNextProt genome_version nextProt_XML_dir");
        System.exit(-1);
    }
}

