/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.snpeff.RegulationConsensusMultipleBed;
import org.snpeff.RegulationFileConsensus;
import org.snpeff.RegulationFileSplitBytType;
import org.snpeff.SnpEff;
import org.snpeff.codons.FindRareAaIntervals;
import org.snpeff.fileIterator.MotifFileIterator;
import org.snpeff.fileIterator.RegulationGffFileIterator;
import org.snpeff.interval.ExonSpliceCharacterizer;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Motif;
import org.snpeff.interval.RareAminoAcid;
import org.snpeff.motif.Jaspar;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.commandLine.SnpEffCmdCds;
import org.snpeff.snpEffect.commandLine.SnpEffCmdProtein;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGenBank;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGenesFile;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff2;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff3;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryKnownGene;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class SnpEffCmdBuild
extends SnpEff {
    SnpEff.GeneDatabaseFormat geneDatabaseFormat = null;
    boolean checkNumOk = true;
    boolean checkCds = true;
    boolean checkProtein = true;
    boolean storeAlignments;
    boolean storeSequences = true;
    boolean regSortedByType = false;
    String cellType = null;
    double maxErrorRate = -1.0;
    SnpEffCmdProtein snpEffCmdProtein;
    SnpEffCmdCds snpEffCmdCds;

    boolean checkDb(SnpEffPredictorFactory snpEffectPredictorFactory) {
        boolean ok = true;
        if (this.checkCds) {
            ok &= this.checkDbCds(snpEffectPredictorFactory);
        }
        if (this.checkProtein) {
            ok &= this.checkDbProtein(snpEffectPredictorFactory);
        }
        return ok;
    }

    boolean checkDbCds(SnpEffPredictorFactory snpEffectPredictorFactory) {
        boolean okCds = false;
        String cdsFile = this.config.getFileNameCds();
        if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            if (this.verbose) {
                Log.info("CDS check: GenBank file format, skipping\n");
            }
            okCds = true;
        } else if (Gpr.canRead(cdsFile)) {
            if (this.verbose) {
                Log.info("CDS check (FASTA file): '" + cdsFile + "'\n");
            }
            this.snpEffCmdCds = new SnpEffCmdCds(this.config);
            this.snpEffCmdCds.setVerbose(this.verbose);
            this.snpEffCmdCds.setDebug(this.debug);
            this.snpEffCmdCds.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdCds.setCheckNumOk(this.checkNumOk);
            if (this.maxErrorRate >= 0.0) {
                this.snpEffCmdCds.setMaxErrorRate(this.maxErrorRate);
            }
            if (!(okCds = this.snpEffCmdCds.run()) && this.verbose) {
                Log.info("\tCDS sequences comparison failed!");
            }
        } else {
            Log.error("CDS check file '" + cdsFile + "' not found.");
        }
        return okCds;
    }

    boolean checkDbProtein(SnpEffPredictorFactory snpEffectPredictorFactory) {
        Object protFile = null;
        Map<String, String> proteinByTrId = snpEffectPredictorFactory.getProteinByTrId();
        protFile = this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK ? this.config.getBaseFileNameGenes() + ".gbk" : (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL ? this.config.getBaseFileNameGenes() + ".embl" : this.config.getFileNameProteins());
        boolean okProtein = false;
        if (Gpr.canRead((String)protFile)) {
            if (this.verbose) {
                Log.info("Protein check file: '" + (String)protFile + "'\n");
            }
            this.snpEffCmdProtein = new SnpEffCmdProtein(this.config, (String)protFile);
            this.snpEffCmdProtein.setVerbose(this.verbose);
            this.snpEffCmdProtein.setDebug(this.debug);
            this.snpEffCmdProtein.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdProtein.setCheckNumOk(this.checkNumOk);
            this.snpEffCmdProtein.setProteinByTrId(proteinByTrId);
            if (this.maxErrorRate >= 0.0) {
                this.snpEffCmdProtein.setMaxErrorRate(this.maxErrorRate);
            }
            if (!(okProtein = this.snpEffCmdProtein.run())) {
                if (this.verbose) {
                    Log.info("\tProtein sequences comparison failed!");
                }
                return false;
            }
        } else {
            Log.error("Protein check file '" + (String)protFile + "' not found.");
        }
        return okProtein;
    }

    SnpEffPredictorFactory createSnpEffPredictorFactory() {
        if (this.geneDatabaseFormat == null) {
            this.geneDatabaseFormat = this.guessGenesFormat();
        }
        SnpEffPredictorFactory factory = null;
        if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GTF22) {
            factory = new SnpEffPredictorFactoryGtf22(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF3) {
            factory = new SnpEffPredictorFactoryGff3(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF2) {
            factory = new SnpEffPredictorFactoryGff2(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.REFSEQ) {
            factory = new SnpEffPredictorFactoryRefSeq(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.KNOWN_GENES) {
            factory = new SnpEffPredictorFactoryKnownGene(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            factory = new SnpEffPredictorFactoryGenBank(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL) {
            factory = new SnpEffPredictorFactoryEmbl(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.BIOMART) {
            factory = new SnpEffPredictorFactoryGenesFile(this.config);
        } else {
            throw new RuntimeException("Unimplemented format " + String.valueOf((Object)this.geneDatabaseFormat));
        }
        factory.setVerbose(this.verbose);
        factory.setDebug(this.debug);
        factory.setStoreSequences(this.storeSequences);
        return factory;
    }

    protected boolean fileExists(String path) {
        return Gpr.exists(path) || Gpr.exists(path + ".gz");
    }

    public SnpEffCmdCds getSnpEffCmdCds() {
        return this.snpEffCmdCds;
    }

    public SnpEffCmdProtein getSnpEffCmdProtein() {
        return this.snpEffCmdProtein;
    }

    protected SnpEff.GeneDatabaseFormat guessGenesFormat() {
        String genesBase = this.config.getBaseFileNameGenes();
        if (this.fileExists(genesBase + ".gtf")) {
            return SnpEff.GeneDatabaseFormat.GTF22;
        }
        if (this.fileExists(genesBase + ".gff")) {
            return SnpEff.GeneDatabaseFormat.GFF3;
        }
        if (this.fileExists(genesBase + ".gff2")) {
            return SnpEff.GeneDatabaseFormat.GFF2;
        }
        if (this.fileExists(genesBase + ".gbk")) {
            return SnpEff.GeneDatabaseFormat.GENBANK;
        }
        if (this.fileExists(genesBase + ".embl")) {
            return SnpEff.GeneDatabaseFormat.EMBL;
        }
        if (this.fileExists(genesBase + ".refseq")) {
            return SnpEff.GeneDatabaseFormat.REFSEQ;
        }
        if (this.fileExists(genesBase + ".kg")) {
            return SnpEff.GeneDatabaseFormat.KNOWN_GENES;
        }
        if (this.fileExists(genesBase + ".biomart")) {
            return SnpEff.GeneDatabaseFormat.BIOMART;
        }
        if (this.geneDatabaseFormat == null) {
            Log.fatalError("Cannot guess input database format for genome '" + this.genomeVer + "'. No genes file found '" + genesBase + ".*'");
        }
        return null;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-gff3": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF3;
                        break;
                    }
                    case "-gff2": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF2;
                        break;
                    }
                    case "-gtf22": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GTF22;
                        break;
                    }
                    case "-refseq": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.REFSEQ;
                        break;
                    }
                    case "-genbank": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GENBANK;
                        break;
                    }
                    case "-knowngenes": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.KNOWN_GENES;
                        break;
                    }
                    case "-embl": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.EMBL;
                        break;
                    }
                    case "-txt": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.BIOMART;
                        break;
                    }
                    case "-storeseqs": {
                        this.storeSequences = true;
                        break;
                    }
                    case "-nocheckcds": {
                        this.checkCds = false;
                        break;
                    }
                    case "-nocheckprotein": {
                        this.checkProtein = false;
                        break;
                    }
                    case "-nostoreseqs": {
                        this.storeSequences = false;
                        break;
                    }
                    case "-onlyreg": {
                        this.onlyRegulation = true;
                        break;
                    }
                    case "-celltype": {
                        if (i2 + 1 < args.length) {
                            this.cellType = args[++i2];
                            break;
                        }
                        this.usage("Missing 'regType' argument");
                        break;
                    }
                    case "-regsortedbytype": {
                        this.regSortedByType = true;
                        break;
                    }
                    case "-maxerrorrate": {
                        if (i2 + 1 < args.length) {
                            this.maxErrorRate = Gpr.parseDoubleSafe(args[++i2]);
                            break;
                        }
                        this.usage("Missing 'maxErrorPercentage' argument");
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void rareAa(SnpEffectPredictor snpEffectPredictor) {
        block7: {
            if (this.verbose) {
                Log.info("[Optional] Rare amino acid annotations");
            }
            String proteinsFile = this.config.getFileNameProteins();
            try {
                FindRareAaIntervals findRare = new FindRareAaIntervals(snpEffectPredictor.getGenome());
                findRare.setVerbose(this.verbose);
                Collection<RareAminoAcid> raas = findRare.findRareAa(proteinsFile);
                for (RareAminoAcid raa : raas) {
                    if (this.verbose) {
                        Log.info("\tAdding: " + String.valueOf(raa));
                    }
                    snpEffectPredictor.add(raa);
                }
                if (this.verbose) {
                    Log.info("Done.");
                }
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Log.warning(ErrorWarningType.WARNING_FILE_NOT_FOUND, "Rare Amino Acid analysis: Cannot read protein sequence file '" + proteinsFile + "', nothing done.");
                }
                if (!this.debug) break block7;
                t.printStackTrace();
            }
        }
    }

    void readRegulationBed() {
        if (this.verbose) {
            Log.info("[Optional] Reading regulation elements: BED ");
        }
        String inDir = this.config.getDirRegulationBed();
        String outDir = this.config.getDirDataGenomeVersion();
        File dir = new File(inDir);
        if (!dir.exists() || !dir.isDirectory()) {
            if (this.verbose) {
                Log.info("Cannot find optional regulation dir '" + inDir + "', nothing done.");
            }
            return;
        }
        RegulationConsensusMultipleBed regBeds = new RegulationConsensusMultipleBed(inDir, outDir);
        regBeds.setVerbose(this.verbose);
        regBeds.setCellType(this.cellType);
        regBeds.run();
    }

    void readRegulationGff() {
        String regulationFileName;
        if (this.verbose) {
            Log.info("[Optional] Reading regulation elements: GFF");
        }
        if (!Gpr.canRead(regulationFileName = this.config.getBaseFileNameRegulation() + ".gff")) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_FILE_NOT_FOUND, "Cannot read optional regulation file '" + regulationFileName + "', nothing done.");
            }
            return;
        }
        RegulationGffFileIterator regulationFileIterator = new RegulationGffFileIterator(regulationFileName);
        RegulationFileSplitBytType regSplit = new RegulationFileSplitBytType();
        regSplit.setVerbose(this.verbose);
        regSplit.splitFile(regulationFileIterator, this.config.getDirDataGenomeVersion());
        for (String regFileName : regSplit.getRegFileNames()) {
            regulationFileIterator = new RegulationGffFileIterator(regFileName);
            RegulationFileConsensus regulationGffConsensus = new RegulationFileConsensus();
            regulationGffConsensus.setVerbose(this.verbose);
            regulationGffConsensus.setOutputDir(this.config.getDirDataGenomeVersion());
            regulationGffConsensus.readFile(regulationFileIterator);
            regulationGffConsensus.save();
        }
        if (this.verbose) {
            Log.info("Done.");
        }
    }

    void readRegulationMotif() {
        block11: {
            if (this.verbose) {
                Log.info("[Optional] Reading motifs: GFF");
            }
            String motifFileName = this.config.getBaseFileNameMotif() + ".gff";
            String motifBinFileName = this.config.getBaseFileNameMotif() + ".bin";
            String pwmsFileName = this.config.getDirDataGenomeVersion() + "/pwms.bin";
            if (!Gpr.exists(pwmsFileName)) {
                if (this.verbose) {
                    Log.warning(ErrorWarningType.WARNING_FILE_NOT_FOUND, "Cannot open PWMs file " + pwmsFileName + ". Nothing done");
                }
                return;
            }
            try {
                if (this.verbose) {
                    Log.info("\tLoading PWMs from : " + pwmsFileName);
                }
                Jaspar jaspar = new Jaspar();
                jaspar.load(pwmsFileName);
                if (this.verbose) {
                    Log.info("\tLoading motifs from : " + motifFileName);
                }
                MotifFileIterator motifFileIterator = new MotifFileIterator(motifFileName, this.config.getGenome(), jaspar);
                Markers motifs = new Markers();
                for (Motif motif : motifFileIterator) {
                    motifs.add(motif);
                }
                if (this.verbose) {
                    Log.info("\tLoadded motifs: " + motifs.size());
                }
                if (this.verbose) {
                    Log.info("\tSaving motifs to: " + motifBinFileName);
                }
                motifs.save(motifBinFileName);
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Log.warning(ErrorWarningType.WARNING_FILE_NOT_FOUND, "Cannot read optional motif file '" + motifFileName + "', nothing done.");
                }
                if (!this.debug) break block11;
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Log.info("Building database for '" + this.genomeVer + "'");
        }
        this.loadConfig();
        if (!this.onlyRegulation) {
            SnpEffPredictorFactory snpEffectPredictorFactory = this.createSnpEffPredictorFactory();
            SnpEffectPredictor snpEffectPredictor = snpEffectPredictorFactory.create();
            this.config.setSnpEffectPredictor(snpEffectPredictor);
            ExonSpliceCharacterizer exonSpliceCharacterizer = new ExonSpliceCharacterizer(snpEffectPredictor.getGenome());
            exonSpliceCharacterizer.setVerbose(this.verbose);
            exonSpliceCharacterizer.characterize();
            this.rareAa(snpEffectPredictor);
            boolean okCheck = this.checkDb(snpEffectPredictorFactory);
            if (!okCheck) {
                Log.error("Database check failed.");
                return false;
            }
            if (this.verbose) {
                Log.info("Saving database");
            }
            snpEffectPredictor.save(this.config);
        }
        if (this.cellType == null) {
            this.readRegulationGff();
        }
        this.readRegulationBed();
        this.readRegulationMotif();
        if (this.verbose) {
            Log.info("Done");
        }
        return true;
    }

    public void setCheckNumOk(boolean checkNumOk) {
        this.checkNumOk = checkNumOk;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff build [options] genome_version");
        System.err.println("\nBuild DB options:");
        System.err.println("\nDatabase format option (default: Auto detect):");
        System.err.println("\t-embl                        : Use Embl format.");
        System.err.println("\t-genbank                     : Use GenBank format.");
        System.err.println("\t-gff2                        : Use GFF2 format (obsolete).");
        System.err.println("\t-gff3                        : Use GFF3 format.");
        System.err.println("\t-gtf22                       : Use GTF 2.2 format.");
        System.err.println("\t-knowngenes                  : Use KnownGenes table from UCSC.");
        System.err.println("\t-refseq                      : Use RefSeq table from UCSC.");
        System.err.println("\nDatabase build options:");
        System.err.println("\t-cellType <type>             : Only build regulation tracks for cellType <type>.");
        System.err.println("\t-maxErrorRate <num>          : Maximum allowed error rate (number between 0.0 and 1.0). Default: 0.05");
        System.err.println("\t-noCheckCds                  : Skip CDS sequences check.");
        System.err.println("\t-noCheckProtein              : Skip Protein sequences check.");
        System.err.println("\t-noStoreSeqs                 : Do not store sequence in binary files. Default: " + !this.storeSequences);
        System.err.println("\t-onlyReg                     : Only build regulation tracks.");
        System.err.println("\t-regSortedByType             : The 'regulation.gff' file is sorted by 'regulation type' instead of sorted by chromosome:pos. Default: " + this.regSortedByType);
        System.err.println("\t-storeSeqs                   : Store sequence in binary files. Default: " + this.storeSequences);
        this.usageGeneric();
        System.exit(-1);
    }
}

