/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;

public class SnpEffCmdAcat
extends SnpEff {
    public static final String ACAT = "ACAT";
    public static final String NCCAT = "NCCAT";
    public static final String NCACTIVITY = "NCACTIVITY";
    public static final String NCMARK = "NCMARK";
    public static final String NCFACTOR = "NCFACTOR";
    public static final String NCELEMENT = "NCELEMENT";
    public static final String NCCONS = "NCCONS";
    public static final String T2D_GENES = "T2D_GENES";
    public static final double CONSERVATION_THRESHOLD = 0.99;
    String vcfFile;
    int testNum;
    CountByType countByAcat;
    CountByType countByEff;

    void acat(VcfEntry ve) {
        boolean hasMotif = false;
        boolean hasReg = false;
        int minAcatScore = Integer.MAX_VALUE;
        StringBuilder acat = new StringBuilder();
        String acatKey = null;
        int nccat = Integer.MAX_VALUE;
        StringBuilder ncmark = new StringBuilder();
        StringBuilder ncfactor = new StringBuilder();
        StringBuilder ncelement = new StringBuilder();
        double cons = ve.getInfoFloat("PhastCons");
        if (Double.isNaN(cons)) {
            cons = 0.0;
        }
        for (VcfEffect veff : ve.getVcfEffects()) {
            if (this.verbose) {
                this.countByEff.inc(veff.getEffectType().toString());
                if (veff.getEffectDetails() != null && !veff.getEffectDetails().isEmpty()) {
                    this.countByEff.inc(String.valueOf((Object)veff.getEffectType()) + "[" + veff.getEffectDetails() + "]");
                }
            }
            if (veff.getErrorsWarning() != null) continue;
            VariantEffect.EffectImpact impact = veff.getImpact();
            int acatScore = impact.ordinal() + 1;
            String key = null;
            if (acatScore < 4) {
                String trId;
                if (acatScore < minAcatScore && acat.length() > 0) {
                    acat = new StringBuilder();
                }
                if (acatScore > minAcatScore) continue;
                minAcatScore = acatScore;
                String gene = veff.getGeneName() != null ? veff.getGeneName() : "";
                String string = trId = veff.getTranscriptId() != null ? veff.getTranscriptId() : "";
                if (acat.length() > 0) {
                    acat.append(",");
                }
                acat.append(gene + ":" + trId + ":" + acatScore);
                acatKey = "CODING:" + String.valueOf((Object)veff.getImpact()) + ":" + String.valueOf((Object)veff.getEffectType());
                continue;
            }
            switch (veff.getEffectType()) {
                case REGULATION: {
                    if (ncmark.length() > 0) {
                        ncmark.append(",");
                    }
                    ncmark.append(String.valueOf((Object)veff.getBioType()) + ":" + veff.getEffectDetails());
                    if (ncelement.length() > 0) {
                        ncelement.append(",");
                    }
                    ncelement.append("CHROM");
                    key = "REGULATION:" + String.valueOf((Object)veff.getBioType()) + ":" + veff.getEffectDetails();
                    hasReg = true;
                    break;
                }
                case MOTIF: {
                    if (ncfactor.length() > 0) {
                        ncfactor.append(",");
                    }
                    ncfactor.append(veff.getEffectDetails());
                    if (ncelement.length() > 0) {
                        ncelement.append(",");
                    }
                    ncelement.append("TFBS");
                    key = "MOTIF:" + veff.getEffectDetails();
                    hasMotif = true;
                    break;
                }
            }
            if (!this.verbose || key == null) continue;
            this.countByAcat.inc(key);
        }
        if (minAcatScore < 4) {
            this.countByAcat.inc(acatKey);
        } else if (hasMotif && hasReg) {
            nccat = 1;
        } else if (hasMotif) {
            nccat = 2;
        } else if (hasReg) {
            nccat = 3;
        } else if (cons > 0.99) {
            nccat = 4;
        }
        if (acat.length() > 0) {
            ve.addInfo(ACAT, acat.toString());
        }
        if (minAcatScore >= 4) {
            if (ncmark.length() > 0) {
                ve.addInfo(NCMARK, ncmark.toString());
            }
            if (ncfactor.length() > 0) {
                ve.addInfo(NCFACTOR, ncfactor.toString());
            }
            if (nccat <= 4) {
                ve.addInfo(NCCAT, "" + nccat);
            }
            if (cons >= 0.99) {
                ve.addInfo(NCCONS, String.format("%.2f", cons));
            }
        }
        if (minAcatScore <= 4) {
            this.countByAcat.inc("CODING_CATEGORY:" + minAcatScore);
        }
        if (nccat <= 4) {
            this.countByAcat.inc("NON_CODING_CATEGORY:" + nccat);
        }
    }

    void addHeader(VcfFileIterator vcf) {
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(ACAT, VcfInfoType.Integer, ".", "Variant coding impact category {1, 2, 3, 4} correspond to {HIGH, MODERATE, LOW, MODIFIER}. Most deleterious effect is selected."));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCCAT, VcfInfoType.Integer, ".", "Variant non-coding impact category {1, 2, 3, 4} correspond to {MOTIF + REGULATORY, MOTIF, REGULATORY, CONSERVED }"));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCACTIVITY, VcfInfoType.String, ".", "Chromatin state predicted activity. Format is Tissue:Activity (e.g. Liver:Enhancer, Adipose:Insulator, etc.)"));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCMARK, VcfInfoType.String, ".", "Chromatin mark predicted. Format is Tissue:Mark (e.g. Liver:H3K4me1, Adipose:H3K27me3, etc.)"));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCFACTOR, VcfInfoType.String, ".", "Transcription factor mark predicted. Format is Tissue:FactorId:FactorName (e.g. Liver:MA0139.1:CTCF, Adipose:MA0003.1:Ap2alpha, etc.)"));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCELEMENT, VcfInfoType.String, ".", "Types of non-coding elements predicted {STATE, MARK, TFBS, etc.}"));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(NCCONS, VcfInfoType.Float, ".", "Conservation score above threshold (threshold is 0.99). Score used: PhastCons."));
        vcf.getVcfHeader().addInfo(new VcfHeaderInfo(T2D_GENES, VcfInfoType.Flag, ".", "Variant exclusive from T2D_GENES project (i.e. neither in dbSnp, 1000 Genomes nor ESP)"));
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length != 1) {
            this.usage("Missing file.vcf");
        } else {
            this.vcfFile = args[0];
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Log.info("Calculating ACAT score on input: " + this.vcfFile);
        }
        this.countByAcat = new CountByType();
        this.countByEff = new CountByType();
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                this.addHeader(vcf);
                System.out.println(vcf.getVcfHeader());
            }
            this.acat(ve);
            this.t2dGenes(ve);
            if (this.quiet) continue;
            System.out.println(ve);
        }
        if (this.verbose) {
            System.err.println(this.countByAcat);
            System.err.println(this.countByEff);
            Log.info("Done.");
        }
        return true;
    }

    void t2dGenes(VcfEntry ve) {
        if (ve.getId() == null || ve.getId().isEmpty()) {
            ve.addInfo(T2D_GENES, null);
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff acat file.vcf");
        System.exit(-1);
    }
}

