/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class VariantEffects
implements Iterable<VariantEffect> {
    public static boolean debug = false;
    List<VariantEffect> effects = new ArrayList<VariantEffect>();

    public void add(Variant variant, Marker marker, EffectType effectType, VariantEffect.EffectImpact effectImpact, String message) {
        VariantEffect effNew = new VariantEffect(variant);
        effNew.set(marker, effectType, effectImpact, message);
        this.add(effNew);
    }

    public void add(Variant variant, Marker marker, EffectType effectType, String message) {
        this.add(variant, marker, effectType, effectType.effectImpact(), message);
    }

    public void add(VariantEffect variantEffect) {
        this.effects.add(variantEffect);
    }

    public void addEffectType(Variant variant, Marker marker, EffectType effectType) {
        if (this.canAddType(variant, marker)) {
            this.get().addEffect(effectType);
        } else {
            this.add(variant, marker, effectType, effectType.effectImpact(), "");
        }
    }

    public void addErrorWarning(Variant variant, ErrorWarningType errwarn) {
        VariantEffect veff = this.get();
        if (veff != null) {
            veff.addErrorWarningInfo(errwarn);
        } else {
            if (debug) {
                Log.debug("Could not get latest " + VariantEffect.class.getSimpleName());
            }
            veff = new VariantEffect(variant);
            veff.addErrorMessage(errwarn);
            this.add(veff);
        }
    }

    boolean canAddType(Variant variant, Marker marker) {
        VariantEffect veff = this.get();
        if (veff == null || veff.getVariant() == null) {
            return false;
        }
        String gt = veff.getVariant().getGenotype();
        String vgt = variant.getGenotype();
        if (vgt != null ^ gt != null || vgt != null && gt != null && !variant.getGenotype().equals(variant.getGenotype())) {
            return false;
        }
        Transcript trMarker = (Transcript)marker.findParent(Transcript.class);
        Transcript tr = veff.getTranscript();
        if (tr == null || trMarker == null) {
            return false;
        }
        return tr.getId().equals(trMarker.getId());
    }

    public VariantEffect get() {
        if (this.effects.isEmpty()) {
            return null;
        }
        return this.effects.get(this.effects.size() - 1);
    }

    public VariantEffect get(int index) {
        return this.effects.get(index);
    }

    public boolean hasMarker() {
        VariantEffect veff = this.get();
        if (veff == null) {
            return false;
        }
        return veff.getMarker() != null;
    }

    public VariantEffect.EffectImpact highestImpact(String trId) {
        VariantEffect.EffectImpact effectImpact = null;
        for (VariantEffect veff : this) {
            if (trId != null && !trId.equals(veff.getTranscript().getId())) continue;
            if (effectImpact == null) {
                effectImpact = veff.getEffectImpact();
                continue;
            }
            if (effectImpact.compareTo(veff.getEffectImpact()) >= 0) continue;
            effectImpact = veff.getEffectImpact();
        }
        return effectImpact;
    }

    public boolean isEmpty() {
        return this.effects.isEmpty();
    }

    @Override
    public Iterator<VariantEffect> iterator() {
        return this.effects.iterator();
    }

    public void setMarker(Marker marker) {
        VariantEffect veff = this.get();
        if (veff != null) {
            veff.setMarker(marker);
        } else {
            Log.debug("Could not get latest VariantEffect");
        }
    }

    public int size() {
        return this.effects.size();
    }

    public void sort() {
        Collections.sort(this.effects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Effects; " + this.size() + "\n");
        for (VariantEffect eff : this) {
            sb.append(Gpr.prependEachLine("\t", eff.toStr()) + "\n");
        }
        return sb.toString();
    }
}

