/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Utr;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffectStructural;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Gpr;

public class SnpEffectPredictor
implements Serializable {
    public static final int DEFAULT_UP_DOWN_LENGTH = 5000;
    public static final int SMALL_VARIANT_SIZE_THRESHOLD = 10;
    private static final long serialVersionUID = 4519418862303325081L;
    boolean useChromosomes = true;
    boolean debug;
    int upDownStreamLength = 5000;
    int spliceSiteSize = 2;
    int spliceRegionExonSize = 3;
    int spliceRegionIntronMin = 3;
    int spliceRegionIntronMax = 8;
    Genome genome;
    Markers markers;
    IntervalForest intervalForest;

    public SnpEffectPredictor(Genome genome) {
        this.genome = genome;
        this.markers = new Markers();
    }

    public static SnpEffectPredictor load(Config config) {
        String snpEffPredFile = config.getFileSnpEffectPredictor();
        if (!Gpr.canRead(snpEffPredFile)) {
            throw new RuntimeException("\tERROR: Cannot read file '" + snpEffPredFile + "'.\n\tYou can try to download the database by running the following command:\n\t\tjava -jar snpEff.jar download " + config.getGenome().getVersion() + "\n");
        }
        MarkerSerializer ms = new MarkerSerializer(config.getGenome());
        Markers markers = ms.load(snpEffPredFile);
        Genome genome = null;
        for (Marker m : markers) {
            if (!(m instanceof Genome)) continue;
            genome = (Genome)m;
        }
        if (genome == null) {
            throw new RuntimeException("Genome not found. This should never happen!");
        }
        SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(genome);
        for (Marker m : markers) {
            if (!(m instanceof Gene)) continue;
            Gene gene = (Gene)m;
            snpEffectPredictor.add(gene);
        }
        for (Marker m : markers) {
            if (m instanceof Genome || m instanceof Chromosome || m instanceof Gene || m instanceof Transcript || m instanceof Exon || m instanceof Cds || m instanceof Utr || m instanceof SpliceSite) continue;
            snpEffectPredictor.add(m);
        }
        return snpEffectPredictor;
    }

    public void add(Gene gene) {
        this.genome.getGenes().add(gene);
    }

    public void add(Marker marker) {
        this.markers.add(marker);
    }

    public void addAll(Markers markersToAdd) {
        this.markers.addAll(markersToAdd);
    }

    public void buildForest() {
        this.intervalForest = new IntervalForest();
        this.intervalForest.setDebug(this.debug);
        if (this.useChromosomes) {
            for (Chromosome chr : this.genome) {
                this.intervalForest.add(chr);
            }
        }
        this.genome.getGenes().createCircularGenes();
        for (Gene gene : this.genome.getGenes()) {
            this.intervalForest.add(gene);
        }
        this.markers.add(this.createGenomicRegions());
        this.canonical();
        this.intervalForest.add(this.markers);
        this.intervalForest.build();
        this.buildPerGene();
    }

    void buildPerGene() {
        for (Gene gene : this.genome.getGenes()) {
            gene.buildPerGene();
        }
    }

    void canonical() {
        for (Gene g : this.genome.getGenes()) {
            g.canonical();
        }
    }

    public int countTranscripts() {
        int total = 0;
        for (Gene g : this.genome.getGenes()) {
            total += g.numChilds();
        }
        return total;
    }

    public Markers createGenomicRegions() {
        Markers markers = new Markers();
        markers.addAll((Collection<? extends Marker>)this.genome.getGenes().createUpDownStream(this.upDownStreamLength));
        this.genome.getGenes().createSpliceSites(this.spliceSiteSize, this.spliceRegionExonSize, this.spliceRegionIntronMin, this.spliceRegionIntronMax);
        markers.addAll((Collection<? extends Marker>)this.genome.getGenes().createIntergenic());
        return markers;
    }

    public void filterTags(Set<String> tags, Set<String> tagsNo) {
        for (Gene g : this.genome.getGenes()) {
            g.filterTags(tags, tagsNo);
        }
    }

    public void filterTranscriptSupportLevel(TranscriptSupportLevel maxTsl) {
        for (Gene g : this.genome.getGenes()) {
            g.filterTranscriptSupportLevel(maxTsl);
        }
    }

    public Gene getGene(String geneId) {
        return this.genome.getGenes().get(geneId);
    }

    public Genome getGenome() {
        return this.genome;
    }

    public IntervalForest getIntervalForest() {
        return this.intervalForest;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public int getSpliceRegionExonSize() {
        return this.spliceRegionExonSize;
    }

    public void setSpliceRegionExonSize(int spliceRegionExonSize) {
        this.spliceRegionExonSize = spliceRegionExonSize;
    }

    public int getSpliceRegionIntronMax() {
        return this.spliceRegionIntronMax;
    }

    public void setSpliceRegionIntronMax(int spliceRegionIntronMax) {
        this.spliceRegionIntronMax = spliceRegionIntronMax;
    }

    public int getSpliceRegionIntronMin() {
        return this.spliceRegionIntronMin;
    }

    public void setSpliceRegionIntronMin(int spliceRegionIntronMin) {
        this.spliceRegionIntronMin = spliceRegionIntronMin;
    }

    public Transcript getTranscript(String trId) {
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                if (!tr.getId().equals(trId)) continue;
                return tr;
            }
        }
        return null;
    }

    public int getUpDownStreamLength() {
        return this.upDownStreamLength;
    }

    public void setUpDownStreamLength(int upDownStreamLength) {
        this.upDownStreamLength = upDownStreamLength;
    }

    boolean isChromosomeMissing(Marker marker) {
        if (marker.getChromosome() == null) {
            return true;
        }
        String chrName = marker.getChromosomeName();
        Chromosome chr = this.genome.getChromosome(chrName);
        if (chr == null) {
            return true;
        }
        if (chr.size() < 1) {
            return true;
        }
        return !this.intervalForest.hasTree(chrName);
    }

    public int keepTranscriptsProteinCoding() {
        int total = 0;
        for (Gene g : this.genome.getGenes()) {
            total += g.keepTranscriptsProteinCoding();
        }
        return total;
    }

    public void print() {
        System.out.println(this.genome);
        for (Gene gene : this.genome.getGenes().sorted()) {
            System.out.println(gene);
        }
        for (Marker marker : this.markers) {
            System.out.println(marker);
        }
    }

    public Markers query(Marker marker) {
        return marker.query(this.intervalForest);
    }

    public Gene queryClosestGene(Marker inputInterval) {
        int initialExtension = 1000;
        String chrName = inputInterval.getChromosomeName();
        Chromosome chr = this.genome.getChromosome(chrName);
        if (chr == null) {
            return null;
        }
        if (chr.size() > 0) {
            for (int extend = initialExtension; extend < chr.size(); extend *= 2) {
                int start = Math.max(inputInterval.getStart() - extend, 0);
                int end = inputInterval.getEnd() + extend;
                Marker extended = new Marker(chr, start, end, false, "");
                Markers markers = this.query(extended);
                Markers genes = new Markers();
                int minDist = Integer.MAX_VALUE;
                for (Marker m : markers) {
                    int dist;
                    if (!(m instanceof Gene) || (dist = m.distance(inputInterval)) >= minDist) continue;
                    genes.add(m);
                    minDist = dist;
                }
                if (genes.size() <= 0) continue;
                Gene minDistGene = null;
                for (Marker m : genes) {
                    int dist = m.distance(inputInterval);
                    if (dist != minDist) continue;
                    Gene gene = (Gene)m;
                    if (minDistGene == null) {
                        minDistGene = gene;
                        continue;
                    }
                    if (minDistGene.isProteinCoding() || !gene.isProteinCoding()) continue;
                    minDistGene = gene;
                }
                return minDistGene;
            }
        }
        return null;
    }

    public Markers queryDeep(Marker marker) {
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(marker)) {
            throw new RuntimeException("Chromosome missing for marker: " + String.valueOf(marker));
        }
        boolean hitChromo = false;
        Markers hits = new Markers();
        Markers intersects = this.query(marker);
        if (intersects.size() > 0) {
            for (Marker m : intersects) {
                hits.add(m);
                if (m instanceof Chromosome) {
                    hitChromo = true;
                    continue;
                }
                if (!(m instanceof Gene)) continue;
                Gene gene = (Gene)m;
                hits.addAll(gene.query(marker));
            }
        }
        if (!hitChromo && Config.get().isErrorChromoHit()) {
            throw new RuntimeException("ERROR: Out of chromosome range. " + String.valueOf(marker));
        }
        return hits;
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        return this.regions(marker, showGeneDetails, compareTemplate, null);
    }

    public Set<String> regions(Marker marker, boolean showGeneDetails, boolean compareTemplate, String id) {
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(marker)) {
            throw new RuntimeException("Chromosome missing for marker: " + String.valueOf(marker));
        }
        boolean hitChromo = false;
        HashSet<String> hits = new HashSet<String>();
        Markers intersects = this.query(marker);
        if (intersects.size() > 0) {
            for (Marker markerInt : intersects) {
                if (markerInt instanceof Chromosome) {
                    hitChromo = true;
                    hits.add(markerInt.getClass().getSimpleName());
                    continue;
                }
                if (markerInt instanceof Gene) {
                    Gene gene = (Gene)markerInt;
                    this.regionsAddHit(hits, gene, marker, showGeneDetails, compareTemplate);
                    for (Transcript tr : gene) {
                        if (id != null && !gene.getId().equals(id) && !tr.getId().equals(id) || !tr.intersects(marker)) continue;
                        this.regionsAddHit(hits, tr, marker, showGeneDetails, compareTemplate);
                        for (Utr utr : tr.getUtrs()) {
                            if (!utr.intersects(marker)) continue;
                            this.regionsAddHit(hits, utr, marker, showGeneDetails, compareTemplate);
                        }
                        for (Exon ex : tr) {
                            if (!ex.intersects(marker)) continue;
                            this.regionsAddHit(hits, ex, marker, showGeneDetails, compareTemplate);
                        }
                        for (Intron intron : tr.introns()) {
                            if (!intron.intersects(marker)) continue;
                            this.regionsAddHit(hits, intron, marker, showGeneDetails, compareTemplate);
                        }
                    }
                    continue;
                }
                if (id == null) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Transcript tr = (Transcript)markerInt.findParent(Transcript.class);
                if (tr != null && tr.getId().equals(id)) {
                    this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
                    continue;
                }
                Gene gene = (Gene)markerInt.findParent(Gene.class);
                if (gene == null || !gene.getId().equals(id)) continue;
                this.regionsAddHit(hits, markerInt, marker, showGeneDetails, compareTemplate);
            }
        }
        if (!hitChromo) {
            throw new RuntimeException("ERROR: Out of chromosome range. " + String.valueOf(marker));
        }
        return hits;
    }

    void regionsAddHit(HashSet<String> hits, Marker hit2add, Marker marker, boolean showGeneDetails, boolean compareTemplate) {
        Gene gene;
        Object hitStr = hit2add.getClass().getSimpleName();
        if (compareTemplate && (gene = (Gene)hit2add.findParent(Gene.class)) != null) {
            hitStr = (String)hitStr + (hit2add.isStrandPlus() == marker.isStrandPlus() ? "_TEMPLATE_STRAND" : "_NON_TEMPLATE_STRAND");
        }
        if (showGeneDetails && hit2add instanceof Gene) {
            gene = (Gene)hit2add;
            hitStr = (String)hitStr + "[" + String.valueOf((Object)gene.getBioType()) + ", " + gene.getGeneName() + ", " + (gene.isProteinCoding() ? "protein" : "not-protein") + "]";
        }
        hits.add((String)hitStr);
    }

    public void removeNonCanonical(String canonFile) {
        HashMap<String, String> geneCanonTr = new HashMap<String, String>();
        if (canonFile != null && !canonFile.isEmpty()) {
            String lines = Gpr.readFile(canonFile).trim();
            if (lines.isEmpty()) {
                throw new RuntimeException("Empty or missing file '" + canonFile + "'");
            }
            for (String line : lines.split("\n")) {
                String[] fields = line.split("\t");
                String geneId = fields[0].trim();
                String trId = fields[1].trim();
                geneCanonTr.put(geneId, trId);
            }
        }
        HashSet done = new HashSet(geneCanonTr.keySet());
        for (Gene g2 : this.genome.getGenes()) {
            String geneId = g2.getId();
            String trId = (String)geneCanonTr.get(geneId);
            g2.removeNonCanonical(trId);
            done.remove(geneId);
        }
        if (done.size() > 0) {
            StringBuilder sb = new StringBuilder();
            done.forEach(g -> sb.append(g + " "));
            throw new RuntimeException("Canonical gene list file '" + canonFile + "' has gene Ids that do not match any gene: " + String.valueOf(sb));
        }
    }

    public boolean removeUnverified() {
        boolean allRemoved = true;
        for (Gene g : this.genome.getGenes()) {
            allRemoved &= g.removeUnverified();
        }
        return allRemoved;
    }

    public int retainAllTranscripts(Set<String> trIds) {
        int total = 0;
        for (Gene g : this.genome.getGenes()) {
            total += g.keepTranscripts(trIds);
        }
        return total;
    }

    public void save(Config config) {
        String databaseFile = config.getFileSnpEffectPredictor();
        this.save(databaseFile);
        GenomicSequences gs = this.genome.getGenomicSequences();
        gs.setVerbose(config.isVerbose());
        gs.save(config);
    }

    public void save(String fileName) {
        Markers markersToSave = new Markers();
        markersToSave.add(this.genome);
        for (Chromosome chr : this.genome) {
            markersToSave.add(chr);
        }
        for (Gene g : this.genome.getGenes()) {
            markersToSave.add(g);
        }
        markersToSave.add(this.getMarkers());
        markersToSave.save(fileName);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSpliceSiteSize(int spliceSiteSize) {
        this.spliceSiteSize = spliceSiteSize;
    }

    public void setUseChromosomes(boolean useChromosomes) {
        this.useChromosomes = useChromosomes;
    }

    public int size() {
        if (this.intervalForest == null) {
            return 0;
        }
        return this.intervalForest.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genome.getVersion() + "\n");
        for (Chromosome chr : this.genome) {
            sb.append(String.valueOf(chr) + "\n");
        }
        sb.append(this.genome.getGenes());
        return sb.toString();
    }

    public VariantEffects variantEffect(Variant variant) {
        VariantEffects variantEffects = new VariantEffects();
        if (Config.get().isErrorOnMissingChromo() && this.isChromosomeMissing(variant)) {
            variantEffects.addErrorWarning(variant, ErrorWarningType.ERROR_CHROMOSOME_NOT_FOUND);
            return variantEffects;
        }
        if (variant.isBnd()) {
            Markers intersects = this.query(variant);
            this.variantEffectBnd(variant, variantEffects, intersects);
            return variantEffects;
        }
        boolean structuralVariant = variant.isStructural() && variant.size() > 10;
        Markers intersects = null;
        boolean structuralHuge = structuralVariant && variant.isStructuralHuge();
        intersects = structuralHuge ? this.variantEffectStructuralLarge(variant, variantEffects) : this.query(variant);
        if (structuralVariant && this.variantEffectStructural(variant, variantEffects, intersects)) {
            return variantEffects;
        }
        this.variantEffect(variant, variantEffects, intersects);
        return variantEffects;
    }

    protected void variantEffect(Variant variant, VariantEffects variantEffects, Markers intersects) {
        boolean hitChromo = false;
        boolean hitSomething = false;
        ArrayList<Marker> deferredMarkers = null;
        for (Marker marker : intersects) {
            if (marker instanceof Chromosome) {
                hitChromo = true;
                continue;
            }
            if (marker.isDeferredAnalysis()) {
                if (deferredMarkers == null) {
                    deferredMarkers = new ArrayList<Marker>();
                }
                deferredMarkers.add(marker);
                continue;
            }
            if (variant.isNonRef()) {
                marker.variantEffectNonRef(variant, variantEffects);
            } else {
                marker.variantEffect(variant, variantEffects);
            }
            hitSomething = true;
        }
        if (deferredMarkers != null) {
            for (Marker marker : deferredMarkers) {
                marker.variantEffect(variant, variantEffects);
            }
        }
        if (!hitChromo) {
            Chromosome chr = this.genome.getChromosome(variant.getChromosomeName());
            if (variant.isIns() && variant.getStart() == chr.getEnd() + 1) {
                variantEffects.add(variant, null, EffectType.CHROMOSOME_ELONGATION, "");
            } else if (Config.get().isErrorChromoHit()) {
                variantEffects.addErrorWarning(variant, ErrorWarningType.ERROR_OUT_OF_CHROMOSOME_RANGE);
            }
        } else if (!hitSomething) {
            if (Config.get().isOnlyRegulation()) {
                variantEffects.add(variant, null, EffectType.NONE, "");
            } else {
                variantEffects.add(variant, null, EffectType.INTERGENIC, "");
            }
        }
    }

    void variantEffectBnd(Variant variant, VariantEffects variantEffects, Markers intersects) {
        VariantEffectStructural veff = new VariantEffectStructural(variant, intersects);
        List<VariantEffect> veffFusions = veff.fusions();
        if (veffFusions != null) {
            for (VariantEffect veffFusion : veffFusions) {
                variantEffects.add(veffFusion);
            }
        }
    }

    boolean variantEffectStructural(Variant variant, VariantEffects variantEffects, Markers intersects) {
        List<VariantEffect> veffFusions;
        boolean added = false;
        VariantEffectStructural veff = new VariantEffectStructural(variant, intersects);
        if (veff.getEffectType() != EffectType.NONE) {
            variantEffects.add(veff);
            added = true;
        }
        if ((veffFusions = veff.fusions()) != null && !veffFusions.isEmpty()) {
            for (VariantEffect veffFusion : veffFusions) {
                added = true;
                variantEffects.add(veffFusion);
            }
        }
        if (variant.isDup() || variant.isDel()) {
            return false;
        }
        return added;
    }

    Markers variantEffectStructuralLarge(Variant variant, VariantEffects variantEffects) {
        EffectType effExon;
        EffectType effTr;
        EffectType effGene;
        EffectType eff;
        EffectType effExonPartial = switch (variant.getVariantType()) {
            case Variant.VariantType.DEL -> {
                eff = EffectType.CHROMOSOME_LARGE_DELETION;
                effGene = EffectType.GENE_DELETED;
                effTr = EffectType.TRANSCRIPT_DELETED;
                effExon = EffectType.EXON_DELETED;
                yield EffectType.EXON_DELETED_PARTIAL;
            }
            case Variant.VariantType.DUP -> {
                eff = EffectType.CHROMOSOME_LARGE_DUPLICATION;
                effGene = EffectType.GENE_DUPLICATION;
                effTr = EffectType.TRANSCRIPT_DUPLICATION;
                effExon = EffectType.EXON_DUPLICATION;
                yield EffectType.EXON_DUPLICATION_PARTIAL;
            }
            case Variant.VariantType.INV -> {
                eff = EffectType.CHROMOSOME_LARGE_INVERSION;
                effGene = EffectType.GENE_INVERSION;
                effTr = EffectType.TRANSCRIPT_INVERSION;
                effExon = EffectType.EXON_INVERSION;
                yield EffectType.EXON_INVERSION_PARTIAL;
            }
            default -> throw new RuntimeException("Unimplemented option for variant type " + String.valueOf((Object)variant.getVariantType()));
        };
        variantEffects.add(variant, variant.getChromosome(), eff, "");
        return this.variantEffectStructuralLargeGenes(variant, variantEffects, effGene, effTr, effExon, effExonPartial);
    }

    Markers variantEffectStructuralLargeGenes(Variant variant, VariantEffects variantEffects, EffectType effGene, EffectType effTr, EffectType effExon, EffectType effExonPartial) {
        Markers intersect = new Markers();
        for (Gene g : this.genome.getGenes()) {
            if (!variant.intersects(g)) continue;
            intersect.add(g);
            variantEffects.add(variant, g, effGene, "");
            for (Transcript tr : g) {
                if (variant.includes(tr)) {
                    intersect.add(tr);
                    variantEffects.add(variant, tr, effTr, "");
                    continue;
                }
                if (!variant.intersects(tr)) continue;
                intersect.add(tr);
                for (Exon ex : tr) {
                    if (variant.includes(ex)) {
                        variantEffects.add(variant, ex, effExon, "");
                        continue;
                    }
                    if (!variant.intersects(ex)) continue;
                    variantEffects.add(variant, ex, effExonPartial, "");
                }
            }
        }
        return intersect;
    }
}

