/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Log;

public class ProteinFastaWriter {
    String fileName;
    BufferedWriter writer;
    Set<String> transcriptIDsReferenceDone;
    Set<String> proteinSequenceDone;
    boolean noRef;
    boolean verbose;

    public ProteinFastaWriter(String fileName, boolean noRef, boolean verbose) {
        this.fileName = fileName;
        this.verbose = verbose;
        this.noRef = noRef;
        this.transcriptIDsReferenceDone = new HashSet<String>();
        this.proteinSequenceDone = new HashSet<String>();
        if (new File(fileName).delete() && verbose) {
            Log.warning("Deleted protein fasta output file '" + fileName + "'");
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(fileName, true));
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to open Protein Fasta output file '" + fileName + "'", e);
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing Protein FASTA output file '" + this.fileName + "'", e);
            }
        }
    }

    String proteinSequence(Transcript tr) {
        char aa;
        String sequence = tr.protein();
        CodonTable codonTable = tr.codonTable();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < sequence.length() && !codonTable.isStopAaSymbol(aa = sequence.charAt(i2)); ++i2) {
            sb.append(aa);
        }
        return sb.toString();
    }

    public void write(Variant var, VariantEffects variantEffects) {
        HashSet<String> doneTr = new HashSet<String>();
        for (VariantEffect varEff : variantEffects) {
            Transcript tr = varEff.getTranscript();
            if (tr == null || doneTr.contains(tr.getId())) continue;
            Transcript trAlt = tr.apply(var);
            StringBuilder sb = new StringBuilder();
            String proteinSequenceRef = this.proteinSequence(tr);
            if (!this.noRef && !this.transcriptIDsReferenceDone.contains(tr.getId())) {
                sb.append(">" + tr.getId() + (String)(tr.getGene() != null ? ", gene: " + tr.getGene().getGeneName() : "") + (String)(tr.getProteinId() != null ? ", protein_id: " + tr.getProteinId() : "") + ", reference\n" + proteinSequenceRef + "\n");
            }
            this.proteinSequenceDone.add(proteinSequenceRef);
            String proteinSequenceAlt = this.proteinSequence(trAlt);
            if (!this.proteinSequenceDone.contains(proteinSequenceAlt)) {
                sb.append(">" + tr.getId() + (String)(tr.getGene() != null ? ", gene: " + tr.getGene().getGeneName() : "") + (String)(tr.getProteinId() != null ? ", protein_id: " + tr.getProteinId() : "") + ", variant:q " + var.getChromosomeName() + ":" + (var.getStart() + 1) + "-" + (var.getEnd() + 1) + ", ref:'" + var.getReference() + "', alt:'" + var.getAlt() + "', HGVS.p: " + varEff.getHgvsProt() + "\n" + proteinSequenceAlt + "\n");
                this.proteinSequenceDone.add(proteinSequenceAlt);
            }
            try {
                this.writer.write(sb.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Error while trying to write to Protein Fasta file '" + this.fileName + "'", e);
            }
            this.transcriptIDsReferenceDone.add(tr.getId());
            doneTr.add(tr.getId());
        }
    }
}

