/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import org.snpeff.interval.CytoBands;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.Hgvs;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class HgvsDna
extends Hgvs {
    public static boolean debug = false;

    public HgvsDna(VariantEffect variantEffect) {
        super(variantEffect);
    }

    protected String alt() {
        return this.variant.getAlt();
    }

    protected String dnaBaseChange() {
        switch (this.variant.getVariantType()) {
            case SNP: {
                if (this.strandPlus) {
                    return this.ref() + ">" + this.alt();
                }
                return GprSeq.reverseWc(this.ref()) + ">" + GprSeq.reverseWc(this.alt());
            }
            case MNP: {
                String alt;
                String ref;
                if (this.strandPlus) {
                    ref = this.ref();
                    alt = this.alt();
                } else {
                    ref = GprSeq.reverseWc(this.ref());
                    alt = GprSeq.reverseWc(this.alt());
                }
                return "del" + ref + "ins" + alt;
            }
            case DEL: 
            case DUP: 
            case INS: {
                if (this.variant.size() > 100) {
                    return "";
                }
                String netChange = this.variant.netChange(false);
                if (this.strandPlus) {
                    return netChange;
                }
                return GprSeq.reverseWc(netChange);
            }
            case MIXED: {
                if (this.strandPlus) {
                    return "del" + this.ref() + "ins" + this.alt();
                }
                return "del" + GprSeq.reverseWc(this.ref()) + "ins" + GprSeq.reverseWc(this.alt());
            }
            case INV: {
                return "";
            }
            case INTERVAL: {
                return "";
            }
            case BND: {
                return "";
            }
        }
        throw new RuntimeException("Unimplemented method for variant type " + String.valueOf((Object)this.variant.getVariantType()));
    }

    boolean isDownstream(int pos) {
        if (this.tr.isStrandPlus()) {
            return this.tr.getEnd() < pos;
        }
        return pos < this.tr.getStart();
    }

    protected boolean isDuplication() {
        int send;
        int sstart;
        if (!this.variant.isIns()) {
            return false;
        }
        String seq = null;
        int len = this.alt().length();
        if (this.strandPlus) {
            sstart = Math.max(0, this.variant.getStart() - len);
            send = this.variant.getStart() - 1;
        } else {
            sstart = this.variant.getStart();
            send = sstart + (len - 1);
        }
        Marker m = new Marker(this.variant.getParent(), sstart, send, false, "");
        Exon ex = this.variantEffect.getExon();
        if (ex != null && ex.includes(m)) {
            if (debug) {
                Log.debug("Variant: " + String.valueOf(this.variant) + "\n\tmarker: " + m.toStr() + "\tsstart:" + sstart + "\tsend: " + send + "\n\texon: " + String.valueOf(ex) + "\n\tstrand: " + (this.strandPlus ? "+" : "-"));
            }
            seq = ex.getSequence(m);
            if (debug) {
                Log.debug("Sequence (Exon)  [ " + sstart + " , " + send + " ]: '" + seq + "'\talt: '" + this.alt() + "'\tsequence (+ strand): " + (ex.isStrandPlus() ? ex.getSequence() : GprSeq.reverseWc(ex.getSequence())));
            }
        }
        if (seq == null) {
            seq = this.genome.getGenomicSequences().querySequence(m);
            if (debug) {
                Log.debug("Sequence (Genome) [ " + sstart + " , " + send + " ]: '" + seq + "'\talt: '" + this.alt() + "'\tsequence (+ strand): " + seq);
            }
        }
        if (seq == null) {
            return false;
        }
        return seq.equalsIgnoreCase(this.alt());
    }

    boolean isUpstream(int pos) {
        if (this.tr.isStrandPlus()) {
            return pos < this.tr.getStart();
        }
        return this.tr.getEnd() < pos;
    }

    protected String pos() {
        int posStart = -1;
        int posEnd = -1;
        int variantPosStart = this.strandPlus ? this.variant.getStart() : this.variant.getEnd();
        switch (this.variant.getVariantType()) {
            case SNP: {
                posStart = posEnd = variantPosStart;
                break;
            }
            case MNP: {
                posStart = variantPosStart;
                posEnd = posStart + (this.strandPlus ? 1 : -1) * (this.variant.size() - 1);
                break;
            }
            case INS: {
                posStart = variantPosStart;
                if (this.duplication) {
                    int lenAlt = this.alt().length();
                    if (lenAlt == 1) {
                        posEnd = posStart += this.strandPlus ? -1 : 0;
                        break;
                    }
                    if (this.strandPlus) {
                        posEnd = posStart - 1;
                        posStart -= lenAlt;
                        break;
                    }
                    posEnd = posStart;
                    posStart += lenAlt - 1;
                    break;
                }
                if (this.strandPlus) {
                    posEnd = posStart--;
                    break;
                }
                posEnd = posStart - 1;
                break;
            }
            case DEL: 
            case DUP: 
            case MIXED: 
            case INV: 
            case BND: {
                if (this.strandPlus) {
                    posStart = this.variant.getStart();
                    posEnd = this.variant.getEnd();
                    break;
                }
                posStart = this.variant.getEnd();
                posEnd = this.variant.getStart();
                break;
            }
            case INTERVAL: {
                return "";
            }
            default: {
                throw new RuntimeException("Unimplemented method for variant type " + String.valueOf((Object)this.variant.getVariantType()));
            }
        }
        if (posStart == posEnd) {
            return this.pos(posStart);
        }
        String ps = this.pos(posStart);
        String pe = this.pos(posEnd);
        if (ps == null || pe == null) {
            return null;
        }
        return ps + "_" + pe;
    }

    protected String pos(int pos) {
        if (this.tr == null) {
            return Integer.toString(pos + 1);
        }
        Exon ex = this.tr.findExon(pos);
        if (ex != null) {
            return this.posExon(pos);
        }
        Intron intron = this.tr.findIntron(pos);
        if (intron != null) {
            return this.posIntron(pos, intron);
        }
        if (this.isDownstream(pos)) {
            return this.posDownstream(pos);
        }
        if (this.isUpstream(pos)) {
            return this.posUpstream(pos);
        }
        if (debug) {
            Log.debug("Unknown HGVS position " + pos + ", transcript " + String.valueOf(this.tr));
        }
        return null;
    }

    protected String posDownstream(int pos) {
        int trEnd = this.tr.isStrandPlus() ? this.tr.getEnd() : this.tr.getStart();
        int baseNumTrEnd = this.tr.baseNumber2MRnaPos(trEnd);
        int baseNumCdsEnd = this.tr.baseNumber2MRnaPos(this.tr.getCdsEnd());
        int basesFromCdsEndToTrEnd = Math.abs(baseNumTrEnd - baseNumCdsEnd);
        int idx = basesFromCdsEndToTrEnd + Math.abs(pos - trEnd);
        return "*" + idx;
    }

    protected String posExon(int pos) {
        if (this.tr.isUtr3(pos)) {
            return this.posUtr3(pos);
        }
        if (this.tr.isUtr5(pos)) {
            return this.posUtr5(pos);
        }
        int idx = this.tr.baseNumberCds(pos, false) + 1;
        if (idx <= 0) {
            return null;
        }
        return "" + idx;
    }

    protected String posIntron(int pos, Intron intron) {
        int distanceRight;
        int posExon = -1;
        String posExonStr = "";
        int distanceLeft = Math.max(0, pos - intron.getStart()) + 1;
        if (distanceLeft < (distanceRight = Math.max(0, intron.getEnd() - pos) + 1)) {
            posExon = intron.getStart() - 1;
            posExonStr = intron.isStrandPlus() ? "+" : "-";
        } else if (distanceRight < distanceLeft) {
            posExon = intron.getEnd() + 1;
            posExonStr = intron.isStrandPlus() ? "-" : "+";
        } else {
            posExonStr = "+";
            posExon = this.strandPlus ? intron.getStart() - 1 : intron.getEnd() + 1;
        }
        int exonDistance = Math.abs(posExon - pos);
        int cdsLeft = Math.min(this.tr.getCdsStart(), this.tr.getCdsEnd());
        int cdsRight = Math.max(this.tr.getCdsStart(), this.tr.getCdsEnd());
        if (posExon >= cdsLeft && posExon <= cdsRight) {
            int distExonBase = this.tr.baseNumberCds(posExon, false) + 1;
            return distExonBase + (String)(exonDistance > 0 ? posExonStr + exonDistance : "");
        }
        int cdnaPos = this.tr.baseNumber2MRnaPos(posExon);
        if (posExon < cdsLeft) {
            int cdnaStart = this.tr.baseNumber2MRnaPos(cdsLeft);
            int utrDistance = Math.abs(cdnaStart - cdnaPos);
            String utrStr = this.strandPlus ? "-" : "*";
            return utrStr + utrDistance + (String)(exonDistance > 0 ? posExonStr + exonDistance : "");
        }
        int cdnaEnd = this.tr.baseNumber2MRnaPos(cdsRight);
        int utrDistance = Math.abs(cdnaEnd - cdnaPos);
        String utrStr = this.strandPlus ? "*" : "-";
        return utrStr + utrDistance + (String)(exonDistance > 0 ? posExonStr + exonDistance : "");
    }

    protected String posUpstream(int pos) {
        int trStart;
        int baseNumTss = this.tr.baseNumber2MRnaPos(this.tr.getCdsStart());
        int idx = baseNumTss + Math.abs(pos - (trStart = this.tr.isStrandPlus() ? this.tr.getStart() : this.tr.getEnd()));
        if (idx <= 0) {
            return null;
        }
        return "-" + idx;
    }

    protected String posUtr3(int pos) {
        int baseNumCdsEnd;
        int baseNum = this.tr.baseNumber2MRnaPos(pos);
        int idx = Math.abs(baseNum - (baseNumCdsEnd = this.tr.baseNumber2MRnaPos(this.tr.getCdsEnd())));
        if (idx <= 0) {
            return null;
        }
        return "*" + idx;
    }

    protected String posUtr5(int pos) {
        int baseNumTss;
        int baseNum = this.tr.baseNumber2MRnaPos(pos);
        int idx = Math.abs(baseNum - (baseNumTss = this.tr.baseNumber2MRnaPos(this.tr.getCdsStart())));
        if (idx <= 0) {
            return null;
        }
        return "-" + idx;
    }

    protected String prefixTranslocation() {
        VariantBnd vtr = (VariantBnd)this.variant;
        String chrCoords = "(" + vtr.getChromosomeName() + ";" + vtr.getEndPoint().getChromosomeName() + ")";
        String band1 = "";
        CytoBands cytoBands = this.genome.getCytoBands();
        Markers bands1 = cytoBands.query(vtr);
        if (!bands1.isEmpty()) {
            band1 = bands1.get(0).getId();
        }
        String band2 = "";
        Markers bands2 = cytoBands.query(vtr.getEndPoint());
        if (!bands2.isEmpty()) {
            band2 = bands2.get(0).getId();
        }
        String bands = "(" + band1 + ";" + band2 + ")";
        return "t" + chrCoords + bands + "(";
    }

    protected String ref() {
        return this.variant.getReference();
    }

    public String toString() {
        if (this.variant == null || this.genome == null) {
            return null;
        }
        if (this.variant.isIns()) {
            this.duplication = this.isDuplication();
        }
        String type = "";
        String prefix = "";
        String suffix = "";
        switch (this.variant.getVariantType()) {
            case INS: {
                type = this.duplication ? "dup" : "ins";
                break;
            }
            case DEL: {
                type = "del";
                break;
            }
            case MNP: {
                type = "";
                break;
            }
            case SNP: 
            case MIXED: 
            case INTERVAL: {
                type = "";
                break;
            }
            case INV: {
                type = "inv";
                break;
            }
            case DUP: {
                type = "dup";
                break;
            }
            case BND: {
                prefix = this.prefixTranslocation();
                type = "";
                suffix = ")";
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented method for variant type " + String.valueOf((Object)this.variant.getVariantType()));
            }
        }
        String pos = this.pos();
        if (pos == null) {
            return null;
        }
        if (Config.get().isHgvsOld() && type.isEmpty()) {
            String alt;
            String ref;
            if (this.strandPlus) {
                ref = this.ref();
                alt = this.alt();
            } else {
                ref = GprSeq.reverseWc(this.ref());
                alt = GprSeq.reverseWc(this.alt());
            }
            return prefix + this.typeOfReference() + ref + pos + alt + suffix;
        }
        return prefix + this.typeOfReference() + pos + type + this.dnaBaseChange() + suffix;
    }

    protected String typeOfReference() {
        String prefix;
        if (this.tr == null) {
            return "n.";
        }
        String string = prefix = this.tr.isProteinCoding() ? "c." : "n.";
        if (!this.hgvsTrId) {
            return prefix;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tr.getId());
        String ver = this.tr.getVersion();
        if (!ver.isEmpty()) {
            sb.append("." + ver);
        }
        sb.append(':');
        sb.append(prefix);
        return sb.toString();
    }
}

