/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.HashMap;
import java.util.Map;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.vcf.EffFormatVersion;

public enum EffectType {
    CHROMOSOME_LARGE_DELETION(VariantEffect.EffectImpact.HIGH),
    CHROMOSOME_LARGE_INVERSION(VariantEffect.EffectImpact.HIGH),
    CHROMOSOME_LARGE_DUPLICATION(VariantEffect.EffectImpact.HIGH),
    GENE_REARRANGEMENT(VariantEffect.EffectImpact.HIGH),
    GENE_DELETED(VariantEffect.EffectImpact.HIGH),
    TRANSCRIPT_DELETED(VariantEffect.EffectImpact.HIGH),
    EXON_DELETED(VariantEffect.EffectImpact.HIGH),
    EXON_DELETED_PARTIAL(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION_REVERESE(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION_HALF(VariantEffect.EffectImpact.HIGH),
    FRAME_SHIFT(VariantEffect.EffectImpact.HIGH),
    STOP_GAINED(VariantEffect.EffectImpact.HIGH),
    STOP_LOST(VariantEffect.EffectImpact.HIGH),
    START_LOST(VariantEffect.EffectImpact.HIGH),
    SPLICE_SITE_ACCEPTOR(VariantEffect.EffectImpact.HIGH),
    SPLICE_SITE_DONOR(VariantEffect.EffectImpact.HIGH),
    RARE_AMINO_ACID(VariantEffect.EffectImpact.HIGH),
    EXON_DUPLICATION(VariantEffect.EffectImpact.HIGH),
    EXON_DUPLICATION_PARTIAL(VariantEffect.EffectImpact.HIGH),
    EXON_INVERSION(VariantEffect.EffectImpact.HIGH),
    EXON_INVERSION_PARTIAL(VariantEffect.EffectImpact.HIGH),
    PROTEIN_PROTEIN_INTERACTION_LOCUS(VariantEffect.EffectImpact.HIGH),
    PROTEIN_STRUCTURAL_INTERACTION_LOCUS(VariantEffect.EffectImpact.HIGH),
    NON_SYNONYMOUS_CODING(VariantEffect.EffectImpact.MODERATE),
    GENE_DUPLICATION(VariantEffect.EffectImpact.MODERATE),
    TRANSCRIPT_DUPLICATION(VariantEffect.EffectImpact.MODERATE),
    UTR_5_DELETED(VariantEffect.EffectImpact.MODERATE),
    UTR_3_DELETED(VariantEffect.EffectImpact.MODERATE),
    SPLICE_SITE_BRANCH_U12(VariantEffect.EffectImpact.MODERATE),
    GENE_INVERSION(VariantEffect.EffectImpact.MODERATE),
    TRANSCRIPT_INVERSION(VariantEffect.EffectImpact.MODERATE),
    CODON_INSERTION(VariantEffect.EffectImpact.MODERATE),
    CODON_CHANGE_PLUS_CODON_INSERTION(VariantEffect.EffectImpact.MODERATE),
    CODON_DELETION(VariantEffect.EffectImpact.MODERATE),
    CODON_CHANGE_PLUS_CODON_DELETION(VariantEffect.EffectImpact.MODERATE),
    NON_SYNONYMOUS_STOP(VariantEffect.EffectImpact.LOW),
    NON_SYNONYMOUS_START(VariantEffect.EffectImpact.LOW),
    SPLICE_SITE_REGION(VariantEffect.EffectImpact.LOW),
    SPLICE_SITE_BRANCH(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_CODING(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_START(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_STOP(VariantEffect.EffectImpact.LOW),
    CODON_CHANGE(VariantEffect.EffectImpact.LOW),
    START_GAINED(VariantEffect.EffectImpact.LOW),
    MOTIF(VariantEffect.EffectImpact.LOW),
    MOTIF_DELETED(VariantEffect.EffectImpact.LOW),
    FEATURE_FUSION(VariantEffect.EffectImpact.LOW),
    FRAME_SHIFT_BEFORE_CDS_START(VariantEffect.EffectImpact.MODIFIER),
    FRAME_SHIFT_AFTER_CDS_END(VariantEffect.EffectImpact.MODIFIER),
    UTR_5_PRIME(VariantEffect.EffectImpact.MODIFIER),
    UTR_3_PRIME(VariantEffect.EffectImpact.MODIFIER),
    REGULATION(VariantEffect.EffectImpact.MODIFIER),
    MICRO_RNA(VariantEffect.EffectImpact.MODIFIER),
    UPSTREAM(VariantEffect.EffectImpact.MODIFIER),
    DOWNSTREAM(VariantEffect.EffectImpact.MODIFIER),
    NEXT_PROT(VariantEffect.EffectImpact.MODIFIER),
    INTRON_CONSERVED(VariantEffect.EffectImpact.MODIFIER),
    INTRON(VariantEffect.EffectImpact.MODIFIER),
    INTRAGENIC(VariantEffect.EffectImpact.MODIFIER),
    INTERGENIC_CONSERVED(VariantEffect.EffectImpact.MODIFIER),
    INTERGENIC(VariantEffect.EffectImpact.MODIFIER),
    CDS(VariantEffect.EffectImpact.MODIFIER),
    EXON(VariantEffect.EffectImpact.MODIFIER),
    TRANSCRIPT(VariantEffect.EffectImpact.MODIFIER),
    GENE(VariantEffect.EffectImpact.MODIFIER),
    SEQUENCE(VariantEffect.EffectImpact.MODIFIER),
    CHROMOSOME_ELONGATION(VariantEffect.EffectImpact.MODIFIER),
    CUSTOM(VariantEffect.EffectImpact.MODIFIER),
    CHROMOSOME(VariantEffect.EffectImpact.MODIFIER),
    GENOME(VariantEffect.EffectImpact.MODIFIER),
    NONE(VariantEffect.EffectImpact.MODIFIER);

    static Map<String, EffectType> so2efftype;
    private final VariantEffect.EffectImpact effectImpact;

    public static EffectType parse(EffFormatVersion formatVersion, String str) {
        try {
            return EffectType.valueOf(str);
        }
        catch (Exception exception) {
            if (so2efftype.isEmpty()) {
                EffectType.so2efftype(formatVersion, null);
                EffectType.so2efftype(formatVersion, Variant.NO_VARIANT);
            }
            if (so2efftype.containsKey(str)) {
                return so2efftype.get(str);
            }
            throw new RuntimeException("Cannot parse EffectType '" + str + "'");
        }
    }

    static void so2efftype(EffFormatVersion formatVersion, Variant variant) {
        for (EffectType efftype : EffectType.values()) {
            String so = efftype.toSequenceOntology(formatVersion, variant);
            for (String soSingle : so.split(formatVersion.separatorSplit())) {
                if (so2efftype.containsKey(soSingle)) continue;
                so2efftype.put(soSingle, efftype);
            }
        }
        HashMap<String, EffectType> oldSo2efftype = new HashMap<String, EffectType>();
        oldSo2efftype.put("non_coding_exon_variant", EXON);
        oldSo2efftype.put("inframe_insertion", CODON_INSERTION);
        oldSo2efftype.put("inframe_deletion", CODON_DELETION);
        oldSo2efftype.put("transcript", TRANSCRIPT);
        oldSo2efftype.put("non_canonical_start_codon", SYNONYMOUS_START);
        for (String so : oldSo2efftype.keySet()) {
            if (so2efftype.containsKey(so)) continue;
            so2efftype.put(so, (EffectType)((Object)oldSo2efftype.get(so)));
        }
    }

    private EffectType(VariantEffect.EffectImpact effectImpact) {
        this.effectImpact = effectImpact;
    }

    public VariantEffect.EffectImpact effectImpact() {
        return this.effectImpact;
    }

    public EffectType getGeneRegion() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: {
                return CHROMOSOME;
            }
            case 47: 
            case 60: 
            case 61: {
                return INTERGENIC;
            }
            case 54: {
                return UPSTREAM;
            }
            case 27: 
            case 44: 
            case 50: {
                return UTR_5_PRIME;
            }
            case 15: {
                return SPLICE_SITE_ACCEPTOR;
            }
            case 29: 
            case 39: {
                return SPLICE_SITE_BRANCH;
            }
            case 16: {
                return SPLICE_SITE_DONOR;
            }
            case 38: {
                return SPLICE_SITE_REGION;
            }
            case 5: 
            case 26: 
            case 31: 
            case 56: 
            case 59: 
            case 62: 
            case 64: {
                return TRANSCRIPT;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 25: 
            case 30: 
            case 65: {
                return GENE;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 63: {
                return EXON;
            }
            case 57: 
            case 58: {
                return INTRON;
            }
            case 28: 
            case 51: {
                return UTR_3_PRIME;
            }
            case 55: {
                return DOWNSTREAM;
            }
            case 52: {
                return REGULATION;
            }
            case 45: 
            case 46: {
                return MOTIF;
            }
            case 53: {
                return MICRO_RNA;
            }
            case 70: {
                return GENOME;
            }
        }
        throw new RuntimeException("Unknown gene region for effect type: '" + String.valueOf((Object)this) + "'");
    }

    public boolean isFusion() {
        return this == GENE_FUSION || this == GENE_FUSION_REVERESE || this == GENE_FUSION_HALF || this == FEATURE_FUSION;
    }

    public String toSequenceOntology(EffFormatVersion formatVersion, Variant variant) {
        switch (this.ordinal()) {
            case 62: {
                return "coding_sequence_variant";
            }
            case 0: {
                return "chromosome_number_variation";
            }
            case 2: {
                return "duplication";
            }
            case 1: {
                return "inversion";
            }
            case 69: {
                return "chromosome";
            }
            case 67: {
                return "feature_elongation";
            }
            case 43: {
                return "coding_sequence_variant";
            }
            case 33: {
                return "disruptive_inframe_insertion";
            }
            case 35: {
                return "disruptive_inframe_deletion";
            }
            case 34: {
                return "conservative_inframe_deletion";
            }
            case 32: {
                return "conservative_inframe_insertion";
            }
            case 55: {
                return "downstream_gene_variant";
            }
            case 63: {
                if (variant != null && (!variant.isVariant() || variant.isInterval())) {
                    return "exon_region";
                }
                return "non_coding_transcript_exon_variant";
            }
            case 6: {
                return "exon_loss_variant";
            }
            case 7: {
                return "exon_loss_variant";
            }
            case 18: {
                return "duplication";
            }
            case 19: {
                return "duplication";
            }
            case 20: {
                return "inversion";
            }
            case 21: {
                return "inversion";
            }
            case 47: {
                return "feature_fusion";
            }
            case 11: {
                return "frameshift_variant";
            }
            case 48: {
                return "start_retained_variant";
            }
            case 49: {
                return "stop_retained_variant";
            }
            case 65: {
                return "gene_variant";
            }
            case 30: {
                return "inversion";
            }
            case 4: {
                return "feature_ablation";
            }
            case 25: {
                return "duplication";
            }
            case 8: {
                return "gene_fusion";
            }
            case 10: {
                return "transcript_ablation";
            }
            case 9: {
                return "bidirectional_gene_fusion";
            }
            case 3: {
                return "rearranged_at_DNA_level";
            }
            case 61: {
                return "intergenic_region";
            }
            case 60: {
                return "conserved_intergenic_variant";
            }
            case 58: {
                return "intron_variant";
            }
            case 57: {
                return "conserved_intron_variant";
            }
            case 59: {
                return "intragenic_variant";
            }
            case 53: {
                return "miRNA";
            }
            case 45: {
                return "TF_binding_site_variant";
            }
            case 46: {
                return "TFBS_ablation";
            }
            case 56: {
                return "sequence_feature";
            }
            case 24: {
                return "missense_variant";
            }
            case 37: {
                return "initiator_codon_variant";
            }
            case 36: {
                return "stop_retained_variant";
            }
            case 22: {
                return "protein_protein_contact";
            }
            case 23: {
                return "structural_interaction_variant";
            }
            case 17: {
                return "rare_amino_acid_variant";
            }
            case 52: {
                return "regulatory_region_variant";
            }
            case 15: {
                return "splice_acceptor_variant";
            }
            case 16: {
                return "splice_donor_variant";
            }
            case 38: {
                return "splice_region_variant";
            }
            case 39: {
                return "splice_branch_variant";
            }
            case 29: {
                return "splice_branch_variant";
            }
            case 14: {
                return "start_lost";
            }
            case 44: {
                return "5_prime_UTR_premature_start_codon_gain_variant";
            }
            case 12: {
                return "stop_gained";
            }
            case 13: {
                return "stop_lost";
            }
            case 40: {
                return "synonymous_variant";
            }
            case 42: {
                return "stop_retained_variant";
            }
            case 41: {
                return "start_retained_variant";
            }
            case 64: {
                return "non_coding_transcript_variant";
            }
            case 5: {
                return "transcript_ablation";
            }
            case 26: {
                return "duplication";
            }
            case 31: {
                return "inversion";
            }
            case 54: {
                return "upstream_gene_variant";
            }
            case 51: {
                return "3_prime_UTR_variant";
            }
            case 28: {
                return "3_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case 50: {
                return "5_prime_UTR_variant";
            }
            case 27: {
                return "5_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case 68: {
                return "custom";
            }
            case 66: 
            case 70: 
            case 71: {
                return "";
            }
        }
        throw new RuntimeException("Unknown SO term for " + this.toString());
    }

    static {
        so2efftype = new HashMap<String, EffectType>();
    }
}

